/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.util;

import java.util.List;

import com.ksk.contacts.R;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.TextView;

public class CheckboxListAdapter extends BaseAdapter implements OnCheckedChangeListener {

	public class ListData {
		//View(固定)
		public String  name;
		public boolean chkbox;

		//付加データ(任意)
		public Integer id;
	}

	//メンバーリスト情報
	private List<ListData>   mListData;

	//Context情報
	private Context        mContext;

	//コンストラクタ
    public CheckboxListAdapter(Context context) {
    	mContext  = context;
	}

    /**
     * @param dataList
     */
    public void setDataList(List<ListData> dataList) {
    	mListData = dataList;
	}

	/* (非 Javadoc)
	 * @see android.widget.Adapter#getCount()
	 */
	@Override
    public int getCount() {
    	return mListData.size();
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getItem(int)
     */
    @Override
    public Object getItem(int position) {
    	return mListData.get(position);
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getItemId(int)
     */
    @Override
    public long getItemId(int position) {
    	return position;
    }

    /* (非 Javadoc)
     * @see android.widget.Adapter#getView(int, android.view.View, android.view.ViewGroup)
     */
    public View getView(int position, View convertView, ViewGroup parent) {

		//レイアウトの取得
		LayoutInflater inflater = (LayoutInflater)mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View v = inflater.inflate(R.layout.chklist, null);
		TextView name   = (TextView) v.findViewById(R.id.name);
		CheckBox chkbox = (CheckBox) v.findViewById(R.id.chkbox);
		chkbox.setOnCheckedChangeListener(this);
		chkbox.setTag(position);

		//選択位置を元にリスト情報を取得する。
		ListData item = (ListData) getItem(position);

		//リスト情報がNULLではない、かつHolderがNULLでない場合は、各情報の設定を行う。
		if(item != null){

			//リスト名の表示
			name.setText(item.name);

			//チェックボックスのデフォルト設定
			chkbox.setChecked(item.chkbox);
		}

		return v;
    }

	@Override
	public void onCheckedChanged(CompoundButton arg0, boolean arg1) {
		Integer pos = (Integer)arg0.getTag();
		mListData.get(pos).chkbox = arg1;
	}
}
