/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.util;

import com.ksk.contacts.R;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.PreferenceActivity;

public class menu extends PreferenceActivity implements OnSharedPreferenceChangeListener {

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		// TODO 自動生成されたメソッド・スタブ
		super.onSaveInstanceState(outState);
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {

		super.onCreate(savedInstanceState);

		//Preference画面設定
		addPreferencesFromResource(R.xml.pref);

		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);

		//短縮ダイヤルの設定状況を表示(1～5まで)
		for(int i=1; i<=5; i++){
			EditTextPreference edittext_preference = (EditTextPreference)getPreferenceScreen().findPreference("edittext_key" + i);
			if((edittext_preference.getText() != null) && (!edittext_preference.getText().equals(""))){
				edittext_preference.setSummary(edittext_preference.getText());
			}else{
				edittext_preference.setSummary("未登録");
			}
		}
	}

	@Override
	public void onSharedPreferenceChanged(SharedPreferences arg0, String arg1) {

		//短縮ダイヤルの設定状況を表示(1～5まで)
		for(int i=1; i<=5; i++){
			EditTextPreference edittext_preference = (EditTextPreference)getPreferenceScreen().findPreference("edittext_key" + i);
			if((edittext_preference.getText() != null) && (!edittext_preference.getText().equals(""))){
				edittext_preference.setSummary(edittext_preference.getText());
			}else{
				edittext_preference.setSummary("未登録");
			}
		}
	}
}
