/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ksk.contacts.util;

import java.util.ArrayList;
import java.util.List;

import com.ksk.contacts.util.ContactMgr.ContactInfo;

import android.graphics.Bitmap;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class CommonData {

	//送信種別
	public final Integer SEND_KIND_NONE = 0;    //無し

	public final Integer SEND_KIND_TEL  = 1;    //音声発信

	public final Integer SEND_KIND_MAIL = 2;    //Email

	//カスタム送信パターンクラス
	public class SendPattern {
		public Integer kind;    //送信種別
		public String  send;    //送信情報(電話番号/Emailアドレス 等)
	}

	//メンバー情報クラス
	public class MemberInfo {
		public String       tag;
		public Integer      contact_id;    //ContactID
		public Bitmap       photo;         //ユーザー画像ID(リソースID)
		public String       name;          //ユーザー名(フルネーム)
		public String       tel;           //電話番号
		public String       email;         //Emailアドレス
		public SendPattern  custom;        //カスタム送信
		public ContactInfo  info;

		//コンストラクタ
		public MemberInfo(){
			//カスタム送信構造体の初期設定
			custom = new SendPattern();
			custom.kind = SEND_KIND_NONE;
		}

		@Override
		public String toString() {
			String serch_key = "";
			if(info == null) return serch_key;

			serch_key = info.dispname + "," + info.yomi + ",";
			for(int i=0; i<info.phone.size(); i++){
				serch_key = serch_key + info.phone.get(i).number + ",";
			}
			for(int i=0; i<info.email.size(); i++){
				serch_key = serch_key + info.email.get(i).number + ",";
			}
			return serch_key;
		}
	}

	//グループリスト情報クラス
	public class GroupListData {
		public Integer        group_id;
		public String         group_title;
		public List<MemberInfo> member_list;

		public GroupListData(){
			member_list = new ArrayList<MemberInfo>();
		}
	}

	/* メンバーリスト(Adapter用)表示Holder */
	public class MemberInfoHolder {
		public ImageView   user;           //ユーザー画像用View
		public TextView    name;           //ユーザー名用View
		public ImageView   tel;            //音声発信ボタン用View
		public ImageView   email;          //Emailボタン用View
		public ImageView   custom;         //カスタムボタン用View
		public MemberInfo  data;        //メンバー情報

		public TextView       tag1;        //索引用の行View
		public LinearLayout   tag2;        //ﾒﾝﾊﾞｰ表示用View(一括して表示/非表示切り換えに使用する)
	}

	//AppWidgetレイアウト定義
	public final int APPWIDGET_2_1 = 0;    //レイアウト(2×1)

	public final int APPWIDGET_3_1 = 1;    //レイアウト(2×1)

	//オプションメニュー
	public static final int MENU_SELECT_ADD       = 0;

	public static final int MENU_SELECT_EDIT      = 1;

	public static final int MENU_SELECT_DEL       = 2;

	public static final int MENU_SELECT_SHORTCUT  = 3;

	public static final int MENU_SELECT_SET       = 4;
}
