/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTML.Tag;
import javax.swing.text.html.HTMLEditorKit.ParserCallback;
import javax.swing.text.html.parser.ParserDelegator;

/**
 *
 * @author d
 */
public class LoginPageParser {
    
    private class LoginPageParserCallback extends ParserCallback {

        private boolean isTitleChildNode = false;

        @Override
        public void handleStartTag(Tag t, MutableAttributeSet a, int pos) {
            super.handleSimpleTag(t, a, pos);
            if (HTML.Tag.TITLE.equals(t)) {
                isTitleChildNode = true;
            }
        }

        @Override
        public void handleEndTag(Tag t, int pos) {
            super.handleEndTag(t, pos);
            if (HTML.Tag.TITLE.equals(t)) {
                isTitleChildNode = false;
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            super.handleText(data, pos);
            if (isTitleChildNode == true) {
                title = new String(data);
            }
        }
    }

    /** ログイン成否 */
    private boolean login = false;
    /** タイトル */
    private String title = null;

    public LoginPageParser(Reader reader) throws IOException {
        ParserDelegator parserDelegator = new ParserDelegator();
        ParserCallback parserCallback = new LoginPageParserCallback();
        
        try {
            parserDelegator.parse(reader, parserCallback, true);
        } catch (IOException e) {
            throw e;
        }
        
        if ("DAMステーション[ club DAM.com ]".equals(title)) {
            login = true;
        }
    }
    
    public boolean isLogin(){
        return login;
    }
    
}
