/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author d
 */
public class ConfigData {
    /** デフォルト接続タイムアウト時間 */
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    /** デフォルト読み込みタイムアウト時間 */
    public static final int DEFAULT_READ_TIMEOUT = 5000;
    
    /** カード番号 (not null) */
    private String cardNumber = "";
    /** password (not null) */
    private String password = "";
    /** connectTimeout (0以上) */
    private int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    /** readTimeout (0以上) */
    private int readTimeout = DEFAULT_READ_TIMEOUT;
    /** プロキシ (null可能) */
    private Proxy proxy = null;
    
    /**
     * 設定データを初期化する
     * @param filePath
     */
    public ConfigData(String filePath) {
        if (filePath == null) {
            throw new NullPointerException("ConfigData.ConfigData\n\tfilePath=" + filePath);
        }
        
        BufferedReader reader = null;
        try {
            // ファイルを読み出す準備
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(filePath), "UTF-8"));
            
            // DOMオブジェクト作成
            DOMParser parser = new DOMParser();
            
            parser.parse(new InputSource(reader));
            Document dom = parser.getDocument();
            
            // ルート要素の取得
            Element root = DomUtility.getRootElementByTagName(dom, "config");
            
            // 各値の取得
            this.cardNumber = DomUtility.getSingleTextContentByTagName(root, "cardNumber");
            this.password = DomUtility.getSingleTextContentByTagName(root, "password");
            this.connectTimeout = Integer.parseInt(DomUtility.getSingleTextContentByTagName(root, "connectTimeout"));
            this.readTimeout = Integer.parseInt(DomUtility.getSingleTextContentByTagName(root, "readTimeout"));
            
            // プロキシの取得
            NodeList proxyList = root.getElementsByTagName("proxy");
            switch (proxyList.getLength()) {
                case 0:
                    this.proxy = null;
                    break;
                case 1:
                    Element proxyElement = (Element) proxyList.item(0);
                    this.proxy = new Proxy(
                            DomUtility.getSingleTextContentByTagName(proxyElement, "host"),
                            Integer.parseInt(DomUtility.getSingleTextContentByTagName(proxyElement, "port")));
                    break;
                default:
                    throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\tproxyList.getLength()=" + proxyList.getLength());
            }
        } catch (FileNotFoundException e) {
            // 何も処理しない
            System.out.println("ファイルが存在しません");
        } catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\te=" + e);
        } catch (SAXException e) {
            throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\te=" + e);
        } catch (IOException e) {
            throw new IllegalStateException("ConfigData.ConfigData\n\tfilePath=" + filePath + "\n\te=" + e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch(IOException e) {
                }
            }
        }
    }

    public void setCardNumber(String cardNumber) {
        if (cardNumber == null) {
            throw new NullPointerException("ConfigData.setCardNumber\n\tcardNumber=" + cardNumber);
        }
        this.cardNumber = cardNumber;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("ConfigData.setConnectTimeout\n\tconnectTimeout=" + connectTimeout);
        }
        this.connectTimeout = connectTimeout;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new NullPointerException("ConfigData.setPassword\n\tpassword=" + password);
        }
        this.password = password;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("ConfigData.setReadTimeout\n\treadTimeout=" + readTimeout);
        }
        this.readTimeout = readTimeout;
    }

    public String getCardNumber() {
        return cardNumber;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public String getPassword() {
        return password;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public Proxy getProxy() {
        return proxy;
    }
    
    /**
     * XMLファイル出力
     * @param filePath
     * @throws java.io.IOException
     */
    public void writeXml(String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("ConfigData.writeXml\n\tfilePath=" + filePath);
        }
   
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filePath), "UTF-8")));
            
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<config>");
            writer.println("\t" + DomUtility.toElementString("cardNumber", DomUtility.escapeXmlEntityCharacter(this.cardNumber)));
            writer.println("\t" + DomUtility.toElementString("password", DomUtility.escapeXmlEntityCharacter(this.password)));
            writer.println("\t" + DomUtility.toElementString("connectTimeout", Integer.toString(this.connectTimeout)));
            writer.println("\t" + DomUtility.toElementString("readTimeout", Integer.toString(this.readTimeout)));
            if (null != this.proxy) {
                writer.println("\t" + DomUtility.toElementString("proxy",
                        "\n\t\t" + DomUtility.toElementString("host", DomUtility.escapeXmlEntityCharacter(this.proxy.getHost())) + "\n\t\t" + DomUtility.toElementString("port", Integer.toString(this.proxy.getPort())) + "\n\t"));
            }
            writer.println("</config>");
        } catch(IOException e) {
            throw new IOException("ConfigData.writeXml\n\tfilePath=" + filePath + "\n\te=" + e.toString());
        } finally {
            if(null != writer) {
                writer.close();
            } 
        }
    }
    
    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{cardNumber=");
        buffer.append(this.cardNumber);
        buffer.append(", password=");
        buffer.append(this.password);
        buffer.append(", connectTimeout=");
        buffer.append(this.connectTimeout);
        buffer.append(", readTimeout=");
        buffer.append(this.readTimeout);
        buffer.append(", proxy=");
        buffer.append(this.proxy);
        buffer.append("}");
        
        return buffer.toString();
    }
}
