/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author d
 */
public class DomUtility {
    private DomUtility() {}
    
    /**
     * 指定したタグ名のルート要素を取得する
     * @param dom DOMオブジェクト
     * @param tagName タグ名
     * @return
     */
    public static Element getRootElementByTagName(Document dom, String tagName) {
        if ((dom == null) || (tagName == null)) {
            throw new NullPointerException("DomUtility.getRootElementByTagName\n\tdom=" + dom + "\n\ttagName=" + tagName);
        }
        
        Element root = dom.getDocumentElement();
        if (!tagName.equals(root.getNodeName())) {
            throw new IllegalStateException("DomUtility.getRootElementByTagName\n\tdom=" + dom + "\n\ttagName=" + tagName + "\n\troot=" + root);
        }
        
        return root;
    }
    
    /**
     * 指定したタグ名の要素が一つで、その要素が子要素にテキストノード一つのみを持っている場合にそのテキストノードの値を返す
     * その要素が子要素を一つも持っていない場合は空文字列を返す
     * @param element
     * @param tagName
     * @return
     */
    public static String getSingleTextContentByTagName(Element element, String tagName) {
        if ((element == null) || (tagName == null)) {
            throw new NullPointerException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName);
        } else if (tagName.isEmpty()) {
            throw new IllegalArgumentException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName);
        }
        
        NodeList elements = element.getElementsByTagName(tagName);
        if (elements.getLength() != 1) {
            throw new IllegalStateException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName + "\n\telements.getLength()=" + elements.getLength());
        }
        
        NodeList textNodes = elements.item(0).getChildNodes();
        switch (textNodes.getLength()) {
            case 0:
                return "";
            case 1:
                Node textNode = textNodes.item(0);
                if (Node.TEXT_NODE != textNode.getNodeType()) {
                    throw new IllegalStateException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName + "\n\ttextNode.getNodeType()=" + textNode.getNodeType());
                }
                
                return textNode.getNodeValue();
            default:
                throw new IllegalStateException("DomUtility.getSingleTextContentByTagName\n\telement=" + element + "\n\ttagName=" + tagName + "\n\ttextNodes.getLength()=" + textNodes.getLength());
        }
    }
    
    /**
     * 属性の値を取得する
     * (指定した属性が存在しない場合は例外発生)
     * @param element
     * @param attributeName
     * @return
     */
    public static String getAttribute(Element element, String attributeName) {
        if ((element == null) || (attributeName == null)) {
            throw new NullPointerException("DomUtility.getAttribute\n\telement=" + element + "\n\tattributeName=" + attributeName);
        } else if (attributeName.isEmpty()) {
            throw new IllegalArgumentException("DomUtility.getAttribute\n\telement=" + element + "\n\tattributeName=" + attributeName);
        }
        
        String value = element.getAttribute(attributeName);
        if (value.isEmpty()) {
            throw new IllegalStateException("DomUtility.getAttribute\n\telement=" + element + "\n\tattributeName=" + attributeName + "\n\tvalue=" + value);
        }
        return value;
    }
    
    /**
     * タグ名とその子要素のテキストノードの値を指定して、文字列を作成する
     * @param tagName
     * @param textContent
     * @return
     */
    public static String toElementString(String tagName, String textContent) {
        if (tagName == null) {
            throw new NullPointerException("DomUtility.toElementString\n\ttagName=" + tagName + "\n\ttextContent=" + textContent);
        } else if (tagName.isEmpty()) {
            throw new IllegalArgumentException("DomUtility.toElementString\n\ttagName=" + tagName + "\n\ttextContent=" + textContent);
        }
        
        if (textContent.isEmpty()) {
            textContent = "";
        }
        
        StringBuffer buffer = new StringBuffer();
        buffer.append("<");
        buffer.append(tagName);
        buffer.append(">");
        buffer.append(textContent);
        buffer.append("</");
        buffer.append(tagName);
        buffer.append(">");
                
        return buffer.toString();
    }
    
    /**
     * 特殊文字( <>"'& )をエスケープする
     * @param str
     * @return
     */
    public static String escapeXmlEntityCharacter(String str) {
        if (str == null) {
            throw new NullPointerException();
        } else if (str.isEmpty()) {
            return "";
        }
        
        StringBuffer buffer = new StringBuffer();
        for (int pos = 0; pos < str.length(); pos++) {
            switch (str.charAt(pos)) {
                case '<':
                    buffer.append("&lt;");
                    break;
                case '>':
                    buffer.append("&gt;");
                    break;
                case '"':
                    buffer.append("&quot;");
                    break;
                case '\'':
                    buffer.append("&apos;");
                    break;
                case '&':
                    buffer.append("&amp;");
                    break;
                default:
                    buffer.append(str.charAt(pos));
                    break;
            }
        }
        
        return buffer.toString();
    }
}
