/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

/**
 *
 * @author d
 */
public class Proxy {

    private final String host;
    private final int port;

    public Proxy(String host, int port) {
        if (host == null) {
            throw new NullPointerException("Proxy.Proxy\n\thost=" + host + "\n\tport=" + port);
        } else if(host.isEmpty() || (port < 0) || (port > 65535)) {
            throw new IllegalArgumentException("Proxy.Proxy\n\thost=" + host + "\n\tport=" + port);
        }
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }
    
    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{host=");
        buffer.append(this.host);
        buffer.append(", port=");
        buffer.append(this.port);
        buffer.append("}");
        
        return buffer.toString();
    }
}
