/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.sourceforge.damstation_dl.data;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 *
 * @author d
 */
public class ResultDataList {
    /** 結果リスト */
    private Map<ResultDate, ResultData> map = new HashMap<ResultDate, ResultData>();
    
    /**
     * 結果リストの初期化(空)
     */
    public ResultDataList() {}
    
    /**
     * 結果リストの初期化
     * @param filePath
     */
    public ResultDataList(String filePath) {
        if (filePath == null) {
            throw new NullPointerException("ResultDataList.ResultDataList\n\tfilePath=" + filePath);
        }

        InputStreamReader reader = null;
        try {
            // ファイルを読み出す準備
            reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(filePath)), "UTF-8");

            // DOMオブジェクト作成
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(reader));
            Document dom = parser.getDocument();

            // ルート要素の取得
            Element root = DomUtility.getRootElementByTagName(dom, "results");

            // 曲要素のループ
            NodeList resultElementList = root.getElementsByTagName("result");
            for (int i = 0; i < resultElementList.getLength(); i++) {
                Element resultElement = (Element) resultElementList.item(i);

                // 各値取得
                ResultDate date = ResultDate.getInstance(DomUtility.getAttribute(resultElement, "date"));
                
                // dateが既出でなければ追加
                if (this.hasResultData(date)) {
                    throw new IllegalStateException("ResultDataList.ResultDataList samed date.\n\tdate=" + date);
                }
                
                SongId id = SongId.getInstance(DomUtility.getSingleTextContentByTagName(resultElement, "id"));
                double score = Double.parseDouble(DomUtility.getSingleTextContentByTagName(resultElement, "score"));
                byte vibratoType = Byte.parseByte(DomUtility.getSingleTextContentByTagName(resultElement, "vType"));
                double vibratoTime = Double.parseDouble(DomUtility.getSingleTextContentByTagName(resultElement, "vTime"));
                short shakuri = Short.parseShort(DomUtility.getSingleTextContentByTagName(resultElement, "shakuri"));
                byte interval = Byte.parseByte(DomUtility.getSingleTextContentByTagName(resultElement, "interval"));
                byte rhythm = Byte.parseByte(DomUtility.getSingleTextContentByTagName(resultElement, "rhythm"));
                byte modulation = Byte.parseByte(DomUtility.getSingleTextContentByTagName(resultElement, "modulation"));
                ResultData data = new ResultData(
                        id,
                        score,
                        vibratoType,
                        vibratoTime,
                        shakuri,
                        interval,
                        rhythm,
                        modulation);
                
                this.add(date, data);
            }
        } catch (FileNotFoundException e) {
            // ファイルが存在しない場合は各値にデフォルト値を使用する
        } catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ResultDataList.ResultDataList\n\tfilePath=" + filePath + "\n\te=" + e);
        } catch (SAXException e) {
            throw new IllegalStateException("ResultDataList.ResultDataList\n\tfilePath=" + filePath + "\n\te=" + e);
        } catch (IOException e) {
            throw new IllegalStateException("ResultDataList.ResultDataList\n\tfilePath=" + filePath + "\n\te=" + e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                }
            }
        }
    }

    /**
     * dateの既出チェック
     * @param date
     * @return
     */
    public boolean hasResultData(ResultDate date) {
        if (date == null) {
            throw new NullPointerException("ResultDataList.hasResultData\n\tdate=" + date);
        }

        // ループで現在登録されているIDと比較する
        return this.map.containsKey(date);
    }

    /**
     * mapに追加する
     * @param date
     * @param data
     */
    public void add(ResultDate date, ResultData data) {
        if ((date == null) || (data == null)) {
            throw new NullPointerException("ResultDataList.add\n\tdate=" + date + "\n\tdata=" + data);
        }
        this.map.put(date, data);
    }

    /**
     * XMLファイル出力
     * @param filePath
     * @throws java.io.IOException
     */
    public void writeXml(String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("ResultDataList.writeXml\n\tfilePath=" + filePath);
        }
        
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filePath), "UTF-8")));
            
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<results>");
            
            for (Map.Entry<ResultDate, ResultData> entry : this.map.entrySet()) {
                writer.println("\t<result date=\"" + entry.getKey().getValue() + "\">");
                writer.println("\t\t" + DomUtility.toElementString("id", entry.getValue().getId().getValue()));
                writer.println("\t\t" + DomUtility.toElementString("score", Double.toString(entry.getValue().getScore())));
                writer.println("\t\t" + DomUtility.toElementString("vType", Byte.toString(entry.getValue().getVibratoType())));
                writer.println("\t\t" + DomUtility.toElementString("vTime", Double.toString(entry.getValue().getVibratoTime())));
                writer.println("\t\t" + DomUtility.toElementString("shakuri", Short.toString(entry.getValue().getShakuri())));
                writer.println("\t\t" + DomUtility.toElementString("interval", Byte.toString(entry.getValue().getInterval())));
                writer.println("\t\t" + DomUtility.toElementString("rhythm", Byte.toString(entry.getValue().getRhythm())));
                writer.println("\t\t" + DomUtility.toElementString("modulation", Byte.toString(entry.getValue().getModulation())));
                writer.println("\t</result>");
            }
            
            writer.println("</results>");
        } catch(IOException e) {
            throw new IOException("ResultDataList.writeXml\n\tfilePath=" + filePath + "\n\te=" + e);
        } finally {
            if(null != writer) {
                writer.close();
            } 
        }
    }
    
    @Override
    public String toString() {
        return this.map.toString();
    }
}
