/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 *
 * @author d
 */
public class ResultDate {
    private static final int DAM_STATION_DATE_LENGTH = 19;
    private static final int XML_DATE_LENGTH = 19;
    
    /** DAMステーションの日付フォーマット */
    private static final DateFormat DAM_STATION_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.JAPANESE);
    /** XMLファイルの日付フォーマット */
    private static final DateFormat XML_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.JAPANESE);
    
    private static final Map<String, ResultDate> map = new HashMap<String, ResultDate>();
    
    static {
        // 厳密にチェックする
        ResultDate.DAM_STATION_DATE_FORMAT.setLenient(false);
        ResultDate.XML_DATE_FORMAT.setLenient(false);
    }
    
    private String value;
    
    private ResultDate(String date) {
        if (date == null) {
            throw new NullPointerException("ResultDate.ResultDate\n\tdate=" + date);
        } else if (!ResultDate.isValid(date)) {
            throw new IllegalArgumentException("ResultDate.ResultDate\n\tdate=" + date);
        }
        this.value = date;
    }
    
    public static ResultDate getInstance(String date) {
        if (ResultDate.map.containsKey(date)) {
            return ResultDate.map.get(date);
        } else {
            ResultDate instance = new ResultDate(date);
            ResultDate.map.put(date, instance);
            return instance;
        }
    }
    
    public static boolean isValid(String xmlDateString) {
        if (xmlDateString == null) {
            throw new NullPointerException("ResultData.isValidDate\n\txmlDateString=" + xmlDateString);
        }
        
        if (xmlDateString.length() != ResultDate.XML_DATE_LENGTH) {
            return false;
        }
        
        Date date = null;
        try {
            date = ResultDate.XML_DATE_FORMAT.parse(xmlDateString);
        } catch(ParseException e) {
            return false;
        }
        
        return true;
    }
    
    /**
     * DAMステーションの形式の時刻文字列をXML用の時刻文字列に変換する
     * @param damStationDate
     * @return
     */
    public static String damStationDateToXmlDateTime(String damStationDateString) throws ParseException {
        if (damStationDateString == null) {
            throw new NullPointerException("ResultDate.damStationDateToXmlDateTime\n\tdamStationDateString=" + damStationDateString);
        } else if (damStationDateString.length() < ResultDate.DAM_STATION_DATE_LENGTH) {
            throw new ParseException("ResultDate.damStationDateToXmlDateTime too short string.\n\tdamStationDateString=" + damStationDateString, damStationDateString.length());
        } else if (damStationDateString.length() > ResultDate.DAM_STATION_DATE_LENGTH) {
            throw new ParseException("ResultDate.damStationDateToXmlDateTime too long string.\n\tdamStationDateString=" + damStationDateString, ResultDate.DAM_STATION_DATE_LENGTH + 1);
        }
        
        Date date = null;
        date = ResultDate.DAM_STATION_DATE_FORMAT.parse(damStationDateString);
        return ResultDate.XML_DATE_FORMAT.format(date);
    }
    
    public String getValue() {
        return this.value;
    }
    
    @Override
    public String toString() {
        return this.value;
    }
}
