/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author d
 */
public class ConfigDataTest {
    public static final String NOT_FOUND_FILE_NAME = "hoge.foo";

    public ConfigDataTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testConfigData() {
        System.out.println("ConfigData");
        
        // null
        try {
            ConfigData data = new ConfigData(null);
            Assert.fail("ConfigData:NULLチェックに失敗");
        } catch(NullPointerException e) {
        }
        
        // ファイルが存在しない
        {
            ConfigData data = null;
            try {
                data = new ConfigData(NOT_FOUND_FILE_NAME);
            } catch (Exception e) {
                Assert.fail("ConfigData:ファイルが存在しないときに例外発生" + e.toString());
            }
            Assert.assertTrue("ConfigData:ファイルが存在しないときのカード番号の初期化に失敗", "".equals(data.getCardNumber()));
            Assert.assertTrue("ConfigData:ファイルが存在しないときのパスワードの初期化に失敗", "".equals(data.getPassword()));
            Assert.assertTrue("ConfigData:ファイルが存在しないときの接続タイムアウト時間の初期化に失敗\n" + ConfigData.DEFAULT_CONNECT_TIMEOUT + " == " + data.getConnectTimeout(), ConfigData.DEFAULT_CONNECT_TIMEOUT == data.getConnectTimeout());
            Assert.assertTrue("ConfigData:ファイルが存在しないときの読み込みタイムアウト時間の初期化に失敗", ConfigData.DEFAULT_READ_TIMEOUT == data.getReadTimeout());
            Assert.assertTrue("ConfigData:ファイルが存在しないときのプロキシの初期化に失敗", data.getProxy() == null);
        }
        
        // 成功例(Proxy無し)
        {
            ConfigData data = null;
            try {
                data = new ConfigData("testData/config_valid_no_proxy.xml");
                Assert.assertTrue("ConfigData 成功例(Proxy無し): カード番号が不一致", ("12345").equals(data.getCardNumber()));
                Assert.assertTrue("ConfigData 成功例(Proxy無し): パスワードが不一致", ("6789").equals(data.getPassword()));
                Assert.assertTrue("ConfigData 成功例(Proxy無し): 接続タイムアウト時間が不一致 " + data.getConnectTimeout(), 1 == data.getConnectTimeout());
                Assert.assertTrue("ConfigData 成功例(Proxy無し): 読み込みタイムアウト時間が不一致", 2 == data.getReadTimeout());
                Assert.assertTrue("ConfigData 成功例(Proxy無し): プロキシが不一致", null == data.getProxy());
                        
            } catch(Exception e) {
                Assert.fail("ConfigData 成功例(Proxy無し): 例外発生\n" + e.toString());
            }
        }
        
        Assert.fail("TODO");
        
        // 存在するが文字コードがおかしい()
        
        // 閉じたタグを一つ消してみる
        
        // ルート要素なし
        
        // ルート要素の名前が違う
        
        // 
    }
    
    /**
     * Test of setCardNumber method, of class ConfigData.
     */
    @Test
    public void testSetCardNumber() {
        System.out.println("setCardNumber");
        
        ConfigData data = new ConfigData(NOT_FOUND_FILE_NAME);

        // null
        try {
            data.setCardNumber(null);
        } catch(NullPointerException e) {
            // 成功
        } catch(Exception e) {
            Assert.fail("setCardNumber(null):違う例外発生");
        }
        
        // 成功例
        try {
            data.setCardNumber("12345");
            Assert.assertTrue("setCardNumber(\"12345\"):値が不一致", "12345".equals(data.getCardNumber()));
        } catch(Exception e) {
            Assert.fail("setCardNumber(\"12345\"):例外発生");
        }
    }

    /**
     * Test of setConnectTimeout method, of class ConfigData.
     */
    @Test
    public void testSetConnectTimeout() {
        System.out.println("setConnectTimeout");
        
        ConfigData data = new ConfigData(NOT_FOUND_FILE_NAME);
        
        // -1
        try {
            data.setConnectTimeout(-1);
        } catch(IllegalArgumentException e) {
            // 成功
        } catch(Exception e) {
            Assert.fail("setConnectTimeout(-1):違う例外発生");
        }
        
        // 0
        try {
            data.setConnectTimeout(0);
            Assert.assertTrue("setConnectTimeout(0):値が不一致", 0 == data.getConnectTimeout());
        } catch(Exception e) {
            Assert.fail("setConnectTimeout(0):例外発生");
        }
    }

    /**
     * Test of setPassword method, of class ConfigData.
     */
    @Test
    public void testSetPassword() {
        System.out.println("setPassword");
        ConfigData data = new ConfigData(NOT_FOUND_FILE_NAME);

        // null
        try {
            data.setPassword(null);
        } catch(NullPointerException e) {
            // 成功
        } catch(Exception e) {
            Assert.fail("setPassword(null):違う例外発生");
        }
        
        // 成功例
        try {
            data.setPassword("12345");
            Assert.assertTrue("setPassword(\"12345\"):値が不一致", "12345".equals(data.getPassword()));
        } catch(Exception e) {
            Assert.fail("setPassword(\"12345\"):例外発生");
        }
    }

    /**
     * Test of setProxy method, of class ConfigData.
     */
    @Test
    public void testSetProxy() {
        System.out.println("setProxy");
        ConfigData data = new ConfigData(NOT_FOUND_FILE_NAME);
        
        // null
        try {
            data.setProxy(null);
        } catch(Exception e) {
            Assert.fail("setProxy(null):例外発生");
        }
        
        // Proxy("12345", 6789)
        try {
            data.setProxy(new Proxy("12345", 6789));
            Proxy proxy = data.getProxy();
            Assert.assertTrue("setProxy(new Proxy(\"12345\", 6789)):値が違う", "12345".equals(proxy.getHost()) && (6789 == proxy.getPort()));
        } catch(Exception e) {
            Assert.fail("setProxy(new Proxy(\"12345\", 6789)):例外発生");
        }
    }

    /**
     * Test of setReadTimeout method, of class ConfigData.
     */
    @Test
    public void testSetReadTimeout() {
        System.out.println("setReadTimeout");
        
        ConfigData data = new ConfigData(NOT_FOUND_FILE_NAME);
        
        // -1
        try {
            data.setReadTimeout(-1);
        } catch(IllegalArgumentException e) {
            // 成功
        } catch(Exception e) {
            Assert.fail("setReadTimeout(-1):違う例外発生");
        }
        
        // 0
        try {
            data.setReadTimeout(0);
            Assert.assertTrue("setReadTimeout(0):値が不一致", 0 == data.getReadTimeout());
        } catch(Exception e) {
            Assert.fail("setReadTimeout(0):例外発生");
        }
    }
}