/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author d
 */
public class ResultDataTest {

    public ResultDataTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testResultData() {
        SongId id = SongId.getInstance("1234-56");
        
        System.out.println("ResultDate2");
        {
            try {
                ResultData data = new ResultData(null, 50, 60, 70, 1, 0, 2, 10 );
                Assert.fail("nullチェックエラー");
            } catch(NullPointerException e) {
            } catch(Exception e) {
                Assert.fail("nullチェックエラー");
            }
        }
        
        System.out.println("ResultDate5");
        {
            try {
                ResultData data = new ResultData(id, -0.00001, 1, 300, 0, 60, 2, 10);
                Assert.fail("音程下限チェックエラー1");
            } catch(IllegalArgumentException e) {
                try {
                    ResultData data = new ResultData(id, 0, 1, 300, 0, 60, 2, 10);
                } catch(Exception e2) {
                    Assert.fail("音程下限チェックエラー2" + e2);
                }
            } catch(Exception e) {
                Assert.fail("音程下限チェックエラー3");
            }
            
            try {
                ResultData data = new ResultData(id, 100.0001, 1, 300, 0, 60, 2, 10);
                Assert.fail("音程上限チェックエラー1");
            } catch(IllegalArgumentException e) {
                try {
                    ResultData data = new ResultData(id, 100, 1, 300, 0, 60, 2, 10);
                } catch(Exception e2) {
                    Assert.fail("音程上限チェックエラー2");
                }
            } catch(Exception e) {
                Assert.fail("音程上限チェックエラー3");
            }
        }
        
        Assert.fail("TODO");
    }


    /**
     * Test of isValidScore method, of class ResultData.
     */
    @Test
    public void testIsValidScore() {
        System.out.println("isValidScore1");
        {
            boolean result1 = ResultData.isValidScore(-0.000000001);
            boolean result2 = ResultData.isValidScore(0);
            Assert.assertTrue("下限チェックエラー", !result1 && result2);
        }
        
        System.out.println("isValidScore2");
        {
            boolean result1 = ResultData.isValidScore(100.0);
            boolean result2 = ResultData.isValidScore(100.0000000001);
            Assert.assertTrue("上限チェックエラー", result1 && !result2);
        }
    }

    /**
     * Test of isValidInterval method, of class ResultData.
     */
    @Test
    public void testIsValidInterval() {
        System.out.println("isValidInterval1");
        {
            boolean result1 = ResultData.isValidInterval(-1);
            boolean result2 = ResultData.isValidInterval(0);
            Assert.assertTrue("下限チェックエラー", !result1 && result2);
        }
        
        System.out.println("isValidInterval2");
        {
            boolean result1 = ResultData.isValidInterval(100);
            boolean result2 = ResultData.isValidInterval(101);
            Assert.assertTrue("上限チェックエラー", result1 && !result2);
        }
    }

    /**
     * Test of isValidVibratoTime method, of class ResultData.
     */
    @Test
    public void testIsValidVibratoTime() {
        System.out.println("isValidVibratoTime1");
        {
            boolean result1 = ResultData.isValidVibratoTime(-0.000000001);
            boolean result2 = ResultData.isValidVibratoTime(0);
            Assert.assertTrue("下限チェックエラー", !result1 && result2);
        }
    }

    /**
     * Test of isValidVibratoType method, of class ResultData.
     */
    @Test
    public void testIsValidVibratoType() {
        System.out.println("isValidVibratoType1");
        {
            boolean result1 = ResultData.isValidVibratoType(-1);
            boolean result2 = ResultData.isValidVibratoType(0);
            Assert.assertTrue("下限チェックエラー", !result1 && result2);
        }
        
        System.out.println("isValidVibratoType2");
        {
            boolean result1 = ResultData.isValidVibratoType(9);
            boolean result2 = ResultData.isValidVibratoType(10);
            Assert.assertTrue("上限チェックエラー", result1 && !result2);
        }
    }

    /**
     * Test of isValidRhythm method, of class ResultData.
     */
    @Test
    public void testIsValidRhythm() {
        System.out.println("isValidRhythm1");
        {
            boolean result1 = ResultData.isValidRhythm(-4);
            boolean result2 = ResultData.isValidRhythm(-3);
            Assert.assertTrue("下限チェックエラー", !result1 && result2);
        }
        
        System.out.println("isValidRhythm2");
        {
            boolean result1 = ResultData.isValidRhythm(3);
            boolean result2 = ResultData.isValidRhythm(4);
            Assert.assertTrue("上限チェックエラー", result1 && !result2);
        }
    }

    /**
     * Test of isValidShakuri method, of class ResultData.
     */
    @Test
    public void testIsValidShakuri() {
        System.out.println("isValidShakuri1");
        {
            boolean result1 = ResultData.isValidShakuri(-1);
            boolean result2 = ResultData.isValidShakuri(0);
            Assert.assertTrue("下限チェックエラー", !result1 && result2);
        }
        
        System.out.println("isValidShakuri2");
        {
            boolean result1 = ResultData.isValidShakuri(Short.MAX_VALUE);
            boolean result2 = ResultData.isValidShakuri(Short.MAX_VALUE + 1);
            Assert.assertTrue("上限チェックエラー", result1 && !result2);
        }
    }

    /**
     * Test of isValidModulation method, of class ResultData.
     */
    @Test
    public void testIsValidModulation() {
        System.out.println("isValidModulation1");
        {
            boolean result1 = ResultData.isValidModulation(-1);
            boolean result2 = ResultData.isValidModulation(0);
            Assert.assertTrue("下限値チェック異常", !result1 && result2);
        }
        
        System.out.println("isValidModulation2");
        {
            boolean result1 = ResultData.isValidModulation(10);
            boolean result2 = ResultData.isValidModulation(11);
            Assert.assertTrue("上限値チェック異常", result1 && !result2);
        }
    }

}