/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author d
 */
public class SongIdTest {

    public SongIdTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of getInstance method, of class SongId.
     */
    @Test
    public void testGetInstance() {
        
        {
            System.out.println("getInstance1:nullチェック");
            try {
                SongId id = SongId.getInstance(null);
                Assert.fail("例外発生せず");
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("getInstance2:妥当でない文字列のときのチェック");
            try {
                SongId id = SongId.getInstance("");
                Assert.fail("例外発生せず");
            } catch(IllegalArgumentException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("getInstance3:同じIDのインスタンスの時のチェック");
            try {
                SongId id1 = SongId.getInstance("1234-15");
                SongId id2 = SongId.getInstance("1234-15");
                Assert.assertTrue("インスタンスが一致しない", id1 == id2);
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
    }

    /**
     * Test of isValid method, of class SongId.
     */
    @Test
    public void testIsValid() {
        {
            System.out.println("isValid1:nullチェック");
            try {
                boolean result = SongId.isValid(null);
                Assert.fail("例外発生せず");
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("isValid2:文字数チェック");
            try {
                boolean result1 = SongId.isValid("1234-6");
                boolean result2 = SongId.isValid("1234-56");
                boolean result3 = SongId.isValid("1234-567");
                Assert.assertTrue("6文字で成功した", !result1);
                Assert.assertTrue("8文字で成功した", !result3);
                Assert.assertTrue("7文字で失敗した", result2);
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("isValid3:ハイフン位置のチェック");
            try {
                boolean result1 = SongId.isValid("123-456");
                boolean result2 = SongId.isValid("1234-56");
                boolean result3 = SongId.isValid("12345-6");
                Assert.assertTrue("4番で成功した", !result1);
                Assert.assertTrue("6番で成功した", !result3);
                Assert.assertTrue("5番で失敗した", result2);
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("isValid4:5文字目のチェック");
            try {
                boolean result1 = SongId.isValid("1234~56");
                boolean result2 = SongId.isValid("1234-56");
                Assert.assertTrue("~で成功した", !result1);
                Assert.assertTrue("-で失敗した", result2);
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
    }

    /**
     * Test of getValue method, of class SongId.
     */
    @Test
    public void testGetValue() {
        System.out.println("getValue:取得した文字列のチェック");
        SongId id = SongId.getInstance("1234-56");
        boolean result = "1234-56".equals(id.getValue());
        Assert.assertTrue("一致せず\n\tid.getValue()=" + id.getValue(), result);
    }
}