/*!
* @file BaseStatusTable.cpp
* @brief b\̓e[u`
* @date 2013/12/10
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "BaseStatusTable.h"

namespace Deeangband
{

	BaseStatusTable::BaseStatusTable(BASE_STATUS status[CS_MAX])
	{
		this->Set(status);
	}

	BaseStatusTable::BaseStatusTable(BASE_STATUS bStr, BASE_STATUS bInt, BASE_STATUS bWis, BASE_STATUS bDex, BASE_STATUS bCon, BASE_STATUS bCha)
	{
		this->Set(bStr, bInt, bWis, bDex, bCon, bCha);
	}


	BaseStatusTable::BaseStatusTable(void)
	{
		int i;
		for(i = 0; i < CS_MAX; i++) this->status[i] = 0;
	}

	BaseStatusTable::~BaseStatusTable(void)
	{
	}

	const BASE_STATUS BaseStatusTable::Get(CREATURE_STATUS typ)
	{
		return this->status[typ];
	}


	void BaseStatusTable::Set(BASE_STATUS status[CS_MAX])
	{
		int i;
		for(i = 0; i < CS_MAX; i++) this->status[i] = status[i];
	}

	void BaseStatusTable::Set(BASE_STATUS bStr, BASE_STATUS bInt, BASE_STATUS bWis, BASE_STATUS bDex, BASE_STATUS bCon, BASE_STATUS bCha)
	{
		this->status[CS_STR] = bStr;
		this->status[CS_INT] = bInt;
		this->status[CS_WIS] = bWis;
		this->status[CS_DEX] = bDex;
		this->status[CS_CON] = bCon;
		this->status[CS_CHA] = bCha;
	}

	BaseStatusTable BaseStatusTable::operator+(const BaseStatusTable& plus)
	{
		int i;
		for(i = 0; i < CS_MAX; i++) this->status[i] = plus.status[i];
		return *this;
	}

	BaseStatusTable& BaseStatusTable::operator+=(const BaseStatusTable& plus)
	{
		int i;
		for(i = 0; i < CS_MAX; i++) this->status[i] = plus.status[i];
		return *this;
	}

}