/*!
* @file Dice.cpp
* @brief Q[̃_CX
* @date 2014/01/19
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Dice.h"

namespace Deeangband
{

	std::mt19937 Dice::mt;

	Dice::Dice(void)
	{
		this->Set(0, 0);
	}

	Dice::Dice(int num, int side)
	{
		this->Set(num, side);
	}

	Dice::~Dice(void)
	{
	}

	void Dice::Set(int num, int side)
	{
		this->num = num;
		this->side = side;
	}

	void Dice::Initialize(void)
	{
		std::random_device rd;
		std::array<unsigned, 100> seeds;
		for(auto & s : seeds) s = rd();
		std::seed_seq seq(seeds.begin(), seeds.end());
		mt.seed(seq);
	}

	int Dice::GetNum(void)
	{
		return this->num;
	}

	int Dice::GetSide(void)
	{
		return this->side;
	}

	int Dice::Cast(void)
	{
		int i, n = 0;
		for(i = 0; i < this->num; i++) n += Dice::Rand1(this->side);
		return n;
	}

	int Dice::Cast(int num, int side)
	{
		int i, n = 0;
		for(i = 0; i < num; i++) n += Dice::Rand1(side);
		return n;
	};

	int Dice::MaxCast(void)
	{
		return this->num * this->side;
	}

	int Dice::MaxCast(int num, int side)
	{
		return num * side;
	};

	int Dice::Rand0(int max)
	{
		std::uniform_int_distribution<int> dist(0, max-1);
		return dist(mt);
	}

	int Dice::Rand1(int max)
	{
		return Dice::Rand0(max) + 1;
	}

	bool Dice::Saving(int diff)
	{
		std::normal_distribution<int> dist(0, 20);
		return (diff >= dist(mt));
	}

}