/*!
* @file Field.cpp
* @brief Q[̃tA`
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Field.h"

namespace Deeangband
{

	Field::Field(std::map<TAG, boost::shared_ptr<Dungeon>>::iterator dungeonIt, DEPTH depth) : GameInstance()
	{
		Dungeon *dungeonPtr = &(*dungeonIt->second);
		int x, y;
		this->dungeonTag = dungeonIt->first;
		this->width = dungeonPtr->GetBaseSize().GetX();
		this->height = dungeonPtr->GetBaseSize().GetY();
		this->generated = false;

		if(depth > dungeonPtr->GetMaxDepth() || depth > dungeonPtr->GetMinDepth()) return;

		squares.resize(this->height);
		for(y = 0; y < height; y++)
		{
			for(x = 0; x < width; x++)
			{
				squares[y].push_back(boost::shared_ptr<Square>(new Square()));
				if(Dice::Cast(1, 2) == 2) squares[y][x]->SetFloorTag(dungeonPtr->GetInnerWallFloorTag());
				else squares[y][x]->SetFloorTag(dungeonPtr->GetFloorFloorTag());
			}
		}

		creatures.resize(0);
		doors.resize(0);
		traps.resize(0);
		items.resize(0);

		this->generated = true;
	}

	Field::Field()
	{
		WipeData();
	}

	Field::~Field()
	{
		WipeData();
	}

	void Field::WipeData(void)
	{
		this->width = 0;
		this->height = 0;
		this->dungeonTag = "";
		creatures.resize(0);
		doors.resize(0);
		traps.resize(0);
		items.resize(0);
	}

	MAP_LENGTH Field::GetWidth(void)
	{
		return width;
	}

	MAP_LENGTH Field::GetHeight(void)
	{
		return height;
	}

	bool Field::SetSize(MAP_LENGTH width, MAP_LENGTH height)
	{
		this->width = width;
		this->height = height;
		return true;
	}

	Square *Field::GetSquare(MAP_LENGTH x, MAP_LENGTH y)
	{
		return &(*(squares[x][y]));
	}

	bool Field::GenerateTrap(std::map<TAG, boost::shared_ptr<TrapBase>>::iterator trapBaseIt, Coordinates *position)
	{
		traps.emplace(traps.end(), boost::make_shared<Trap>(trapBaseIt, position));
		return true;
	}

}