/*!
* @file Species.cpp
* @brief Q[̃N[`[ʂ`
* @date 2014/02/01
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Species.h"

namespace Deeangband
{
	Species::Species(void) : GameElement(), HaveSymbol(), HaveSize()
	{
		this->WipeData();
	}

	Species::~Species(void)
	{
		this->WipeData();
	}

	void Species::WipeData(void)
	{
		GameElement::WipeData();

		this->baseSoul = 100;
		this->baseFeed = 20000;

		this->height = 160.0f;
		this->weight = 50.0f;
		this->divineLevel = -1;

		this->baseStatus.Set(8, 8, 8, 8, 8, 8);

		this->skillExpList.clear();
		this->baseCamp = TAG_VARIABLE;
		return;
	}

	SOUL Species::GetBaseSoul(void)
	{
		return this->baseSoul;
	}

	FEED Species::GetBaseFeed(void)
	{
		return this->baseFeed;
	}

	SKILL_EXP Species::GetSkillExp(TAG tag)
	{
		if(this->skillExpList.count(tag)) return this->skillExpList[tag];
		else return 0;
	}

	TAG Species::GetBaseCampTAG(void)
	{
		return this->baseCamp;
	}

	std::vector<TAG> Species::GetAuthorityTags(void)
	{
		return this->authorityTags;
	}

	TAG Species::GetFirstRaceTag(void)
	{
		return this->baseFirstRace;
	}

	TAG Species::GetSecondtRaceTag(void)
	{
		return this->baseSecondRace;
	}

}