/*!
 *  @file Air.h
 *  @brief Q[̋ԏ̃vg^Cv
 *  @date 2014/02/20
 *  @author Deskull
 *  2014 Sikabane Works.
 */

#pragma once

#include "stdafx.h"
#include "GameElement.h"
#include "HaveSymbol.h"
#include "HaveHp.h"
#include "Color.h"
#include "Dice.h"

namespace Deeangband
{
	class Color;

	/*!
	 * @class Air
	 * @brief ԏ̃NX
	 */
	class Air : public GameElement, public HaveSymbol, public HaveHp
	{
	private:

		friend class boost::serialization::access;
		Dice effectDice; //!< ԏݒ̃GtFNgl

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Name", name);
				archive & boost::serialization::make_nvp("TileID", tileID);
				archive & boost::serialization::make_nvp("Symbol", symbol);
				archive & boost::serialization::make_nvp("SymbolColor", symbolColor);
				archive & boost::serialization::make_nvp("BackColor", backColor);
				if(version >= 11) archive & boost::serialization::make_nvp("EffectDice", effectDice);
			}
		}

	public:

		/*! 
		 * @brief AirNXRXgN^
		 */
		Air::Air(void);

		/*! 
		 * @brief _~[f[^ɂ鏉
		 * @return Ȃ
		 */
		void Air::WipeData(void);

		/*! 
		 * @brief AirNXfXgN^
		 */
		Air::~Air(void);

	};

}

BOOST_CLASS_VERSION(Deeangband::Air, 11);
