/*!
* @file Coordinates.h
* @brief CoordinatesNXƂ̑tvf̒`
* @date 2014/01/26
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

namespace Deeangband
{
	typedef std::vector<Coordinates> RANGE_VECTOR;

	//#include "EngineTypedef.h"

	/*! 
	* @class Coordinates
	* @brief Q[W̃NX
	* @details
	* <H1>Tv</H1>
	* CoordinatesNXFieldɂ񎟌WɔzueIuWFNg̍W`B
	* <H2>Xe[^Xvf</H2>
	* Q[W͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>XW/FX</li>
	* <li>YW/FY</li>
	* </ul>
	*/
	class Coordinates
	{
	private:
		int fx; //!< XW
		int fy; //!< YW

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("X", fx);
				archive & boost::serialization::make_nvp("Y", fy);
			}
		}

	public:

		/*! 
		 * @brief CoordinatesNX̃RXgN^
		 * @param x XW
		 * @param y YW
		 */
		Coordinates::Coordinates(int x, int y);

		/*! 
		 * @brief CoordinatesNX̃RXgN^
		 */
		Coordinates::Coordinates(void);

		/*! 
		 * @brief CoordinatesNX̃fXgN^
		 */
		Coordinates::~Coordinates(void);

		/*
		 * @brief Wݒ肷
		 * @param x XW
		 * @param y YW
		 */
		void Coordinates::Set(int x, int y);

		/*
		 * @brief XW𓾂
		 * @return XW
		 */
		int Coordinates::GetX(void);

		/*
		 * @brief YW𓾂
		 * @return YW𓾂
		 */
		int Coordinates::GetY(void);

		/*!
		 * @brief +ZqɂW
		 * @param plus Z
		 */
		Coordinates Coordinates::operator=(const Coordinates& plus);  

		/*!
		 * @brief +ZqɂWZ
		 * @param plus Z
		 */
		Coordinates Coordinates::operator+(const Coordinates& plus);  

		/*!
		 * @brief +=ZqɂWZ
		 * @param plus Z
		 */
		Coordinates& Coordinates::operator+=(const Coordinates& plus);

		/*!
		 * @brief ==Zqɂ铙
		 * @param plus Z
		 */
		bool Coordinates::operator==(const Coordinates& plus);

		/*!
		 * @brief _̋vZ
		 * @param a [_1
		 * @param b [_2
		 * @return 
		 */
		static int Coordinates::Distance(Coordinates a, Coordinates b);

		/*!
		 * @brief _̋vZ
		 * @param x1 [_1XW
		 * @param y1 [_1YW
		 * @param x2 [_2XW
		 * @param y2 [_2YW
		 * @return 
		 */
		static int Coordinates::Distance(int x1, int y1, int x2, int y2);

		/*!
		 * @brief _̋vZ
		 * @param a ̒[_
		 * @return 
		 */
		int Coordinates::Distance(Coordinates a);

		/*!
		 * @brief `͈͎擾
		 * @param rangeVec ǉQƓn
		 * @param leftTop ͈͍
		 * @param rightBottom ͈͉E
		 * @return Ȃ
		 */
		void Coordinates::GetRectRange(std::vector<Coordinates> &rangeVec, Coordinates leftTop, Coordinates rightBottom);

		/*!
		 * @brief `͈͎擾
		 * @param rangeVec ǉQƓn
		 * @param left XW
		 * @param top YW
		 * @param right EXW
		 @ @param bottom YW
		 * @return Ȃ
		 */
		void Coordinates::GetRectRange(std::vector<Coordinates> &rangeVec, int left, int top, int right, int bottom);

		/*!
		 * @brief ~`͈͎擾
		 * @param rangeVec ǉQƓn
		 * @param point ͈͒S
		 * @param min Œ͈
		 * @param max ő͈
		 * @return Ȃ
		 */
		static void Coordinates::GetRoundRange(std::vector<Coordinates> &rangeVec, Coordinates point, int min, int max);

		/*!
		 * @brief ~`͈͎擾
		 * @param rangeVec ǉQƓn
		 * @param px ͈͒SXW
		 * @param py ͈͒SYW
		 * @param min Œ͈
		 * @param max ő͈
		 * @return Ȃ
		 */
		static void Coordinates::GetRoundRange(std::vector<Coordinates> &rangeVec, int px, int py, int min, int max);

		/*!
		 * @brief ~`͈͎擾
		 * @param rangeVec ǉQƓn
		 * @param min Œ͈
		 * @param max ő͈
		 * @return Ȃ
		 */
		void Coordinates::GetRoundRange(std::vector<Coordinates> &rangeVec, int min, int max);

		/*!
		 * @brief ːԂ(u[n@)
		 * @param rangeVec ǉQƓn
		 * @param ax [_1XW
		 * @param by [_1YW
		 * @param ax [_2XW
		 * @param by [_2YW
		 */
		static void Coordinates::LineOfSight(std::vector<Coordinates> &rangeVec, int x1, int y1, int x2, int y2);
	};

}

BOOST_CLASS_VERSION(Deeangband::Coordinates, 10);
