/*!
* @file Dungeon.cpp
* @brief Q[̃_W`
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Dungeon.h"

namespace Deeangband
{

	Dungeon::Dungeon(void) : GameElement()
	{
		WipeData();
		return;
	}

	Dungeon::~Dungeon(void)
	{
		WipeData();
		return;
	}

	void Dungeon::WipeData(void)
	{
		this->baseSize.Set(80, 80);
		this->name = "";
		this->minDepth = 1;
		this->maxDepth = 50;
		this->outerWallFloor = SPECIAL_TAG_UNKNOWN;
		this->innerWallFloor = SPECIAL_TAG_UNKNOWN;
		this->controlCamp = "";
		this->guardianSpecies = "";
		return;
	}

	TAG Dungeon::GetOuterWallFloorTag(void)
	{
		return this->innerWallFloor;
	}

	TAG Dungeon::GetInnerWallFloorTag(void)
	{
		return this->outerWallFloor;
	}

	TAG Dungeon::GetFloorFloorTag(void)
	{
		return this->floorFloor;
	}

	Coordinates Dungeon::GetBaseSize(void)
	{
		return this->baseSize;
	}

	DEPTH Dungeon::GetMinDepth(void)
	{
		return this->minDepth;
	}

	DEPTH Dungeon::GetMaxDepth(void)
	{
		return this->maxDepth;
	}

}