/*!
* @file HavePosition.h
* @brief V{ێۃNX̃vg^Cv錾
* @date 2014/06/11
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Coordinates.h"
#include "Deeangband.h"

namespace Deeangband
{

	class Field;

	/*! 
	 * @class HavePosition
	 * @brief V{ێۃNX
	 */
	class HavePosition
	{
	private:

		friend class boost::serialization::access;

		/*!
		 * @brief NX̃VACYݒ肷
		 * @param archive A[JCuNX̃AhX
		 * @param version t@Co[W
		 * @return XMLSerializeev[g
		 */
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Position", position);
				archive & boost::serialization::make_nvp("Field", field);
			}
		}

	protected:

		Coordinates position; //!< ݍW
		ID fieldID; //!< ݃tAID
		boost::shared_ptr<Field> fieldPtr; //!< ݃tAQƃ|C^

	public:

		/*! 
		 * @brief HavePositionNXRXgN^
		 */
		HavePosition::HavePosition(void);

		/*! 
		 * @brief HavePositionNXRXgN^
		 * @param x xW
		 * @param y yW
		 */
		HavePosition::HavePosition(MAP_LENGTH x, MAP_LENGTH y);

		/*! 
		 * @brief HavePositionNXRXgN^
		 * @param fieldIt tB[hCe[^Q
		 * @param x xW
		 * @param y yW
		 */
		HavePosition::HavePosition(std::map<ID, boost::shared_ptr<Field>>::iterator fieldIt, MAP_LENGTH x, MAP_LENGTH y);


		/*! 
		 * @brief HavePositionNXfXgN^
		 */
		HavePosition::~HavePosition(void);

		/*! 
		 * @brief HavePositionf[^
		 */
		void HavePosition::WipeData(void);

		/*!
		 * @brief ݍWԂ
		 * @return ݍW
		 */
		Coordinates HavePosition::GetPosition(void);

		/*!
		 * @brief ݂̃N[`[tB[hIDԂB
		 * @return ݂tB[hID
		 */
		ID HavePosition::GetFieldID(void);

		/*!
		 * @brief tȀWɈړ
		 * @param fieldID ړtAID
		 * @param x ړxW
		 * @param y ړyW
		 * @return ړłȂꍇ̃G[ID
		 */
		int HavePosition::Move(ID fieldID, int x, int y);

		/*!
		 * @brief tȀWɈړ
		 * @param fieldID ړtAID
		 * @param coord ړW
		 * @return ړłȂꍇ̃G[ID
		 */
		int HavePosition::Move(ID fieldID, Coordinates coord);
	};
}

BOOST_CLASS_VERSION(Deeangband::HavePosition, 10);
