/*!
* @file Item.h
* @brief Q[̃ACeƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "Dice.h"
#include "Effect.h"
#include "GameInstance.h"
#include "ItemBase.h"
#include "ItemTemplate.h"
#include "SavingTable.h"
#include "HaveGameTime.h"
#include "HaveSymbol.h"
#include "HavePosition.h"

BOOST_CLASS_VERSION(Item, 1);

namespace Deeangband
{

	/*!
	* @class Item
	* @brief ACẽNX
	*/
	class Item : public ItemTemplate, public GameInstance, public HaveGameTime, public HavePosition
	{
	private:

		Dice baseDamage; //!< x[X_[W̃_CX
		WEIGHT weight; //!< ACȅd
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("BaseDamage", baseDamage);
				archive & boost::serialization::make_nvp("Weight", weight);
				archive & boost::serialization::make_nvp("BaseSaving", baseSaving);
				archive & boost::serialization::make_nvp("PlusSaving", plusSaving);
			}
		}

	public:

		/*! 
		* @brief ItemNXRXgN^
		*/
		Item::Item(void);

		/*! 
		* @brief ItemNXRXgN^
		* @param itemBaseIt
		*/
		Item::Item(std::map<TAG, boost::shared_ptr<ItemBase>>::iterator itemBaseIt);

		/*! 
		* @brief ItemNXfXgN^
		*/
		Item::~Item(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Item::WipeData(void);

		/*! 󂯂ʂ */
		bool Item::TakeEffect(Effect *effectPtr, POWER amount);


		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void Item::XMLSave(std::string filename);

	};

}
