/*!
* @file Trap.h
* @brief Q[̃gbṽvg^Cv
* @date 2014/01/26
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Coordinates.h"
#include "GameInstance.h"
#include "TrapBase.h"

namespace Deeangband
{

	/*! 
	* @class Trap
	* @brief gbṽNX
	* @details
	* <H1>Tv</H1>
	* TrapNX́AtAɔzugbv̎̂`B
	* <H2>Xe[^Xvf</H2>
	* gbv͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>zutAID/FieldID</li>
	* <li>zuW/Position</li>
	* <li>ݑϋvx/CurrentHP</li>
	* <li>őϋvx/MaxHP</li>
	* <li>x/Difficulty</li>
	* </ul>
	*/
	class Trap : public GameInstance
	{
	private:

		TAG trapBaseTag; //!<gbvx[X^O
		Coordinates position; //!<ݍW
		HP curHP; //!<ݑϋvx
		HP maxHP; //!<őϋvx
		POWER difficulty; //!<x

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version > 0)
			{
				archive & boost::serialization::make_nvp("TrapBaseTag", trapBaseTag);
				archive & boost::serialization::make_nvp("Position", position);
				archive & boost::serialization::make_nvp("CurHP", curHP);
				archive & boost::serialization::make_nvp("MaxHP", maxHP);
				archive & boost::serialization::make_nvp("Difficulty", difficulty);
			}
		}

	public:

		/*! 
		* @brief TrapNXRXgN^
		*/
		Trap::Trap(void);

		/*! 
		* @brief TrapNXRXgN^
		*/
		Trap::Trap(std::map<TAG, boost::shared_ptr<TrapBase>>::iterator trapBaseIt, Coordinates *position);

		/*! 
		* @brief TrapNXfXgN^
		*/
		Trap::~Trap(void);

		/*! 
		* @brief _~[f[^̐ݒ
		* @return Ȃ
		*/
		void Trap::WipeData(void);

	};

}

BOOST_CLASS_VERSION(Deeangband::Trap, 10);
