/*!
* @file ItemTemplate.cpp
* @brief ACeev[g`
* @date 2014/04/04
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "ItemTemplate.h"

namespace Deeangband
{

	ItemTemplate::ItemTemplate(void) : HaveSymbol(), HaveSize()
	{
		this->WipeData();
	}

	ItemTemplate::~ItemTemplate(void)
	{
		this->WipeData();
	}

	void ItemTemplate::WipeData(void)
	{
		this->baseDamage.Set(1, 1);
		this->baseSaving.Set(0, 0, 0);
		this->plusSaving.Set(0, 0, 0);
	}

	Dice ItemTemplate::GetBaseDamage(void)
	{
		return this->baseDamage;
	}

	SavingTable ItemTemplate::GetBaseSaving(void)
	{
		return this->baseSaving;
	}

	SavingTable ItemTemplate::GetPlusSaving(void)
	{
		return this->plusSaving;
	}

	bool ItemTemplate::TakeEffect(Effect *effectPtr, POWER amount)
	{
		if(effectPtr)
		{
			amount = 0;
		}
		return true;
	}

	void ItemTemplate::XMLSave(std::string filename)
	{
		ItemTemplate ItemTemplate = *this;
		std::ofstream ofs(filename);
		assert(ofs);
		//boost::archive::xml_oarchive oa(ofs);
		//oa << BOOST_SERIALIZATION_NVP(ItemTemplate);
	}

}