/*!
* @file ItemTemplate.h
* @brief ACẽXe[^Xev[g
* @date 2014/04/04
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Color.h"
#include "Deeangband.h"

#include "Dice.h"
#include "Effect.h"
#include "GameElement.h"
#include "HaveSize.h"
#include "HaveSymbol.h"
#include "SavingTable.h"

namespace Deeangband
{

	/*!
	* @class ItemTemplate
	* @brief ACẽNX
	*/
	class ItemTemplate : public GameElement, public HaveSize, public HaveSymbol
	{
	protected:

		Dice baseDamage; //!< x[X_[W̃_CX
		SavingTable baseSaving; //!< {Z[rOC
		SavingTable plusSaving; //!< ǉZ[rOC


		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version f[^o[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & BOOST_SERIALIZATION_NVP(baseDamage);
				archive & BOOST_SERIALIZATION_NVP(weight);
				archive & BOOST_SERIALIZATION_NVP(baseSaving);
				archive & BOOST_SERIALIZATION_NVP(plusSaving);
			}
		}

	public:

		/*! 
		* @brief ItemTemplateNXRXgN^
		*/
		ItemTemplate::ItemTemplate(void);

		/*! 
		* @brief ItemTemplateNXfXgN^
		*/
		ItemTemplate::~ItemTemplate(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void ItemTemplate::WipeData(void);

		/*! 
		* @brief 󂯂ʂ
		* @return ۂɌʂꂽꍇTRUEԂB
		*/
		bool ItemTemplate::TakeEffect(Effect *effectPtr, POWER amount);

		/*! 
		 * @brief x[X_[W_CXԂ
		 * @return x[X_[W_CX
		 */
		Dice ItemTemplate::GetBaseDamage(void);

		/*! 
		 * @brief x[X_[W_CXԂ
		 * @return x[X_[W_CX
		 */
		SavingTable ItemTemplate::GetBaseSaving(void);

		/*! 
		 * @brief x[X_[W_CXԂ
		 * @return x[X_[W_CX
		 */
		SavingTable ItemTemplate::GetPlusSaving(void);

		/*! 
		 * @brief {bCԂ
		 * @return {bC
		 */
		AC ItemTemplate::GetBaseAC(void);

		/*! 
		 * @brief ǉbCԂ
		 * @return ǉbC
		 */
		AC ItemTemplate::GetPlusAC(void);

		/*! 
		 * @brief {CԂ
		 * @return {C
		 */
		EV ItemTemplate::GetBaseEV(void);

		/*! 
		 * @brief ǉCԂ
		 * @return ǉC
		 */
		EV ItemTemplate::GetPlusEV(void);

		/*! 
		 * @brief {ӎuCԂ
		 * @return {ӎuC
		 */
		VO ItemTemplate::GetBaseVO(void);

		/*! 
		 * @brief ǉӎuCԂ
		 * @return ǉӎuC
		 */
		VO ItemTemplate::GetPlusVO(void);

		/*! 
		 * @brief V{Ԃ
		 * @return V{
		 */
		SYMBOL ItemTemplate::GetSymbol(void);

		/*!
		* @brief XMLVACYɂQ[f[^ۑ
		* @return Ȃ
		*/
		void ItemTemplate::XMLSave(std::string filename);

	};

}

