/*!
* @file SavingTable.cpp
* @brief Z[rOe[u`
* @date 2014/03/06
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "SavingTable.h"

namespace Deeangband
{

	SavingTable::SavingTable(BASE_STATUS armor, BASE_STATUS evasion, BASE_STATUS volition)
	{
		Set(armor, evasion, volition);
		return;
	}

	SavingTable::SavingTable(void)
	{
		Set(0, 0, 0);
		return;
	}

	SavingTable::~SavingTable(void)
	{
	}

	void SavingTable::Set(BASE_STATUS armor, BASE_STATUS evasion, BASE_STATUS volition)
	{
		this->armor = armor;
		this->evasion = evasion;
		this->volition = volition;
	}

	const AC SavingTable::GetArmor(void)
	{
		return this->armor;
	}

	const EV SavingTable::GetEvasion(void)
	{
		return this->evasion;
	}

	const VO SavingTable::GetVolition(void)
	{
		return this->volition;
	}

	SavingTable& SavingTable::operator+=(const SavingTable& plus)
	{
		this->armor = plus.armor;
		this->evasion = plus.evasion;
		this->volition = plus.volition;
		return *this;
	}

}