/*!
* @file Dungeon.h
* @brief Q[̃_Wƕtvf̃vg^Cv
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"
#include "GameElement.h"

#include "Coordinates.h"
#include "Field.h"

#include "Camp.h"
#include "Species.h"
#include "Floor.h"

namespace Deeangband
{

	typedef struct FixedFieldTable FixedFieldTable;
	/*!
	* @brief ŒtAe[u
	*/
	struct FixedFieldTable
	{
		bool StaticFixed; //!<ÓIŒ
		ID FixedFieldID;  //!<ŒtAID
		DEPTH MinDepth;   //!<ŒKw
		DEPTH MaxDepth;   //!<őKw
		NUMBER MinNum;    //!<Œᐶ
		NUMBER MaxNum;    //!<ő吶
		PPM Probability;  //!<m
	};

	/*! 
	* @class Dungeon
	* @brief _W̃NX
	* @details
	* <H1>Tv</H1>
	* DungeonNX́AQ[ɑ݂_W̓`B
	* <H2>Xe[^Xvf</H2>
	* _W͈ȉ̃Xe[^XvfĂB
	* <ul>
	* <li>JnKw/MinDepth</li>
	* <li>Ő[Kw/MaxDepth</li>
	* <li>{Oǒn`^O/OuterWallFloor</li>
	* <li>{ǒn`^O/InnerWallFloor</li>
	* <li>Lwc^O/ControlCamp</li>
	* <li>_W̎҃^O/GuardianSpecies</li>
	* <li>_W̊{TCY/BaseSize</li>
	* </ul>
	*/
	class Dungeon : public GameElement
	{
	private:

		std::list<FixedFieldTable> fixFieldTableList; //!< ŒtÃXg
		DEPTH minDepth;       //!< JnKw
		DEPTH maxDepth;       //!< Ő[Kw
		TAG outerWallFloor; //!< {Oǒn`^O
		TAG innerWallFloor; //!< {ǒn`^O
		TAG floorFloor;     //!< {n`^O
		TAG controlCamp;      //!< Lwc^O
		TAG guardianSpecies;  //!< _W̎҃^O
		Coordinates baseSize; //!< _W̊{TCY


		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
			}
		}


	public:

		/*! 
		* @brief DungeonNXRXgN^
		*/
		Dungeon::Dungeon(void);

		/*! 
		* @brief DungeonNXfXgN^
		*/
		Dungeon::~Dungeon(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Dungeon::WipeData(void);

		/*!
		* @brief _W̍ŒKwԂ
		* @return _W̍ŒKw 
		*/
		DEPTH Dungeon::GetMinDepth(void);

		/*!
		* @brief _W̍ōKwԂ
		* @return _W̍ōKw 
		*/
		DEPTH Dungeon::GetMaxDepth(void);

		/*!
		* @brief _W̊{Oǒn`Ԃ
		* @return _W̊{Oǒn`^O
		*/
		TAG Dungeon::GetOuterWallFloorTag(void);

		/*!
		* @brief _W̊{Oǒn`Ԃ
		* @return _W̊{Oǒn`Qƃ|C^
		*/
		Floor *Dungeon::GetOuterWallFloorPtr(void);

		/*!
		* @brief _W̊{ǒn`Ԃ
		* @return _W̊{ǒn`Qƃ^O
		*/
		TAG Dungeon::GetInnerWallFloorTag(void);

		/*!
		* @brief _W̊{ǒn`Ԃ
		* @return _W̊{ǒn`Qƃ|C^
		*/
		Floor *Dungeon::GetInnerWallFloorPtr(void);

		/*!
		* @brief _W̊{n`Ԃ
		* @return _W̊{n`Qƃ^O
		*/
		TAG Dungeon::GetFloorFloorTag(void);

		/*!
		* @brief _WLwcԂ
		* @return _W̏LwcID
		*/
		ID GetControlCampID(void);

		/*!
		* @brief _WLwcԂ
		* @return _W̏LwcQƃ|C^
		*/
		Camp *GetControlCampPtr(void);

		/*!
		* @brief _W҃N[`[ʂԂ
		* @return _W̏LwcQID
		*/
		ID Dungeon::GetGurdianSpeciesID(void);

		/*!
		* @brief _W҃N[`[ʂԂ
		* @return _W̏LwcQƃ|C^
		*/
		Species *Dungeon::GetGurdianSpeciesPtr(void);

		/*!
		* @brief _W̊{TCYԂ
		* @return _W̊{TCY
		*/
		Coordinates Dungeon::GetBaseSize(void);

	};

}

