/*!
* @file GameWorld.h
* @brief Q[Ẽvg^Cv錾
* @date 2013/02/01
* @author Deskull
* 2013-2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"


namespace Deeangband
{

	class Air;
	class Ability;
	class Authority;
	class Building;
	class Camp;
	class CreatureTrait;

	class Creature;
	class Dungeon;
	class Effect;
	class Floor;

	class Field;
	class FixedArtifact;
	class GameMessage;
	class Item;
	class ItemBase;
	class ItemEgo;
	class ItemTrait;
	class Karma;
	class Lore;
	class Quest;
	class Race;
	class Space;
	class Skill;
	class Species;
	class StartingClass;
	class Trap;
	class TrapBase;

	class Coordinates;
	class HaveGameTime;

#include "EngineTypedef.h"

	/*!
	* @class GameWorld
	* @brief Q[ẼNX
	*/
	class GameWorld
	{
	private:

		//ÓIf[^Xg
		std::map<TAG, std::shared_ptr<Air>> airList;                      /*!<SCn`Xg*/
		std::map<TAG, std::shared_ptr<Ability>> abilityList;              /*!<SZ\Xg*/
		std::map<TAG, std::shared_ptr<Authority>> authorityList;          /*!<S\Xg*/
		std::map<TAG, std::shared_ptr<Building>> buildingList;            /*!<S{݃Xg*/
		std::map<TAG, std::shared_ptr<Camp>> campList;                    /*!<SwcXg*/
		std::map<TAG, std::shared_ptr<CreatureTrait>> creatureTraitList;  /*!<SN[`[Xg*/
		std::map<TAG, std::shared_ptr<Dungeon>> dungeonList;              /*!<S_WXg*/
		std::map<TAG, std::shared_ptr<Effect>> effectList;                /*!<SʑXg*/
		std::map<TAG, std::shared_ptr<Floor>> floorList;                  /*!<Sn`Xg*/
		std::map<TAG, std::shared_ptr<FixedArtifact>> fixedArtifactList;  /*!<SŒA[eBt@NgXg*/
		std::map<TAG, std::shared_ptr<ItemBase>> itemBaseList;            /*!<SACex[XXg*/
		std::map<TAG, std::shared_ptr<ItemEgo>> itemEgoList;              /*!<SACeGSXg*/
		std::map<TAG, std::shared_ptr<ItemTrait>> itemTraitList;          /*!<SACeXg*/
		std::map<TAG, std::shared_ptr<Karma>> karmaList;                  /*!<SJ}Xg*/
		std::map<TAG, std::shared_ptr<Quest>> questList;                  /*!<SNGXgXg*/
		std::map<TAG, std::shared_ptr<Space>> spaceList;                  /*!<SԒn`Xg*/
		std::map<TAG, std::shared_ptr<Skill>> skillList;                  /*!<SXLXg*/
		std::map<TAG, std::shared_ptr<Species>> speciesList;              /*!<SN[`[ʃXg*/
		std::map<TAG, std::shared_ptr<StartingClass>> startingClassList;  /*!<SoXg*/
		std::map<TAG, std::shared_ptr<Race>> raceList;                    /*!<S푰Xg*/
		std::map<TAG, std::shared_ptr<TrapBase>> trapBaseList;            /*!<Sgbvx[XʃXg*/

		//If[^Xg
		std::map<ID, std::shared_ptr<Item>> itemList;                    /*!<SACeXg*/
		CREATURE_LIST creatureList;	/*!<SN[`[Xg*/
		std::map<ID, std::shared_ptr<Field>> fieldList;                  /*!<StAXg*/
		std::map<ID, std::shared_ptr<Trap>> trapList;                    /*!<SgbvXg*/

		ID itemID;     //!<󂫃ACeID
		ID creatureID; //!<󂫃N[`[ID
		ID fieldID;    //!<󂫃tB[hID
		ID trapID;     //!<󂫃gbvID

		std::vector<std::shared_ptr<HaveGameTime>> actionList; /*!<sXg*/
		std::vector<Creature *> actionList2; /*!<sXg*/
		std::vector<HaveGameTime*> actionList3; /*!<sXg*/

		CREATURE_IT playerIt; //!< vC[N[`[Qƃ|C^
		GAME_TIME gameTime; //!<Q[


		/*!
		* @brief Cn`̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveAir(void);

		/*!
		* @brief Z\̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveAbility(void);

		/*!
		* @brief \̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveAuthority(void);

		/*!
		* @brief {ݏ̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveBuilding(void);

		/*!
		* @brief wc̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveCamp(void);

		/*!
		* @brief N[`[̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveCreatureTrait(void);

		/*!
		* @brief _W̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveDungeon(void);

		/*!
		* @brief ʑ̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveEffect(void);

		/*!
		* @brief n`̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveFloor(void);

		/*!
		* @brief ŒA[eBt@Ng̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveFixedArtifact(void);

		/*!
		* @brief x[XACẽZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveItemBase(void);

		/*!
		* @brief ACeGS̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveItemEgo(void);

		/*!
		* @brief ACẽZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveItemTrait(void);

		/*!
		* @brief J}̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveKarma(void);

		/*!
		* @brief NGXg̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveQuest(void);

		/*!
		* @brief NGXg̃Z[u
		* @return ݂ɐTRUEԂ
		* @todo ݏ̃G[
		*/
		bool GameWorld::xmlSaveRace(void);

		/*!
		* @brief XL̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveSkill(void);

		/*!
		* @brief Ԓn`̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveSpace(void);

		/*!
		* @brief N[`[ʏ̃Z[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveSpecie(void);

		/*!
		* @brief õZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveStartingClass(void);

		/*!
		* @brief x[XgbṽZ[u
		* @return ۑɐTRUEԂ
		* @todo ۑ̃G[
		*/
		bool GameWorld::xmlSaveTrapBase(void);

		bool GameWorld::xmlLoadAir(void);
		bool GameWorld::xmlLoadAbility(void);
		bool GameWorld::xmlLoadAuthority(void);
		bool GameWorld::xmlLoadBuilding(void);
		bool GameWorld::xmlLoadCamp(void);
		bool GameWorld::xmlLoadCreatureTrait(void);
		bool GameWorld::xmlLoadDungeon(void);
		bool GameWorld::xmlLoadEffect(void);
		bool GameWorld::xmlLoadFloor(void);
		bool GameWorld::xmlLoadFixedArtifact(void);
		bool GameWorld::xmlLoadItemBase(void);
		bool GameWorld::xmlLoadItemEgo(void);
		bool GameWorld::xmlLoadItemTrait(void);
		bool GameWorld::xmlLoadKarma(void);
		bool GameWorld::xmlLoadQuest(void);
		bool GameWorld::xmlLoadRace(void);
		bool GameWorld::xmlLoadSpace(void);
		bool GameWorld::xmlLoadSkill(void);
		bool GameWorld::xmlLoadSpecie(void);
		bool GameWorld::xmlLoadStartingClass(void);
		bool GameWorld::xmlLoadTrapBase(void);

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
		}

	public:

		/*!
		 * @brief GameWorldNX̃RXgN^
		 * @param gSurface Q[̃C^[tFCXƂȂ GameSurface Q
		 */
		GameWorld::GameWorld(void);

		/*!
		 * @brief GameWorldNX̃fXgN^
		 */
		GameWorld::~GameWorld(void);

		/*!
		 * @brief Q[Ȅs
		 */
		void GameWorld::Initialize(void);


		/*!
		* @brief N[`[𐶐GameWorld̏vfƘAg
		* @param creatureTag N[`[^O
		* @return ɐꍇtrueԂ
		*/
		bool GameWorld::GenerateCreature(std::map<TAG, std::shared_ptr<Species>>::iterator& speciesIt);

		/*!
		* @brief N[`[𐶐GameWorld̏vfƘAg
		* @param creatureTag N[`[^O
		* @param fieldID zutB[hID
		* @param x zuXW
		* @param y zuYW
		* @return ɐꍇtrueԂ
		*/
		bool GameWorld::GenerateCreature(std::map<TAG, std::shared_ptr<Species>>::iterator& speciesIt, std::map<ID, std::shared_ptr<Field>>::iterator& fieldIt, MAP_LENGTH x, MAP_LENGTH y);

		/*!
		* @brief GameWorldɑ݂錠\Ԃ
		* @param tag \̃^O
		* @return \̎Qƃ|C^A݂ȂNULLԂB
		*/
		Authority *GameWorld::GetAuthority(TAG tag);

		/*!
		* @brief GameWorldɑ݂N[`[Ԃ
		* @param tag N[`[̃^O
		* @return N[`[̎Qƃ|C^A݂ȂNULLԂB
		*/
		CreatureTrait *GameWorld::GetCreatureTrait(TAG tag);

		/*!
		* @brief GameWorldɑ݂ʑԂ
		* @param tag ʑ̃^O
		* @return ʑ̎Qƃ|C^A݂ȂNULLԂB
		*/
		Effect *GameWorld::GetEffect(TAG tag);

		/*!
		* @brief GameWorldɑ݂ŒA[eBt@NgԂ
		* @param tag ʑ̃^O
		* @return ŒA[eBt@Ng̎Qƃ|C^A݂ȂNULLԂB
		*/
		FixedArtifact *GameWorld::GetFixedArtifact(TAG tag);

		/*!
		* @brief GameWorldɑ݂n`Ԃ
		* @param tag n`̃^O
		* @return n`̎Qƃ|C^A݂ȂNULLԂB
		*/
		Floor *GameWorld::GetFloor(TAG tag);

		/*!
		* @brief GameWorldɑ݂x[XACeԂ
		* @param tag x[XACẽ^O
		* @return x[XACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemBase *GameWorld::GetItemBase(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeGSԂ
		* @param tag ACeGS̃^O
		* @return ACeGS̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemEgo *GameWorld::GetItemEgo(TAG tag);

		/*!
		* @brief GameWorldɑ݂ACeԂ
		* @param tag ACẽ^O
		* @return ACe̎Qƃ|C^A݂ȂNULLԂB
		*/
		ItemTrait *GameWorld::GetItemTrait(TAG tag);

		/*!
		 * @brief GameWorldɑ݂J}Ԃ
		 * @param tag J}̃^O
		 * @return J}̎Qƃ|C^A݂ȂNULLԂB
		 */
		Karma *GameWorld::GetKarma(TAG tag);

		/*!
		 * @brief GameWorldɑ݂XLԂ
		 * @param tag XL̃^O
		 * @return XL̎Qƃ|C^A݂ȂNULLԂB
		 */
		Skill *GameWorld::GetSkill(TAG tag);

		/*!
		 * @brief GameWorldɑ݂XLԂ
		 * @param tag XL̃^O
		 * @return XL̎Qƃ|C^A݂ȂNULLԂB
		 */
		Species *GameWorld::GetSpecies(TAG tag);

		/*!
		 * @brief GameWorldɑ݂gbvʂԂ
		 * @param tag gbvʂ̃^O
		 * @return gbvʂ̎Qƃ|C^A݂ȂNULLԂB
		 */
		TrapBase *GameWorld::GetTrapBase(TAG tag);

		/*!
		 * @brief GameWorldɑ݂{݂Ԃ
		 * @param tag {݂̃^O
		 * @return {݂̎Qƃ|C^A݂ȂNULLԂB
		 */
		Building *GameWorld::GetBuilding(TAG tag);

		/*!
		 * @brief GameWorldɑ݂wcԂ
		 * @param tag wc̃^O
		 * @return wc̎Qƃ|C^A݂ȂNULLԂB
		 */
		Camp *GameWorld::GetCamp(TAG tag);

		/*!
		 * @brief GameWorldɑ݂_WԂ
		 * @param tag _W̃^O
		 * @return _W̎Qƃ|C^A݂ȂNULLԂB
		 */
		Dungeon *GameWorld::GetDungeon(TAG tag);

		/*!
		 * @brief GameWorldɑ݂ACeԂ
		 * @param id ACeID
		 * @return ACe̎Qƃ|C^A݂ȂNULLԂB
		 */
		Item *GameWorld::GetItem(ID id);

		/*!
		 * @brief GameWorldɑ݂tAԂ
		 * @param id tAID
		 * @return tA̎Qƃ|C^A݂ȂNULLԂB
		 */
		Field *GameWorld::GetField(ID id);

		/*!
		 * @brief GameWorldɑ݂N[`[Ԃ
		 * @param id N[`[ID
		 * @return N[`[̎Qƃ|C^A݂ȂNULLԂB
		 */
		Creature *GameWorld::GetCreature(ID id);

		/*!
		 * @brief GameWorldɑ݂锭Z\Ԃ
		 * @return SZ\̃Xg
		 */
		std::map<TAG, std::shared_ptr<Ability>> *GameWorld::GetAbilityList(void);

		/*!
		 * @brief GameWorldɑ݂N[`[Ԃ
		 * @return SN[`[̃Xg
		 */
		CREATURE_LIST *GameWorld::GetCreatureList(void);

		/*!
		 * @brief GameWorldɑ݂NGXgԂ
		 * @param tag NGXg̃^O
		 * @return NGXg̎Qƃ|C^A݂ȂNULLԂB
		 */
		Quest *GameWorld::GetQuest(TAG tag);

		/*!
		 * @brief Q[ԂԂ
		 * @return Q[
		 */
		GAME_TIME GameWorld::GetGameTime(void);

		/*!
		 * @brief XMLVACYɂQ[f[^ۑ
		 * @return Ȃ
		 */
		bool GameWorld::XMLSave(void);

		/*!
		 * @brief XMLfVACYɂQ[f[^Ǎ
		 * @return Ȃ
		 */
		void GameWorld::XMLLoad(void);

		/*!
		 * @brief ΉID̃N[`[Xg珜O
		 * @return Ȃ
		 */
		void GameWorld::WipeCreature(ID id);

		/*!
		 * @brief vC[N[`[Ԃ
		 * @return vC[N[`[̎Qƃ|C^
		 */
		CREATURE_IT GameWorld::GetPlayerCreature(void);

		/*!
		 * @brief sXgԂ
		 * @return sXg
		 */
		ACTION_LIST *GameWorld::GetActionList(void);

		/*!
		 * @brief wtB[hyэWɑ݂N[`[邩𔻕ʂN[`[ԂB
		 * @param fieldID tB[hID
		 * @param positionPtr W|C^
		 * @param ݂N[`[̃|C^A݂ȂꍇNULLB
		 */
		Creature *GameWorld::GetCreatureFromPosition(ID fieldID, Coordinates *positionPtr);

		/*!
		 * @brief wtB[hyэWɑ݂n`ԂB
		 * @param fieldID tB[hID
		 * @param positionPtr W|C^
		 * @param ݂N[`[̃|C^A݂ȂꍇNULLB
		 */
		Floor *GameWorld::GetFloorFromPosition(ID fieldID, Coordinates *positionPtr);

		std::map<TAG, std::shared_ptr<Floor>> *GameWorld::GetFloorList(void);

		std::map<TAG, std::shared_ptr<Species>> *GameWorld::GetSpeciesList(void);

		/*!
		 * @brief ԌoߏsÃANVIuWFNgԂB
		 * @return sXg
		 */
		HaveGameTime *GameWorld::GetNextActionObject(void);


	};

}