/*!
* @file Coordinates.cpp
* @brief CoordinatesNX̒`
* @date 2013/12/19
* @author Deskull
* 2014 Sikabane Works.
*/

#include "stdafx.h"
#include "Coordinates.h"

namespace Deeangband
{

	Coordinates::Coordinates(int x, int y)
	{
		this->fx = x;
		this->fy = y;
	}

	Coordinates::Coordinates(void)
	{
		this->fx = 0;
		this->fy = 0;
	}

	Coordinates::~Coordinates(void)
	{
	}

	int Coordinates::GetX(void)
	{
		return this->fx;
	}

	int Coordinates::GetY(void)
	{
		return this->fy;
	}

	void Coordinates::Set(MAP_POSITION x, MAP_POSITION y)
	{
		this->fx = x;
		this->fy = y;
	}

	Coordinates Coordinates::operator=(const Coordinates& plus)
	{
		this->fx = plus.fx;
		this->fy = plus.fy;
		return *this;
	}

	Coordinates Coordinates::operator+(const Coordinates& plus)
	{
		Coordinates coord;
		coord.fx = this->fx + plus.fx;
		coord.fy = this->fy + plus.fy;
		return coord;
	}

	Coordinates& Coordinates::operator+=(const Coordinates& plus)
	{
		this->fx += plus.fx;
		this->fy += plus.fy;
		return *this;
	}

	bool Coordinates::operator==(const Coordinates& plus)
	{
		return (this->fx == plus.fx && this->fy == plus.fy);
	}

	static int mysqrt(int n)
	{
		int tmp = n >> 1;
		int plus = 10;
		int solve = 1;

		if(n < 1) return 0;
		if(n < 4) return 1;

		while(tmp)
		{
			if ((n / tmp) < tmp)
			{
				tmp >>= 1;
			}
			else break;
		}

		solve = tmp;

		while(plus)
		{
			if ((n / tmp) < tmp)
			{
				plus--;
				tmp = solve;
			}
			else
			{
				solve = tmp;
				tmp += plus;
			}
		}
		return solve;
	}

	int Coordinates::Distance(Coordinates a, Coordinates b)
	{
		return mysqrt((a.GetX() - b.GetX()) * (a.GetX() - b.GetX()) + (a.GetY() - b.GetY()) * (a.GetY() - b.GetY()));
	}

	int Coordinates::Distance(int x1, int y1, int x2, int y2)
	{
		return mysqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
	}

	int Coordinates::Distance(Coordinates a)
	{
		return Coordinates::Distance(*this, a);
	}

	void Coordinates::GetRectRange(std::vector<Coordinates> &rangeVec, Coordinates leftTop, Coordinates rightBottom)
	{
		GetRectRange(rangeVec, leftTop.GetX(), leftTop.GetY(), rightBottom.GetX(), rightBottom.GetY());
		return;
	}

	void Coordinates::GetRectRange(std::vector<Coordinates> &rangeVec, int left, int top, int right, int bottom)
	{
		int x, y;
		for(y = top; y <= bottom; y++)
		{
			for(x = left; x <= right; x++)
			{
				rangeVec.push_back(Coordinates(x, y));
			}
		}
		return;
	}

	void Coordinates::GetRoundRange(std::vector<Coordinates> &rangeVec, Coordinates point, int min, int max)
	{
		GetRoundRange(rangeVec, point.GetX(), point.GetY(), min, max);
		return;
	}

	void Coordinates::GetRoundRange(std::vector<Coordinates> &rangeVec, int px, int py, int min, int max)
	{
		int x, y;
		for(y = py - max; y <= py + max; y++)
		{
			for(x = px - max; x <= px + max; x++)
			{
				if(Coordinates::Distance(px, py, x, y) >= min && Coordinates::Distance(px, py, x, y) <= max)
				{
					rangeVec.push_back(Coordinates(x, y));
				}
			}
		}
		return;
	}

	void Coordinates::GetRoundRange(std::vector<Coordinates> &rangeVec, int min, int max)
	{
		GetRoundRange(rangeVec, this->GetX(), this->GetY(), min, max);
		return;
	}

	void Coordinates::LineOfSight(std::vector<Coordinates> &rangeVec, int x1, int y1, int x2, int y2)
	{
		int dx, dy, e, x, y, ystep = 0;
		bool steep = std::abs(y2 - y1) > std::abs(x2 - x1);

		if(steep)
		{
			std::swap(x1, y1);
			std::swap(x2, y2);
		};

		if (x1 > x2)
		{
	        std::swap(x1, x2);
	        std::swap(y1, y2);
		}

		dx = x2 - x1;
		dy = std::abs(y2 - y1);
		e = dx / 2;

		y = y1;

		if(y1 < y2) ystep = 1;
		else ystep = -1;

		for(x = x1; x <= x2; x++)
		{
			if(steep) rangeVec.push_back(Coordinates(y, x));
			else rangeVec.push_back(Coordinates(x, y));
			e -= dy;
			if(e < 0)
			{
				y = y + ystep;
				e += dx;
			}
		}

	}

}