/*!
* @file GameElement.h
* @brief GameElementNXƕtvf̃vg^Cv
* @date 2014/02/01
* @author Deskull
* 2013-2014 Sikabane Works.
*/

#pragma once

#include "Deeangband.h"

namespace Deeangband
{
	class GameWorld;
	class GameSurface;
	class GameLogger;

	/*! 
	 * @class GameElement
	 * @brief Q[̏vf̊ǗsX[p[NX
	 */
	class GameElement
	{
	private:

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Name", name);
				archive & boost::serialization::make_nvp("Description", description);
				archive & boost::serialization::make_nvp("ValidGenerated", validGenerated);
			}
		}


	protected:

		NAME name; //!< O
		DESCRIPTION description; //!< 
		bool validGenerated; //!< ꂽ̔tO

	public:

		static GameWorld *GameWorldPtr;
		static GameSurface *GameSurfacePtr;
		static GameLogger *GameLoggerPtr;

		/*! 
		* @brief PʂstringɕϊB
		*/
		static std::string GameElement::HeightFormat(HEIGHT height);

		/*! 
		* @brief dʂPʂstringɕϊB
		*/
		static std::string GameElement::WeightFormat(WEIGHT weight); 

		/*! 
		* @brief GameElementNXRXgN^
		*/
		GameElement::GameElement(void); 

		/*! 
		* @brief GameElementNXfXgN^
		*/
		virtual GameElement::~GameElement(void); 

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void GameElement::WipeData(void);

		/*!
		* @brief O擾
		* @return O
		*/
		NAME GameElement::GetName(void);

		/*!
		* @brief 擾
		* @return 
		*/
		DESCRIPTION GameElement::GetDescription(void);

		/*!
		* @brief GameWorldCX^XԂ
		* @return GameWorldCX^X̎Qƃ|C^
		*/
		GameWorld *GameElement::GetGameWorld(void);

		/*!
		* @brief GameWorldCX^XԂ
		* @return GameWorldCX^X̎Qƃ|C^
		*/
		bool GameElement::IsValidGenerated(void);

	};

}

BOOST_CLASS_VERSION(Deeangband::GameElement, 10);
