/*!
* @file GameSurface.h
* @brief GameSurfaceNXƂ̑tvf̃vg^Cv
* @date 2013/12/17
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"

#include "GameWorld.h"
#include "Coordinates.h"

namespace Deeangband
{
#include "EngineTypedef.h"

	/*! 
	* @class GameSurface
	* @brief Q[̃CC^[tFCXNX
	*/
	class GameSurface
	{
	protected:
		GameWorld *gameWorld; //!< ΉGameWorld

	public:
		GameSurface::GameSurface(void);
		GameSurface::GameSurface(GameWorld *gameWorld);
		virtual GameSurface::~GameSurface(void);

		/*!
		 * @brief Q[R}h󂯎
		 * @return GAME_COMMAND Œ`ꂽR}he
		 */
		virtual GAME_COMMAND GetCommand(const CREATURE_IT& subjectCreatureIt)
		{
			subjectCreatureIt;
			return GAME_COMMAND_STAY;
		}

		/*!
		 * @brief TChXe[^X\XV
		 * @param creaturePtr XVN[`[Qƃ|C^
		 * @return Ȃ
		 */
		virtual void GameSurface::UpdateSideCreatureStatus(Creature *creaturePtr) { creaturePtr; }

		/*!
		* @brief Q[ʕ\XVB
		* @return Ȃ
		*/
		virtual void GameSurface::Draw(const CREATURE_IT& subjectCreatureIt) { subjectCreatureIt; }

		/*!
		* @brief Q[ʂɃN[`[\B
		* @param creaturePtr \N[`[̃CX^XQƃ|C^BNULLȂΔ\B
		* @return Ȃ
		*/
		virtual void GameSurface::ViewCreatureStatus(Creature *creaturePtr) { creaturePtr; }

		/*!
		 * @brief Q[ԕ\XV
		 * @param currentTime ݎ
		 * @return Ȃ
		 */
		virtual void GameSurface::UpdateTimeStatus(GAME_TIME currentTime) { currentTime; }

		/*!
		* @brief Q[ʍɃvC[ȗ\B
		* @param creaturePtr \N[`[̃CX^XQƃ|C^BNULLȂΔ\B
		* @return Ȃ
		*/
		virtual void GameSurface::SetSideStatusCreature(Creature *creaturePtr) { creaturePtr; }

		/*!
		* @brief Q[ʕ\tA؂ւB
		* @param fieldPtr \tÃCX^XQƃ|C^BNULLȂΔ\B
		* @return Ȃ
		*/
		virtual void GameSurface::SetField(Field *fieldPtr) { fieldPtr; }

		/*!
		* @brief tA\̃tH[JXύX
		* @param x XW
		* @param y YW
		* @return Ȃ
		*/
		virtual void GameSurface::FocusField(MAP_LENGTH x, MAP_LENGTH y) { x; y; }

		/*!
		 * @brief tA\̃tH[JXύX
		 * @param coord W
		 * @return Ȃ
		 */
		virtual void GameSurface::FocusField(Coordinates coord) { coord; }

		/*!
		 * @brief VXebZ[W\
		 * @param message bZ[W
		 * @return Ȃ
		 */
		virtual void GameSurface::SystemMessage(std::string message) { message; }

		/*!
		 * @brief Q[bZ[Wǉ
		 * @param message bZ[W
		 * @return Ȃ
		 */
		virtual void GameSurface::GameMessage(std::string message) { message; }

	};

}