/*!
* @file Skill.h
* @brief Q[̃XL̃vg^Cv
* @date 2013/12/17
* @author Deskull
* 2013 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Deeangband.h"
#include "GameElement.h"
#include "Creature.h"

class GameWorld;

namespace Deeangband
{

	/*!
	* @class Skill
	* @brief XL̃NX
	*/
	class Skill : public GameElement
	{
	private:
		std::string name;
		std::string details;

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("name", name);
				archive & boost::serialization::make_nvp("details", details);
			}
		}

	public:

		/*! 
		* @brief SkillNXRXgN^
		*/
		Skill::Skill(void);

		/*! 
		* @brief SkillNXfXgN^
		*/
		Skill::~Skill(void);

		/*! 
		* @brief _~[f[^ɂ鏉
		* @return Ȃ
		*/
		void Skill::WipeData(void);

		/*! 
		* @brief XL̖̂Ԃ
		* @return XL
		*/
		std::string Skill::GetName(void);

		/*! 
		* @brief XL̏ڍׂԂ
		* @return XLڍ
		*/
		std::string Skill::GetDetails(void);

		/*! 
		* @brief XLNZo
		* @param creaturePtr ZoN[`[̃CX^XQƃ|C^
		* @param tag ZoXL̃^O
		* @return XLN
		*/
		static SKILL_RANK Skill::CalcSkillRank(Creature *creaturePtr, TAG tag);

	};

}

BOOST_CLASS_VERSION(Skill, 1);
