/*!
* @file Square.cpp
* @brief Q[̃}X`
* @date 2013/12/11
* @author Deskull
* 2013 Sikabane Works.
*/

#include "stdafx.h"
#include "Square.h"
#include "GameWorld.h"
#include "Floor.h"

namespace Deeangband
{

	Square::Square(void) : GameElement(), HaveInventory(), HaveHp()
	{
		WipeData();
	}

	Square::Square(std::map<TAG, boost::shared_ptr<Floor>>::iterator& floorIt) : GameElement(), HaveInventory(), HaveHp()
	{
		WipeData();
		this->floorPtr = floorIt->second.get();
		this->floorTag = floorIt->first;
	}

	void Square::WipeData()
	{
		this->floorTag = SPECIAL_TAG_UNKNOWN;
		this->spaceTag = SPECIAL_TAG_UNKNOWN;
		this->airTag = SPECIAL_TAG_UNKNOWN;
	}

	Square::~Square()
	{
	}

	TAG Square::GetFloorTag(void)
	{
		return this->floorTag;
	}

	TAG Square::GetAirTag(void)
	{
		return this->airTag;
	}

	TAG Square::GetSpaceTag(void)
	{
		return this->spaceTag;
	}

	bool Square::SetFloor(TAG tag)
	{
		this->floorTag = tag;
		this->floorPtr = GameElement::GameWorldPtr->GetFloorList()->operator[](tag).get();
		return true;
	}

	Floor* Square::GetFloorPtr(void)
	{
		return this->floorPtr;
	}

	bool Square::IsWall(void)
	{
		// TODO
		return this->floorTag == "VANILLA_PERMANENT_WALL";
	}

	bool Square::IsTeleportableTarget(void)
	{
		// TODO
		return this->floorTag != "VANILLA_PERMANENT_WALL";
	}
}

