/*!
* @file HaveSymbol.h
* @brief V{ێۃNX̃vg^Cv錾
* @date 2014/06/11
* @author Deskull
* 2014 Sikabane Works.
*/

#pragma once

#include "stdafx.h"
#include "Color.h"
#include "Deeangband.h"

namespace Deeangband
{

	/*! 
	* @class HaveSymbol
	* @brief V{ێۃNX
	*/
	class HaveSymbol
	{
	private:

		friend class boost::serialization::access;

		/*!
		* @brief NX̃VACYݒ肷
		* @param archive A[JCuNX̃AhX
		* @param version t@Co[W
		* @return XMLSerializeev[g
		*/
		template<class Archive> void serialize(Archive &archive, const unsigned int version) 
		{
			if(version >= 0)
			{
				archive & boost::serialization::make_nvp("Symbol", symbol);
				archive & boost::serialization::make_nvp("FColor", symbolColor);
				archive & boost::serialization::make_nvp("BColor", backColor);
				archive & boost::serialization::make_nvp("Tile", tileID);
			}
		}

	protected:

		SYMBOL symbol;     //!< V{L
		Color symbolColor; //!< V{J[
		Color backColor;   //!< wiJ[
		ID tileID;         //!< ^CID

	public:

		/*! 
		 * @brief HaveSymbolNXRXgN^
		 */
		HaveSymbol::HaveSymbol(void);

		/*! 
		 * @brief HaveSymbolNXfXgN^
		 */
		HaveSymbol::~HaveSymbol(void);

		/*! 
		 * @brief HaveSymbolf[^
		 */
		void HaveSymbol::WipeData(void);

		/*!
		 * @brief V{Ԃ
		 * @return V{
		 */
		SYMBOL HaveSymbol::GetSymbol(void);

		/*!
		 * @brief V{J[Ԃ
		 * @return V{J[
		 */
		Color HaveSymbol::GetSymbolColor(void);

		/*!
		 * @brief wiJ[Ԃ
		 * @return wiJ[
		 */
		Color HaveSymbol::GetBackColor(void);

		/*!
		 * @brief wiJ[Ԃ
		 * @return wiJ[
		 */
		ID HaveSymbol::GetTileID(void);
	};
}

BOOST_CLASS_VERSION(Deeangband::HaveSymbol, 10);
