// File: defines.h

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

/* Purpose: global constants and macro definitions */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * For example, there are MANY things that depend on the screen being
 * 80x24, with the top line used for messages, the bottom line being
 * used for status, and exactly 22 lines used to show the dungeon.
 * Just because your screen can hold 46 lines does not mean that the
 * game will work if you try to use 44 lines to show the dungeon.
 *
 * You have been warned.
 */

// 2012 Deskull modified.
// Recent environments haven't been depend on constant screen.
// So we reset size parameter at will.


// Name of the version/variant
#define VERSION_NAME "D\'angband"

#define VERSION   0
#define VER_MAJOR 0
#define VER_MINOR 3
#define VER_PATCH 72

#define VER_EXTRA 0

// Back Ground Color (Windows)
#define WINDOWS_BK_COLOR_R  0
#define WINDOWS_BK_COLOR_G  0
#define WINDOWS_BK_COLOR_B  0

#define QUEST_INFO_FILE	"q_info.txt"
#define WORLD_INFO_FILE	"w_info.txt"
#define TOWN_INFO_FILE	"t_info.txt"

/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11

/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	33

// Number of grids used to display the dungeon (vertically and horizontally).
#define SCREEN_HGT	20
#define SCREEN_WID	20

// Number of min and max screen.
#define MIN_SCREEN_WID 2
#define MIN_SCREEN_HGT 2
#define MAX_SCREEN_WID 12
#define MAX_SCREEN_HGT 12

// Maximum dungeon height in grids, must be a multiple of SCREEN_HGT and SCREEN_WID,
#define MAX_HGT (SCREEN_HGT * MAX_SCREEN_HGT)
#define MAX_WID (SCREEN_WID * MAX_SCREEN_WID)

// Starting points
#define STARTING_MAX	15

#define MAGIC_EATER_SKILL_MAX 72

// Quest constants
#define MIN_RANDOM_QUEST    40
#define MAX_RANDOM_QUEST    49

// Check is the quest index is "fixed"
#define is_fixed_quest_idx(Q_IDX) (((Q_IDX) < MIN_RANDOM_QUEST) || ((Q_IDX) > MAX_RANDOM_QUEST))
#define QUEST_SERPENT        9
#define QUEST_AOY           18

// Arena constants
#define MAX_ARENA_MONS		39

// Total number of stores (see "store.c", etc)
#define MAX_STORES      10

// Number of buildings
#define MAX_BLDG		32

#define ST1_YOUR_HOME			0x00000001
#define ST1_MUSEUM				0x00000002
#define ST1_BLACK_MARKET		0x00000004
#define ST1_GENERAL				0x00000008
#define ST1_SCULPTURE			0x00000010
#define ST1_PAINT				0x00000020
#define ST1_ARMOURY				0x00000040
#define ST1_WEAPON				0x00000080

#define ST1_ALCHEMY				0x00000100
#define ST1_MAGIC_ITEM			0x00000200
#define ST1_ORIENTAL_WEAPON		0x00000400
#define ST1_BOOK				0x00000800
#define ST1_TEMPLE				0x00001000

#define ST1_OTAKU				0x10000000
#define ST1_MORGUE              0x20000000

#define HISTORY_ROW 16
#define HISTORY_COL 75

#define BUILDING_NON_MEMBER 0
#define BUILDING_MEMBER     1
#define BUILDING_OWNER      2

// Maximum number of creature melee definition

#define MAX_WEAPONS            8
#define MAX_SPECIAL_BLOWS      4
#define MAX_APPENDAGE          7

#define MELLE_WEAPON_INDEX     0
#define MELLE_SP_BLOW_INDEX    (MAX_WEAPONS)
#define MELLE_APPENDAGE_INDEX  (MAX_WEAPONS + MAX_SPECIAL_BLOWS)
#define MAX_MELEE_TYPE         (MAX_WEAPONS + MAX_SPECIAL_BLOWS + MAX_APPENDAGE)



// Number of entries in the sanity-blast descriptions
#define MAX_SAN_HORROR   20
#define MAX_SAN_DELIGHT  20
#define MAX_SAN_FUNNY    22
#define MAX_SAN_COMMENT  5

/* TRAITS */

// TRAIT TYPES
#define TRAITTYPE_MUTATION            0
#define TRAITTYPE_UNDEAD              10
#define TRAITTYPE_ELDAR_LINGAGE       20
#define TRAITTYPE_DRAGONBONE_LINGAGE  21
#define TRAITTYPE_GREAT_ANCESTOR      22

#define STAT_TABLE_SIZE 58
#define DR_TABLE_SIZE 31

// Monk martial arts...
#define MAX_MA 17
#define MA_KNEE 1
#define MA_SLOW 2

// Mindcraft
#define MAX_MIND_POWERS  21

// Hallucination stuff
#ifdef JP
#define MAX_SILLY_ATTACK 43
#else
#define MAX_SILLY_ATTACK 29
#endif

#define MIND_MINDCRAFTER    0
#define MIND_KI             1
#define MIND_BERSERKER      2
#define MIND_MIRROR_MASTER  3
#define MIND_NINJUTSU       4


/*
 * Size of memory reserved for initialization of some arrays
 */
#define FAKE_NAME_SIZE        80 * 1024L
#define FAKE_TEXT_SIZE       500 * 1024L
#define FAKE_TAG_SIZE         50 * 1024L
#define FAKE_TMP_BUFFER_SIZE 300 * 1024L

// Maximum number of high scores in the high score file
#define MAX_HISCORES    999

// Maximum dungeon level.  The player can never reach this level
// in the dungeon, and this value is used for various calculations
// involving object and creature creation.  It must be at least 100.
// Setting it below 128 may prevent the creation of some objects.
#define MAX_DEPTH       128

// Maximum number of saved floors.
#define MAX_FLOORS       20

/*
 * Maximum size of the "lite" array (see "cave.c")
 * Note that the "lite radius" will NEVER exceed 14, and we would
 * never require more than 581 entries in the array for circular "lite".
 */
#define LITE_MAX 600

/*
 * Maximum size of the "creature_lite" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, creature illumination
 * flags are dependent on CAVE_VIEW, and even if the "view" was octagonal,
 * we would never require more than 1520 entries in the array.
 */
#define SPECIES_LITE_MAX 1536

/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * We must be as large as "VIEW_MAX" and "LITE_MAX" for proper functioning
 * of "update_view()" and "update_lite()".  We must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate creature flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 5000

/*
 * Maximum size of the "redraw" array (see "cave.c")
 * We must be large for proper functioning of delayed redrawing.
 * We must also be as large as two times of the largest view area.
 * Note that maximum view grids are 1149 entries.
 */
#define REDRAW_MAX 5000


/*
 * Number of keymap modes
 */
#define KEYMAP_MODES	2

/*
 * Mode for original keyset commands
 */
#define KEYMAP_MODE_ORIG	0

/*
 * Mode for roguelike keyset commands
 */
#define KEYMAP_MODE_ROGUE	1


/*
 * OPTION: Maximum number of macros (see "io.c")
 * Default: assume at most 256 macros are used
 */
#define MACRO_MAX       256

/*
 * OPTION: Maximum number of "quarks" (see "io.c")
 * Default: assume at most 512 different inscriptions are used
 */
#define QUARK_MAX       768
/* Was 512... 256 quarks added for random artifacts */

/*
 * OPTION: Maximum number of messages to remember (see "io.c")
 * Default: assume maximal memorization of 2048 total messages
 */
#define MESSAGE_MAX     2048

/*
 * OPTION: Maximum space for the message text buffer (see "io.c")
 * Default: assume that each of the 2048 messages is repeated an
 * average of three times, and has an average length of 48
 */
#define MESSAGE_BUF     32768



#define MAX_UCHAR       255   // Maximum value storable in a "byte" (hard-coded)
#define MAX_SHORT       32767 // Maximum value storable in a "s16b" (hard-coded)

#define MAX_NLEN        160   // Maximum length of object's name

// Special internal key
#define SPECIAL_KEY_QUEST    255
#define SPECIAL_KEY_BUILDING 254
#define SPECIAL_KEY_STORE    253
#define SPECIAL_KEY_QUIT     252

// Store constants
#define STORE_INVEN_MAX 24              /* Max number of discrete objs in inven */
#define STORE_CHOICES   48              /* Number of items to choose stock from */
#define STORE_TURNOVER  9               /* Normal shop turnover, per day */
#define STORE_MIN_KEEP_PERCENT  40      /* Min slots to "always" keep full */
#define STORE_MAX_KEEP_PERCENT  75      /* Max slots to "always" keep full */
#define STORE_TICKS     1000            /* Number of ticks between turnovers */

// Creature Status limitation
#define ENERGY_NEED() (randnor(100, 25))
#define SPEED_TO_ENERGY(SPEED) (((SPEED) > 199) ? 199 : extract_energy[(SPEED + 100)])

// on creature generating
#define EXP_STAND_RATE 1500


/*** Pet constants ***/

/*
 * Commands
 */
#define PET_DISMISS				1
#define PET_TARGET				2
#define PET_STAY_CLOSE			3
#define PET_FOLLOW_ME			4
#define PET_SEEK_AND_DESTROY	5
#define PET_ALLOW_SPACE			6
#define PET_STAY_AWAY			7
#define PET_OPEN_DOORS          8
#define PET_TAKE_ITEMS			9
#define PET_TELEPORT			10
#define PET_ATTACK_SPELL		11
#define PET_SUMMON_SPELL		12
#define PET_BALL_SPELL			13
#define PET_RIDING				14
#define PET_NAME				15
#define PET_RYOUTE				16

/*
 * Follow distances
 */
#define PET_CLOSE_DIST				1
#define PET_FOLLOW_DIST				6
#define PET_SEEK_DIST				10
#define PET_DESTROY_DIST			255
#define PET_SPACE_DIST				(-10)
#define PET_AWAY_DIST				(-25)

#define PF_OPEN_DOORS   0x0001
#define PF_PICKUP_ITEMS 0x0002
#define PF_TELEPORT     0x0004
#define PF_ATTACK_SPELL 0x0008
#define PF_SUMMON_SPELL 0x0010
#define PF_BALL_SPELL   0x0020
#define PF_RYOUTE       0x0040


#define CAN_TWO_HANDS_WIELDING(WHO) (!(WHO)->riding || ((WHO)->pet_extra_flags & PF_RYOUTE))




/*
 * Refueling constants
 */
#define FUEL_TORCH      5000    /* Maximum amount of fuel in a torch */
#define FUEL_LAMP       15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT       20      /* Maximum view distance */
#define MAX_RANGE       (floor_ptr->gamble_arena_mode ? 36 : 18) /* Maximum range (spells, etc) */
#define AAF_LIMIT       100     /* Limit of sensing radius */

#define MAX_DUNEGON_FORTLESS 30
#define MAX_VOID_PORTAL 10



/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD          60


/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN          90


/*
 * Possible realms that can be chosen;
 * currently used only by birth.c and tables.c
 */
#define CH_NONE         0x00
#define CH_LIFE         0x01
#define CH_SORCERY      0x02
#define CH_NATURE       0x04
#define CH_CHAOS        0x08
#define CH_DEATH        0x10
#define CH_TRUMP        0x20
#define CH_ARCANE       0x40
#define CH_ENCHANT      0x80
#define CH_DAEMON       0x100
#define CH_CRUSADE      0x200

#define CH_MUSIC        0x08000	/* This is 16th bit */
#define CH_HISSATSU     0x10000
#define CH_HEX          0x20000

/*
 * Magic realms
 */
#define REALM_NONE         0
#define REALM_LIFE         1
#define REALM_SORCERY      2
#define REALM_NATURE       3
#define REALM_CHAOS        4
#define REALM_DEATH        5
#define REALM_TRUMP        6
#define REALM_ARCANE       7
#define REALM_CRAFT        8
#define REALM_DAEMON       9
#define REALM_CRUSADE      10
#define MAX_MAGIC          10

#define MIN_TECHNIC        16
#define REALM_MUSIC        16
#define REALM_HISSATSU     17
#define REALM_HEX          18
#define MAX_REALM          19

#define VALID_REALM        (MAX_REALM + MAX_MAGIC - MIN_TECHNIC + 1)
#define NUM_TECHNIC        (MAX_REALM - MIN_TECHNIC + 1)

#define is_magic(A) ((((A) > REALM_NONE) && ((A) < MAX_MAGIC + 1)) ? TRUE : FALSE)
#define tval2realm(A) ((A) - TV_LIFE_BOOK + 1)
#define technic2magic(A)      (is_magic(A) ? (A) : (A) - MIN_TECHNIC + 1 + MAX_MAGIC)
#define is_good_realm(REALM)   ((REALM) == REALM_LIFE || (REALM) == REALM_CRUSADE)

/*
 * Magic-books for the realms
 */
#define REALM1_BOOK(WHO)     ((WHO)->realm1 + TV_LIFE_BOOK - 1)
#define REALM2_BOOK(WHO)     ((WHO)->realm2 + TV_LIFE_BOOK - 1)

// Mode constant for do_spell()
#define SPELL_NAME   0
#define SPELL_DESC   1
#define SPELL_INFO   2
#define SPELL_CAST   3
#define SPELL_FAIL   4
#define SPELL_STOP   5
#define SPELL_CONT   6



/*
 * Fake inventory slot for selecting force (hard-coded).
 */
#define INVEN_FORCE     1111
#define INVEN_NULL      2000


// VARIABLE index for race, class, character and so on.
#define INDEX_NONE      30000
#define INDEX_VARIABLE  30001


// Indexes of the various "stats" (hard-coded by savefiles, etc).
#define STAT_STR   0
#define STAT_INT   1
#define STAT_WIS   2
#define STAT_DEX   3
#define STAT_CON   4
#define STAT_CHA   5
#define STAT_MAX   6
#define STAT_FRACTION 10

/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_NONE                0x00
#define SEX_FEMALE              0x01
#define SEX_MALE                0x02
#define SEX_INTERSEX            0x03 // (SEX_MALE || SEX_FEMALE)
#define MAX_SEXES	4

#define IS_NOSEX(PTR)          ((PTR)->sex == SEX_NONE)
#define IS_MALE(PTR)           ((PTR)->sex & SEX_MALE)
#define IS_FEMALE(PTR)         ((PTR)->sex & SEX_FEMALE)
#define IS_INTERSEX(PTR)       ((PTR)->sex & SEX_INTERSEX)


/*
 * Race FLAGS
 */
#define RACE_BIRTH_SELECTABLE    0x01
#define RACE_UNDEAD_FORM         0x02
#define RACE_BEAST_FROM          0x04
#define RACE_MECHANIZARION       0x08

/*
 * Race crossing flags.
 */
#define RC_MAKABLE_HALF   0x01
#define RC_ANCESTER       0x02

/*
 * Class rarerity.
 */
#define CLASS_RARELITY_COMMON       0
#define CLASS_RARELITY_UNCOMMON     1
#define CLASS_RARELITY_RARE         2
#define CLASS_RARELITY_LEGENDARY    3
#define CLASS_RARELITY_UNSELECTED   4


#define RATE_OF_HALF_RACE       80

// Maximum number of creature setting type
#define MAX_HALF_RACE_DESCRIPTION 15


/*** Screen Locations ***/

/*
 * Some screen locations for various display routines
 * Currently, row 8 and 15 are the only "blank" rows.
 * That leaves a "border" around the "stat" values.
 */

#define ROW_DAY                 21
#define COL_DAY                 0       /* day */

#define ROW_DUNGEON             22
#define COL_DUNGEON             0       /* dungeon */

#define ROW_LEVEL               1
#define COL_LEVEL               0       /* "LV xx/xx" */

#define ROW_EXP                 1
#define COL_EXP                 9       /* "EXP xxxxxxxx" */

#define ROW_GOLD                3
#define COL_GOLD                0       /* "AU xxxxxxxxx" */

#define ROW_STAT                6
#define COL_STAT                0       /* "xxx   xxxxxx" */

#define ROW_AC                  12
#define COL_AC                  0       /* "Cur AC xxxxx" */

#define ROW_HPMP                13
#define COL_HPMP                0

#define ROW_CURHP               13
#define COL_CURHP               0       /* "Cur HP xxxxx" */

#define ROW_CURSP               14
#define COL_CURSP               0       /* "Cur SP xxxxx" */

#define ROW_RIDING_INFO         15
#define COL_RIDING_INFO         0       /* "xxxxxxxxxxxx" */

#define ROW_INFO                16
#define COL_INFO                0       /* "xxxxxxxxxxxx" */

#define ROW_MAP                 0
#define COL_MAP                 20

#define ROW_CUT                 18
#define COL_CUT                 0       /* <cut> */

#define ROW_STUN                19
#define COL_STUN                0       /* <stun> */

#define ROW_HUNGRY              20
#define COL_HUNGRY              0       /* "Weak" / "Hungry" / "Full" / "Gorged" */

#define ROW_STATE               20
#define COL_STATE                7      /* <state> */

#define ROW_SPEED               (-1)
#define COL_SPEED               (-24)      /* "Slow (-NN)" or "Fast (+NN)" */

#define ROW_STUDY               (-1)
#define COL_STUDY               (-13)      /* "Study" */

#define ROW_DEPTH               (-1)
#define COL_DEPTH               (-8)      /* "Lev NNN" / "NNNN ft" */

#define ROW_STATBAR             (-1)
#define COL_STATBAR              0
#define MAX_COL_STATBAR         (-26)



// Number of feats we change to (Excluding default). Used in feature_info.txt.
#define MAX_FEAT_STATES	 8


/*
 * Feature flags - should be used instead of feature indexes unless generating.
 * Originally from UnAngband, and modified into TR-like style in Hengband
 */

#define FF_FLAG_SIZE     (1 + ((FF_FLAG_MAX - 1) / 32))


/* Which features are dynamic */
#define have_dynamic_flags(ARRAY) \
	(!!((ARRAY)[(FF_INSTANT / 32)] & \
	    ((1UL << (FF_INSTANT % 32)) | \
	     (1UL << (FF_EXPLODE % 32)) | \
	     (1UL << (FF_TIMED % 32)) | \
	     (1UL << (FF_ERUPT % 32)) | \
	     (1UL << (FF_STRIKE % 32)) | \
	     (1UL << (FF_SPREAD % 32)))))


/*
 * Feature action flags
 */
#define FAF_DESTROY     0x01
#define FAF_NO_DROP     0x02
#define FAF_CRASH_GLASS 0x04


/*
 * Bit flags for teleportation
 */
#define TELEPORT_NONMAGICAL 0x00000001
#define TELEPORT_PASSIVE    0x00000002
#define TELEPORT_DEC_VALOUR 0x00000004


/* Types of doors */
#define DOOR_DEFAULT    -1
#define DOOR_DOOR        0
#define DOOR_GLASS_DOOR  1
#define DOOR_CURTAIN     2

#define MAX_DOOR_TYPES   3

#define feat_locked_door_random(DOOR_TYPE) \
	(feat_door[(DOOR_TYPE)].num_locked ? \
	 feat_door[(DOOR_TYPE)].locked[randint0(feat_door[(DOOR_TYPE)].num_locked)] : feat_none)

#define feat_jammed_door_random(DOOR_TYPE) \
	(feat_door[(DOOR_TYPE)].num_jammed ? \
	 feat_door[(DOOR_TYPE)].jammed[randint0(feat_door[(DOOR_TYPE)].num_jammed)] : feat_none)


/* Types of normal traps */
#define NOT_TRAP        -1
#define TRAP_TRAPDOOR    0
#define TRAP_PIT         1
#define TRAP_SPIKED_PIT  2
#define TRAP_POISON_PIT  3
#define TRAP_TY_CURSE    4
#define TRAP_TELEPORT    5
#define TRAP_FIRE        6
#define TRAP_ACID        7
#define TRAP_SLOW        8
#define TRAP_LOSE_STR    9
#define TRAP_LOSE_DEX   10
#define TRAP_LOSE_CON   11
#define TRAP_BLIND      12
#define TRAP_CONFUSE    13
#define TRAP_POISON     14
#define TRAP_SLEEP      15
#define TRAP_TRAPS      16
#define TRAP_ALARM      17

/* Types of special traps */
#define TRAP_OPEN       18
#define TRAP_ARMAGEDDON 19
#define TRAP_PIRANHA    20
#define TRAP_ACID_FLOW   21
#define TRAP_POISON_FLOW 22


/* Maximum locked/jammed doors */
#define MAX_LJ_DOORS 8


/* Types of pattern tiles */
#define NOT_PATTERN_TILE      -1
#define PATTERN_TILE_START    0
#define PATTERN_TILE_1        1
#define PATTERN_TILE_2        2
#define PATTERN_TILE_3        3
#define PATTERN_TILE_4        4
#define PATTERN_TILE_END      5
#define PATTERN_TILE_OLD      6
#define PATTERN_TILE_TELEPORT 7
#define PATTERN_TILE_WRECKED  8


/* Types of conversions */
#define CONVERT_TYPE_FLOOR   0
#define CONVERT_TYPE_WALL    1
#define CONVERT_TYPE_INNER   2
#define CONVERT_TYPE_OUTER   3
#define CONVERT_TYPE_SOLID   4
#define CONVERT_TYPE_STREAM1 5
#define CONVERT_TYPE_STREAM2 6


/*
 * Bit flags for the *_can_enter() and species_can_cross_terrain()
 */
#define CEM_RIDING              0x0001
#define CEM_P_CAN_ENTER_PATTERN 0x0002


/* Lighting levels of features' attr and char */

#define F_LIT_STANDARD 0 /* Standard */
#define F_LIT_LITE     1 /* Brightly lit */
#define F_LIT_DARK     2 /* Darkened */

#define F_LIT_NS_BEGIN 1 /* Nonstandard */
#define F_LIT_MAX      3


/*** Artifact indexes (see "lib/edit/artifact_info.txt") ***/

// Lites
#define ART_GALADRIEL            1
#define ART_ELENDIL              2
#define ART_JUDGE                3
#define ART_EDISON               7
#define ART_PALANTIR             15
#define ART_STONE_LORE           17
#define ART_FLY_STONE            147

// Amulets
#define ART_CARLAMMAS            4
#define ART_INGWE                5
#define ART_DWARVES              6
#define ART_FARAMIR              18
#define ART_BOROMIR              143
#define ART_MAGATAMA             149
#define ART_INROU                166
#define ART_NIGHT                215
#define ART_SACRED_KNIGHTS       217
#define ART_HELL                 218
#define ART_CHARMED              219
#define ART_GOGO                 220

/* Rings */
#define ART_FRAKIR               8
#define ART_TULKAS               9
#define ART_NARYA               10
#define ART_NENYA               11
#define ART_VILYA               12
#define ART_POWER               13
#define ART_AHO                 14

/* Dragon Scale */
#define ART_RAZORBACK           129
#define ART_BLADETURNER         130
#define ART_SEIRYU              201

/* Hard Armour */
#define ART_SOULKEEPER          19
#define ART_ISILDUR             20
#define ART_ROHIRRIM            21
#define ART_LOHENGRIN           22
#define ART_JULIAN              23
#define ART_ARVEDUI             24
#define ART_CASPANION           25
#define ART_GILES               168
#define ART_MORLOK              203
#define ART_VETERAN             206

/* Soft Armour */
#define ART_SHIVA_JACKET        26
#define ART_HITHLOMIR           27
#define ART_THALKETTOTH         28
#define ART_HIMRING             127
#define ART_ICANUS              131
#define ART_NAMAKE_ARMOR        183
#define ART_GHB                 192
#define ART_DASAI               200
#define ART_KESHO               204

/* Shields */
#define ART_THORIN              30
#define ART_CELEGORM            31
#define ART_ANARION             32
#define ART_GIL_GALAD           138
#define ART_YENDOR              141
#define ART_YATA                151
#define ART_EARENDIL            186
#define ART_PERSEUS             197

/* Helms and Crowns */
#define ART_INDRA               33
#define ART_CHAOS               34
#define ART_BERUTHIEL           35
#define ART_THRANDUIL           36
#define ART_THENGEL             37
#define ART_HAMMERHAND          38
#define ART_DOR                 39
#define ART_HOLHENNETH          40
#define ART_TERROR              41
#define ART_AMBER               42
#define ART_NUMENOR             132
#define ART_STONEMASK           146

/* Cloaks */
#define ART_JACK                43
#define ART_COLLUIN             44
#define ART_HOLCOLLETH          45
#define ART_THINGOL             46
#define ART_THORONGIL           47
#define ART_COLANNON            48
#define ART_LUTHIEN             49
#define ART_TUOR                50
#define ART_MOOK                205
#define ART_HEAVENLY_MAIDEN     233

/* Gloves */
#define ART_CAMBELEG            52
#define ART_CAMMITHRIM          53
#define ART_PAURHACH            54
#define ART_CORWIN              55
#define ART_PAURAEGEN           56
#define ART_PAURNEN             57
#define ART_THANOS              58
#define ART_FINGOLFIN           59
#define ART_PAURNIMMEN          185

/* Boots */
#define ART_FEANOR              60
#define ART_FLORA               61
#define ART_THROR               62
#define ART_SHIVA_BOOTS         63
#define ART_GLASS               165
#define ART_GETA                210

/* Digging */
#define ART_NAIN                211

/* Swords */
#define ART_MAEDHROS            64
#define ART_CAINE               65
#define ART_NARTHANC            66
#define ART_NIMTHANC            67
#define ART_DETHANC             68
#define ART_RILIA               69
#define ART_FIONA               70
#define ART_CALRIS              71
#define ART_GRAYSWANDIR         72
#define ART_GLAMDRING           73
#define ART_NOTHUNG             74
#define ART_ORCRIST             75
#define ART_GURTHANG            76
#define ART_ZARCUTHRA           77
#define ART_TWILIGHT            78
#define ART_GONDRICAM           79
#define ART_CRISDURIAN          80
#define ART_AGLARANG            81
#define ART_RINGIL              82
#define ART_ANDURIL             83
#define ART_WEREWINDLE          84
#define ART_CHAINSWORD          85
#define ART_FORASGIL            86
#define ART_CARETH              87
#define ART_STING               88
#define ART_SOULSWORD           89
#define ART_MERLIN              90
#define ART_DOOMCALLER          91
#define ART_VORPAL_BLADE        92
#define ART_SLAYER              123
#define ART_KUSANAGI            128
#define ART_HURIN               133
#define ART_AZAGHAL             135
#define ART_NOVA                137
#define ART_CHARIOT             140
#define ART_WORPAL_BLADE        142
//#define ART_ZANTETSU            150
#define ART_SOULCRUSH           154
#define ART_FALIS               155
#define ART_HRUNTING            156
#define ART_ANUBIS              158
#define ART_GURENKI             160
#define ART_TAILBITER           167
#define ART_MUSASI_KATANA       171
#define ART_MUSASI_WAKIZASI     172
#define ART_QUICKTHORN          174
#define ART_TINYTHORN           175
#define ART_EXCALIBUR           176
#define ART_EXCALIPUR           177
#define ART_EXCALIBUR_J         179
#define ART_ARUNRUTH            184
#define ART_HAKABUSA            189
#define ART_STORMBRINGER        190
#define ART_NARSIL              191
#define ART_KANNU               193
#define ART_GRIMTOOTH           196
#define ART_KAMUI               198
#define ART_GOURYU              207
#define ART_EOWYN               216

/* Polearms */
#define ART_THEODEN             93
#define ART_PAIN                94
#define ART_OSONDIR             95
#define ART_TIL                 96
#define ART_RUNESPEAR           97
#define ART_DESTINY             98
#define ART_HAGEN               99
#define ART_EORLINGAS           100
#define ART_DURIN               101
#define ART_EONWE               102
#define ART_BALLI               103
#define ART_LOTHARANG           104
#define ART_DWARVES_AXE         105
#define ART_BARUKKHELED         106
#define ART_WRATH               107
#define ART_ULMO                108
#define ART_AVAVIR              109
#define ART_BENKEI              152
#define ART_TAIKOBO             159
#define ART_TONBO               161
#define ART_GAEBOLG             163
#define ART_ARRYU               164
#define ART_AEGLOS              187
#define ART_BLOOD               199
#define ART_NUMAHOKO            202

/* The sword of the Dawn */
#define ART_DAWN                110

/* Hafted */
#define ART_GROND               111
#define ART_TOTILA              112
#define ART_THUNDERFIST         113
#define ART_BLOODSPIKE          114
#define ART_FIRESTAR            115
#define ART_TARATOL             116
#define ART_AULE                117
#define ART_NAR                 118
#define ART_ERIRIL              119
#define ART_GANDALF             120
#define ART_DEATHWREAKER        121
#define ART_TURMIL              122
#define ART_MJOLLNIR            136
#define ART_WINBLOWS            139
#define ART_XIAOLONG            145
#define ART_NYOIBOU             157
#define ART_JONES               162
#define ART_HYOUSIGI            169
#define ART_MATOI               170
#define ART_IRON_BALL           173
#define ART_SAMSON              178
#define ART_NAMAKE_HAMMER       181
#define ART_BOLISHOI            188
#define ART_SHUTEN_DOJI         194
#define ART_G_HAMMER            195
#define ART_AEGISFANG           208
#define ART_HERMIT              209
#define ART_GOTHMOG             212
#define ART_JIZO                213
#define ART_FUNDIN              214
#define ART_AESCULAPIUS         225

/* Bows */
#define ART_BELTHRONDING        124
#define ART_BARD                125
#define ART_BRAND               126
#define ART_CRIMSON             16
#define ART_BUCKLAND            134
#define ART_YOICHI              148
#define ART_HARAD               180
#define ART_NAMAKE_BOW          182
#define ART_ROBIN_HOOD          221
#define ART_HELLFIRE            222

/* Arrows */
#define ART_BARD_ARROW          153

/*** Ego-Item indexes (see "lib/edit/e_info.txt") ***/


/* Nothing */
/* xxx */
/* xxx */
/* xxx */

#define EGO_000
#define EGO_001
#define EGO_002
#define EGO_003
#define EGO_RESIST_ACID         4
#define EGO_RESIST_ELEC         5
#define EGO_RESIST_FIRE         6
#define EGO_RESIST_COLD         7
#define EGO_RESISTANCE          8
#define EGO_ELVENKIND           9
#define EGO_DWARVEN             10
#define EGO_PERMANENCE          11
#define EGO_YOIYAMI             12
#define EGO_013
#define EGO_014
#define EGO_015

/* Shields */
#define EGO_ENDURE_ACID         16
#define EGO_ENDURE_ELEC         17
#define EGO_ENDURE_FIRE         18
#define EGO_ENDURE_COLD         19
#define EGO_ENDURANCE           20
#define EGO_REFLECTION          21
#define EGO_NIGHT_DAY           22

/* Crowns and Helms */
#define EGO_DARK                23
#define EGO_INTELLIGENCE        24
#define EGO_WISDOM              25
#define EGO_BEAUTY              26
#define EGO_MAGI                27
#define EGO_MIGHT               28
#define EGO_LORDLINESS          29
#define EGO_SEEING              30
#define EGO_INFRAVISION         31
#define EGO_LITE                32
#define EGO_TELEPATHY           33
#define EGO_REGENERATION        34
#define EGO_TELEPORTATION       35
#define EGO_STUPIDITY           36
#define EGO_NAIVETY             37
#define EGO_UGLINESS            38
#define EGO_SICKLINESS          39

/* Cloaks */
#define EGO_PROTECTION          40
#define EGO_STEALTH             41
#define EGO_AMAN                42
#define EGO_AURA_FIRE           43
#define EGO_ENVELOPING          44
#define EGO_VULNERABILITY       45
#define EGO_IRRITATION          46
#define EGO_AURA_ELEC           47

/* Gloves */
#define EGO_FREE_ACTION         48
#define EGO_SLAYING             49
#define EGO_AGILITY             50
#define EGO_POWER               51
#define EGO_TWO_WEAPON             52
#define EGO_MAGIC_MASTERY       53
#define EGO_WEAKNESS            54
#define EGO_CLUMSINESS          55

/* Boots */
#define EGO_SLOW_DESCENT        56
#define EGO_QUIET               57
#define EGO_MOTION              58
#define EGO_SPEED               59
#define EGO_JUMP                60
#define EGO_NOISE               61
#define EGO_SLOWNESS            62
#define EGO_ANNOYANCE           63

/* Weapons */
#define EGO_HA                  64
#define EGO_DF                  65
#define EGO_BLESS_BLADE         66
#define EGO         67

/* xxx */
#define EGO_WEST                68
#define EGO_ATTACKS             69
#define EGO_SLAYING_WEAPON      70
#define EGO_FORCE_WEAPON        71
#define EGO_BRAND_ACID          72
#define EGO_BRAND_ELEC          73
#define EGO_BRAND_FIRE          74
#define EGO_BRAND_COLD          75
#define EGO_BRAND_POIS          76
#define EGO_CHAOTIC             77
#define EGO_SHARPNESS           78
#define EGO_EARTHQUAKES         79
#define EGO_SLAY_ANIMAL         80
#define EGO_SLAY_EVIL           81
#define EGO_SLAY_UNDEAD         82
#define EGO_SLAY_DEMON          83
#define EGO_SLAY_ORC            84
#define EGO_SLAY_TROLL          85
#define EGO_SLAY_GIANT          86
#define EGO_SLAY_DRAGON         87
#define EGO_KILL_ANIMAL         88
#define EGO_KILL_EVIL           89
#define EGO_KILL_UNDEAD         90
#define EGO_KILL_DEMON          91
#define EGO_KILL_ORC            92
#define EGO_KILL_TROLL          93
#define EGO_KILL_GIANT          94
#define EGO_KILL_DRAGON         95
#define EGO_VAMPIRIC            96
#define EGO_PRISM               97
#define EGO_TRUMP               98
#define EGO_PATTERN             99
#define EGO_DIGGING             100
#define EGO_SLAY_HUMAN          101
#define EGO_MORGUL              102
#define EGO_KILL_HUMAN          103

/* Bows */
#define EGO_ACCURACY            104
#define EGO_VELOCITY            105
/* xxx */
/* xxx */
#define EGO_EXTRA_MIGHT         108
#define EGO_EXTRA_SHOTS         109
/* xxx */
/* xxx */

/* Ammo */
#define EGO_HURT_ANIMAL         112
#define EGO_HURT_EVIL           113
/* xxx */
/* xxx */
/* xxx */
/* xxx */
/* xxx */
#define EGO_HURT_DRAGON         119
#define EGO_SLAYING_BOLT        120
#define EGO_LIGHTNING_BOLT      121
#define EGO_FLAME               122
#define EGO_FROST               123
#define EGO_WOUNDING            124
#define EGO_BACKBITING          125
#define EGO_SHATTERED           126
#define EGO_BLASTED             127
#define EGO_AURA_COLD          128
#define EGO_BAT                129

#define EGO_LITE_SHINE          140
#define EGO_LITE_ILLUMINATION   141
#define EGO_LITE_AURA_FIRE      142
#define EGO_LITE_INFRA          143
#define EGO_LITE_LONG           144
#define EGO_LITE_DARKNESS       145
#define EGO_LITE_EYE            146

#define EGO_RING_HERO           150
#define EGO_RING_SLAY           151
#define EGO_RING_SUPER_AC       152
#define EGO_RING_MAGIC_MIS      153
#define EGO_RING_FIRE_BOLT      154
#define EGO_RING_COLD_BOLT      155
#define EGO_RING_ELEC_BOLT      156
#define EGO_RING_ACID_BOLT      157
#define EGO_RING_MANA_BOLT      158
#define EGO_RING_FIRE_BALL      159
#define EGO_RING_COLD_BALL      160
#define EGO_RING_ELEC_BALL      161
#define EGO_RING_ACID_BALL      162
#define EGO_RING_MANA_BALL      163
#define EGO_RING_DRAGON_F       164
#define EGO_RING_DRAGON_C       165
#define EGO_RING_D_SPEED        166
#define EGO_RING_BERSERKER      167
#define EGO_RING_HUNTER         168
#define EGO_RING_THROW          169
#define EGO_RING_REGEN          170
#define EGO_RING_LITE           171
#define EGO_RING_M_DETECT       172
#define EGO_RING_STEALTH        173
#define EGO_RING_TELE_AWAY      174
#define EGO_RING_TO_H           175
#define EGO_RING_TO_D           176
#define EGO_RING_RES_LITE       177
#define EGO_RING_RES_DARK       178
#define EGO_RING_WIZARD         179
#define EGO_RING_TRUE           180
#define EGO_RING_DRAIN_EXP      181
#define EGO_RING_NO_MELEE       182
#define EGO_RING_AGGRAVATE      183
#define EGO_RING_TY_CURSE       184
#define EGO_RING_RES_TIME       185
#define EGO_RING_TELEPORT       186
#define EGO_RING_ALBINO         187

#define EGO_AMU_SLOW_D          210
#define EGO_AMU_INFRA           211
#define EGO_AMU_SEE_INVIS       212
#define EGO_AMU_HOLD_LIFE       213
#define EGO_AMU_DRAIN_EXP       214
#define EGO_AMU_FOOL            215
#define EGO_AMU_AGGRAVATE       216
#define EGO_AMU_TY_CURSE        217
#define EGO_AMU_AC              218
#define EGO_AMU_IDENT           219
#define EGO_AMU_CHARM           220
#define EGO_AMU_STEALTH         221
#define EGO_AMU_JUMP            222
#define EGO_AMU_TELEPORT        223
#define EGO_AMU_D_DOOR          224
#define EGO_AMU_DEFENDER        225
#define EGO_AMU_RES_FIRE        226
#define EGO_AMU_RES_FIRE_       227
#define EGO_AMU_RES_COLD        228
#define EGO_AMU_RES_COLD_       229
#define EGO_AMU_RES_ELEC        230
#define EGO_AMU_RES_ELEC_       231
#define EGO_AMU_RES_ACID        232
#define EGO_AMU_RES_ACID_       233
#define EGO_AMU_LEVITATION      234
#define EGO_AMU_GREAT           235
#define EGO_AMU_DETECTION       236
#define EGO_AMU_NAIVETY         237

/* Activation effects for random artifacts */
#define ACT_SUNLIGHT            1
#define ACT_BO_MISS_1           2
#define ACT_BA_POIS_1           3
#define ACT_BO_ELEC_1           4
#define ACT_BO_ACID_1           5
#define ACT_BO_COLD_1           6
#define ACT_BO_FIRE_1           7
#define ACT_BA_COLD_1           8
#define ACT_BA_FIRE_1           9
#define ACT_DRAIN_1             10
#define ACT_BA_COLD_2           11
#define ACT_BA_ELEC_2           12
#define ACT_DRAIN_2             13
#define ACT_VAMPIRE_1           14
#define ACT_BO_MISS_2           15
#define ACT_BA_FIRE_2           16
#define ACT_BA_COLD_3           17
#define ACT_BA_ELEC_3           18
#define ACT_WHIRLWIND           19
#define ACT_VAMPIRE_2           20
#define ACT_CALL_CHAOS          21
#define ACT_ROCKET              22
#define ACT_DISP_EVIL           23
#define ACT_BA_MISS_3           24
#define ACT_DISP_GOOD           25
/* 26 - 50 unused */
#define ACT_CONFUSE             51
#define ACT_SLEEP               52
#define ACT_QUAKE               53
#define ACT_TERROR              54
#define ACT_TELE_AWAY           55
#define ACT_BANISH_EVIL         56
#define ACT_GENOCIDE            57
#define ACT_MASS_GENO           58
/* 59 - 64 unused */
#define ACT_CHARM_ANIMAL        65
#define ACT_CHARM_UNDEAD        66
#define ACT_CHARM_OTHER         67
#define ACT_CHARM_ANIMALS       68
#define ACT_CHARM_OTHERS        69
#define ACT_SUMMON_ANIMAL       70
#define ACT_SUMMON_PHANTOM      71
#define ACT_SUMMON_ELEMENTAL    72
#define ACT_SUMMON_DEMON        73
#define ACT_SUMMON_UNDEAD       74
/* 75 - 80 unused */
#define ACT_CURE_LW             81
#define ACT_CURE_MW             82
#define ACT_CURE_POISON         83
#define ACT_REST_LIFE           84
#define ACT_REST_ALL            85
#define ACT_CURE_700            86
#define ACT_CURE_1000           87
/* 88 - 90 unused */
#define ACT_ESP                 91
#define ACT_BERSERK             92
#define ACT_PROT_EVIL           93
#define ACT_RESIST_ALL          94
#define ACT_SPEED               95
#define ACT_XTRA_SPEED          96
#define ACT_WRAITH              97
#define ACT_INVULN              98
/* 99 - 110 unused */
#define ACT_LIGHT               111
#define ACT_MAP_LIGHT           112
#define ACT_DETECT_ALL          113
#define ACT_DETECT_XTRA         114
#define ACT_ID_FULL             115
#define ACT_ID_PLAIN            116
#define ACT_RUNE_EXPLO          117
#define ACT_RUNE_PROT           118
#define ACT_SATIATE             119
#define ACT_DEST_DOOR           120
#define ACT_STONE_MUD           121
#define ACT_RECHARGE            122
#define ACT_ALCHEMY             123
#define ACT_DIM_DOOR            124
#define ACT_TELEPORT            125
#define ACT_RECALL              126
/* 127 -> unused */

/*** Object "tval" and "sval" codes ***/


/*
 * The values for the "tval" field of various objects.
 *
 * This value is the primary means by which items are sorted in the
 * player inventory, followed by "sval" and "cost".
 *
 * Note that a "BOW" with tval = 19 and sval S = 10*N+P takes a missile
 * weapon with tval = 16+N, and does (xP) damage when so combined.  This
 * fact is not actually used in the source, but it kind of interesting.
 *
 * Note that as of 2.7.8, the "item flags" apply to all items, though
 * only armor and weapons and a few other items use any of these flags.
 */

#define TV_SKELETON      1      /* Skeletons ('s'), not specified */
#define TV_BOTTLE        2      /* Empty bottles ('!') */
#define TV_JUNK          3      /* Sticks, Pottery, etc ('~') */
#define TV_WHISTLE       4      /* Whistle ('~') */
#define TV_SPIKE         5      /* Spikes ('~') */
#define TV_CHEST         7      /* Chests ('&') */
#define TV_FIGURINE      8      /* Magical figurines */
#define TV_STATUE        9      /* Statue, what a silly object... */
#define TV_CORPSE       10      /* Corpses and Skeletons, specific */
#define TV_CAPTURE      11      /* Creature ball */
#define TV_NO_AMMO      15      /* Ammo for crimson */
#define TV_SHOT         16      /* Ammo for slings */
#define TV_ARROW        17      /* Ammo for bows */
#define TV_BOLT         18      /* Ammo for x-bows */
#define TV_BOW          19      /* Slings/Bows/Xbows */
#define TV_DIGGING      20      /* Shovels/Picks */
#define TV_HAFTED       21      /* Priest Weapons */
#define TV_POLEARM      22      /* Axes and Pikes */
#define TV_SWORD        23      /* Edged Weapons */
#define TV_BOOTS        30      /* Boots */
#define TV_GLOVES       31      /* Gloves */
#define TV_HELM         32      /* Helms */
#define TV_CROWN        33      /* Crowns */
#define TV_SHIELD       34      /* Shields */
#define TV_CLOAK        35      /* Cloaks */
#define TV_SOFT_ARMOR   36      /* Soft Armor */
#define TV_HARD_ARMOR   37      /* Hard Armor */
#define TV_DRAG_ARMOR   38      /* Dragon Scale Mail */
#define TV_LITE         39      /* Lites (including Specials) */
#define TV_AMULET       40      /* Amulets (including Specials) */
#define TV_TAIL         41
#define TV_INSTRUMENT   42
#define TV_RING         45      /* Rings (including Specials) */
#define TV_CARD         50
#define TV_WHEEL        51
#define TV_STAFF        55
#define TV_WAND         65
#define TV_ROD          66
#define TV_PARCHMENT    69
#define TV_SCROLL       70
#define TV_POTION       75
#define TV_FLASK        77
#define TV_FOOD         80
#define TV_LIFE_BOOK    90
#define TV_SORCERY_BOOK 91
#define TV_NATURE_BOOK  92
#define TV_CHAOS_BOOK   93
#define TV_DEATH_BOOK   94
#define TV_TRUMP_BOOK   95
#define TV_ARCANE_BOOK  96
#define TV_CRAFT_BOOK   97
#define TV_DAEMON_BOOK  98
#define TV_CRUSADE_BOOK 99
#define TV_MUSIC_BOOK   105
#define TV_HISSATSU_BOOK 106
#define TV_HEX_BOOK     107
#define TV_GOLD         127     /* Gold can only be picked up by players */

#define TV_EQUIP_BEGIN    TV_SHOT
#define TV_EQUIP_END      TV_CARD
#define TV_MISSILE_BEGIN  TV_SHOT
#define TV_MISSILE_END    TV_BOLT
#define TV_WEARABLE_BEGIN TV_BOW
#define TV_WEARABLE_END   TV_CARD
#define TV_WEAPON_BEGIN   TV_BOW
#define TV_WEAPON_END     TV_SWORD
#define TV_ARMOR_BEGIN    TV_BOOTS
#define TV_ARMOR_END      TV_DRAG_ARMOR


#define ARMOR_SIZE_FREE		0 /* Zero size is valiable. */
#define ITEM_FREE_SIZE			0

/* The "sval" codes for TV_FIGURINE */
#define SV_FIGURINE_NORMAL		0

#define SV_CAPTURE_NONE		0

/* The "sval" codes for TV_STATUE */
#define SV_WOODEN_STATUE		0
#define SV_CLAY_STATUE			1
#define SV_STONE_STATUE			2
#define SV_IRON_STATUE			3
#define SV_COPPER_STATUE		4
#define SV_SILVER_STATUE		5
#define SV_GOLDEN_STATUE		6
#define SV_IVORY_STATUE			7
#define SV_MITHRIL_STATUE		8
#define SV_ORNATE_STATUE		9
#define SV_DAKIMAKURA			10
#define SV_OIL_PAINT			11
#define SV_DOUJINSHI			12
#define SV_FS_FIGURE			13
#define SV_FIGURE				14
#define SV_PHOTO				50

/* The "sval" codes for TV_CORPSE */
#define SV_SKELETON 			0
#define SV_CORPSE				1
#define SV_HEAD					2
#define SV_HAND					3
#define SV_FOOT					4
#define SV_CURCUSS				5

/* The "sval" codes for TV_SHOT/TV_ARROW/TV_BOLT */
#define SV_AMMO_LIGHT                    0	/* pebbles */
#define SV_AMMO_NORMAL                   1	/* shots, arrows, bolts */
#define SV_AMMO_HEAVY                    2	/* seeker arrows and bolts, mithril shots */

/* The "sval" codes for TV_BOW (note information in "sval") */
#define SV_SLING                         2	/* (x2) */
#define SV_SHORT_BOW                    12	/* (x2) */
#define SV_LONG_BOW                     13	/* (x3) */
#define SV_LIGHT_XBOW                   23	/* (x3) */
#define SV_HEAVY_XBOW                   24	/* (x4) */
#define SV_CRIMSON                      50	/* (x0) */
#define SV_NAMAKE_BOW                   63	/* (x3) */

/* The "sval" codes for TV_DIGGING */
#define SV_SHOVEL                        1
#define SV_GNOMISH_SHOVEL                2
#define SV_DWARVEN_SHOVEL                3
#define SV_PICK                          4
#define SV_ORCISH_PICK                   5
#define SV_DWARVEN_PICK                  6
#define SV_MATTOCK                       7

/* The "sval" values for TV_HAFTED */
#define SV_CLUB                          1	/* 1d4  */
#define SV_WHIP                          2	/* 1d6  */
#define SV_QUARTERSTAFF                  3	/* 1d9  */
#define SV_NUNCHAKU                      4	/* 2d3  */
#define SV_MACE                          5	/* 2d4  */
#define SV_BALL_AND_CHAIN                6	/* 2d4  */
#define SV_JO_STAFF                      7	/* 1d7  */
#define SV_WAR_HAMMER                    8	/* 3d3  */
#define SV_THREE_PIECE_ROD              11	/* 3d3  */
#define SV_MORNING_STAR                 12	/* 2d6  */
#define SV_FLAIL                        13	/* 2d6  */
#define SV_BO_STAFF                     14	/* 1d11 */
#define SV_LEAD_FILLED_MACE             15	/* 3d4  */
#define SV_TETSUBO                      16	/* 2d7  */
#define SV_TWO_HANDED_FLAIL             18	/* 3d6  */
#define SV_GREAT_HAMMER                 19	/* 4d6  */
#define SV_MACE_OF_DISRUPTION           20	/* 5d8  */
#define SV_WIZSTAFF                     21	/* 1d2  */
#define SV_ISTARISTAFF                  22	/* 2d2  */
#define SV_GROND                        50	/* 3d9  */
#define SV_NAMAKE_HAMMER                63	/* 1d77 */

/* The "sval" values for TV_POLEARM */
#define SV_HATCHET                       1	/* 1d5 */
#define SV_SPEAR                         2	/* 1d6 */
#define SV_SICKLE                        3	/* 2d3 */
#define SV_AWL_PIKE                      4	/* 1d8 */
#define SV_TRIDENT                       5	/* 1d9 */
#define SV_FAUCHARD                      6  /* 1d10 */
#define SV_BROAD_SPEAR                   7	/* 1d9 */
#define SV_PIKE                          8	/* 2d5 */
#define SV_NAGINATA                      9  /* 2d6 */
#define SV_BEAKED_AXE                   10	/* 2d6 */
#define SV_BROAD_AXE                    11	/* 2d6 */
#define SV_LUCERNE_HAMMER               12	/* 2d5  */
#define SV_GLAIVE                       13	/* 2d6 */
#define SV_LAJATANG                     14	/* 2d7 */
#define SV_HALBERD                      15	/* 3d4 */
#define SV_GUISARME                     16  /* 2d5 */
#define SV_SCYTHE                       17	/* 5d3 */
#define SV_LANCE                        20	/* 2d8 */
#define SV_BATTLE_AXE                   22	/* 2d8 */
#define SV_GREAT_AXE                    25	/* 4d4 */
#define SV_TRIFURCATE_SPEAR             26	/* 2d9 */
#define SV_LOCHABER_AXE                 28	/* 3d8 */
#define SV_HEAVY_LANCE                  29  /* 4d8 */
#define SV_SCYTHE_OF_SLICING            30	/* 8d4 */
#define SV_TSURIZAO                     40	/* 1d1 */
#define SV_DEATH_SCYTHE                 50	/* 10d10 */

/* The "sval" codes for TV_SWORD */
#define SV_BROKEN_DAGGER                 1  /* 1d1 */
#define SV_BROKEN_SWORD                  2  /* 1d2 */
#define SV_DAGGER                        4  /* 1d4 */
#define SV_MAIN_GAUCHE                   5  /* 1d5 */
#define SV_TANTO                         6  /* 1d5 */
#define SV_RAPIER                        7  /* 1d6 */
#define SV_SMALL_SWORD                   8  /* 1d6 */
#define SV_BASILLARD                     9  /* 1d8 */
#define SV_SHORT_SWORD                  10  /* 1d7 */
#define SV_SABRE                        11  /* 1d7 */
#define SV_CUTLASS                      12  /* 1d7 */
#define SV_WAKIZASHI                    13  /* 2d4 */
#define SV_KHOPESH                      14  /* 2d4 */
#define SV_TULWAR                       15  /* 2d4 */
#define SV_BROAD_SWORD                  16  /* 2d5 */
#define SV_LONG_SWORD                   17  /* 2d5 */
#define SV_SCIMITAR                     18  /* 2d5 */
#define SV_NINJATO                      19  /* 1d9 */
#define SV_KATANA                       20  /* 3d4 */
#define SV_BASTARD_SWORD                21  /* 3d4 */
#define SV_GREAT_SCIMITAR               22  /* 4d5 */
#define SV_CLAYMORE                     23  /* 2d8 */
#define SV_ESPADON                      24  /* 2d9 */
#define SV_TWO_HANDED_SWORD             25  /* 3d6 */
#define SV_FLAMBERGE                    26  /* 3d7 */
#define SV_NO_DACHI                     27  /* 5d4 */
#define SV_EXECUTIONERS_SWORD           28  /* 4d5 */
#define SV_ZWEIHANDER                   29  /* 4d6 */
#define SV_BLADE_OF_CHAOS               30  /* 6d5 */
#define SV_DIAMOND_EDGE                 31  /* 7d5 */
#define SV_DOKUBARI                     32  /* 1d1 */
#define SV_HAYABUSA                     33  /* 1d6 */
#define SV_URUKS_STRAIGHT_SWORD         34

/* The "sval" codes for TV_SHIELD */
#define SV_SMALL_LEATHER_SHIELD          2
#define SV_SMALL_METAL_SHIELD            3
#define SV_LARGE_LEATHER_SHIELD          4
#define SV_LARGE_METAL_SHIELD            5
#define SV_DRAGON_SHIELD                 6
#define SV_KNIGHT_SHIELD                 7
#define SV_MIRROR_SHIELD                10
#define SV_YATA_MIRROR                  50

/* The "sval" codes for TV_HELM */
#define SV_HARD_LEATHER_CAP              2
#define SV_METAL_CAP                     3
#define SV_JINGASA                       4  /* 4 */
#define SV_IRON_HELM                     5
#define SV_STEEL_HELM                    6
#define SV_DRAGON_HELM                   7
#define SV_KABUTO                        8  /* 7 */

/* The "sval" codes for TV_CROWN */
#define SV_IRON_CROWN                   10
#define SV_GOLDEN_CROWN                 11
#define SV_JEWELED_CROWN                12
#define SV_CHAOS                        50

/* The "sval" codes for TV_BOOTS */
#define SV_PAIR_OF_SOFT_LEATHER_BOOTS    2
#define SV_PAIR_OF_HARD_LEATHER_BOOTS    3
#define SV_PAIR_OF_DRAGON_GREAVE         4
#define SV_PAIR_OF_METAL_SHOD_BOOTS      6

/* The "sval" codes for TV_CLOAK */
#define SV_CLOAK                         1
#define SV_ELVEN_CLOAK                   2
#define SV_FUR_CLOAK                     3
#define SV_ETHEREAL_CLOAK                5
#define SV_SHADOW_CLOAK                  6

/* The "sval" codes for TV_GLOVES */
#define SV_SET_OF_LEATHER_GLOVES         1
#define SV_SET_OF_GAUNTLETS              2
#define SV_SET_OF_DRAGON_GLOVES          3
#define SV_SET_OF_CESTI                  5

/* The "sval" codes for TV_SOFT_ARMOR */
#define SV_T_SHIRT                       0
#define SV_FILTHY_RAG                    1
#define SV_ROBE                          2
#define SV_PAPER_ARMOR                   3  /* 4 */
#define SV_SOFT_LEATHER_ARMOR            4
#define SV_SOFT_STUDDED_LEATHER          5
#define SV_HARD_LEATHER_ARMOR            6
#define SV_HARD_STUDDED_LEATHER          7
#define SV_RHINO_HIDE_ARMOR              8
#define SV_CORD_ARMOR                    9  /*  6 */
#define SV_PADDED_ARMOR                 10  /*  4 */
#define SV_LEATHER_SCALE_MAIL           11
#define SV_LEATHER_JACK                 12
#define SV_KUROSHOUZOKU                 13
#define SV_STONE_AND_HIDE_ARMOR         15  /* 15 */
#define SV_ABUNAI_MIZUGI                50
#define SV_YOIYAMI_ROBE                 60
#define SV_NAMAKE_ARMOR                 63

/* The "sval" codes for TV_HARD_ARMOR */
#define SV_RUSTY_CHAIN_MAIL              1  /* 14- */
#define SV_RING_MAIL                     2  /* 12  */
#define SV_METAL_SCALE_MAIL              3  /* 13  */
#define SV_CHAIN_MAIL                    4  /* 14  */
#define SV_DOUBLE_RING_MAIL              5  /* 15  */
#define SV_AUGMENTED_CHAIN_MAIL          6  /* 16  */
#define SV_DOUBLE_CHAIN_MAIL             7  /* 16  */
#define SV_BAR_CHAIN_MAIL                8  /* 18  */
#define SV_METAL_BRIGANDINE_ARMOUR       9  /* 19  */
#define SV_SPLINT_MAIL                  10  /* 19  */
#define SV_DO_MARU                      11  /* 20  */
#define SV_PARTIAL_PLATE_ARMOUR         12  /* 22  */
#define SV_METAL_LAMELLAR_ARMOUR        13  /* 23  */
#define SV_HARAMAKIDO                   14  /* 17  */
#define SV_FULL_PLATE_ARMOUR            15  /* 25  */
#define SV_O_YOROI                      16  /* 24  */
#define SV_RIBBED_PLATE_ARMOUR          18  /* 28  */
#define SV_MITHRIL_CHAIN_MAIL           20  /* 28+ */
#define SV_MITHRIL_PLATE_MAIL           25  /* 35+ */
#define SV_ADAMANTITE_PLATE_MAIL        30  /* 40+ */
#define SV_CHAOS_ARMOR                  35  /*  */


/* The "sval" codes for TV_DRAG_ARMOR */
#define SV_DRAGON_BLACK                  1
#define SV_DRAGON_BLUE                   2
#define SV_DRAGON_WHITE                  3
#define SV_DRAGON_RED                    4
#define SV_DRAGON_GREEN                  5
#define SV_DRAGON_MULTIHUED              6
#define SV_DRAGON_SHINING               10
#define SV_DRAGON_LAW                   12
#define SV_DRAGON_BRONZE                14
#define SV_DRAGON_GOLD                  16
#define SV_DRAGON_CHAOS                 18
#define SV_DRAGON_BALANCE               20
#define SV_DRAGON_POWER                 30

/* The sval codes for TV_LITE */
#define SV_LITE_TORCH                    0
#define SV_LITE_LANTERN                  1
#define SV_LITE_FEANOR                   2
#define SV_LITE_EDISON                   3
#define SV_LITE_GALADRIEL                4
#define SV_LITE_ELENDIL                  5
#define SV_LITE_JUDGE                    6
#define SV_LITE_LORE                     7
#define SV_LITE_PALANTIR                 8
#define SV_LITE_FLY_STONE                9
#define SV_LITE_ALDA                    10
#define SV_LITE_UDUN                    11

/* The "sval" codes for TV_AMULET */
#define SV_AMULET_DOOM                   0
#define SV_AMULET_TELEPORT               1
#define SV_AMULET_ADORNMENT              2
#define SV_AMULET_SLOW_DIGEST            3
#define SV_AMULET_RESIST_ACID            4
#define SV_AMULET_SEARCHING              5
#define SV_AMULET_BRILLIANCE             6
#define SV_AMULET_CHARISMA               7
#define SV_AMULET_THE_MAGI               8
#define SV_AMULET_REFLECTION             9
#define SV_AMULET_CARLAMMAS             10
#define SV_AMULET_INGWE                 11
#define SV_AMULET_DWARVES               12
#define SV_AMULET_NO_MAGIC              13
#define SV_AMULET_NO_TELE               14
#define SV_AMULET_RESISTANCE            15
#define SV_AMULET_TELEPATHY             16
#define SV_AMULET_FARAMIR               17
#define SV_AMULET_BOROMIR               18
#define SV_AMULET_MAGATAMA              19
#define SV_AMULET_INROU                 20
#define SV_AMULET_INTELLIGENCE          21
#define SV_AMULET_WISDOM                22
#define SV_AMULET_MAGIC_MASTERY         23
#define SV_AMULET_NIGHT                 24

/* The sval codes for TV_RING */
#define SV_RING_WOE                      0
#define SV_RING_AGGRAVATION              1
#define SV_RING_WEAKNESS                 2
#define SV_RING_STUPIDITY                3
#define SV_RING_TELEPORTATION            4
#define SV_RING_SLOW_DIGESTION           6
#define SV_RING_LEVITATION_FALL          7
#define SV_RING_RESIST_FIRE              8
#define SV_RING_RESIST_COLD              9
#define SV_RING_SUSTAIN_STR             10
#define SV_RING_SUSTAIN_INT             11
#define SV_RING_SUSTAIN_WIS             12
#define SV_RING_SUSTAIN_CON             13
#define SV_RING_SUSTAIN_DEX             14
#define SV_RING_SUSTAIN_CHR             15
#define SV_RING_PROTECTION              16
#define SV_RING_ACID                    17
#define SV_RING_FLAMES                  18
#define SV_RING_ICE                     19
#define SV_RING_RESIST_POIS             20
#define SV_RING_FREE_ACTION             21
#define SV_RING_SEE_INVIS               22
#define SV_RING_SEARCHING               23
#define SV_RING_STR                     24
#define SV_RING_ELEC                    25
#define SV_RING_DEX                     26
#define SV_RING_CON                     27
#define SV_RING_ACCURACY                28
#define SV_RING_DAMAGE                  29
#define SV_RING_SLAYING                 30
#define SV_RING_SPEED                   31
#define SV_RING_FRAKIR                  32
#define SV_RING_TULKAS                  33
#define SV_RING_NARYA                   34
#define SV_RING_NENYA                   35
#define SV_RING_VILYA                   36
#define SV_RING_POWER                   37
#define SV_RING_RES_FEAR                38
#define SV_RING_RES_LD                  39
#define SV_RING_RES_NETHER              40
#define SV_RING_RES_NEXUS               41
#define SV_RING_RES_SOUND               42
#define SV_RING_RES_CONFUSION           43
#define SV_RING_RES_SHARDS              44
#define SV_RING_RES_DISENCHANT          45
#define SV_RING_RES_CHAOS               46
#define SV_RING_RES_BLINDNESS           47
#define SV_RING_LORDLY                  48
#define SV_RING_ATTACKS                 49
#define SV_RING_AHO                     50
#define SV_RING_SHOTS                   51
#define SV_RING_SUSTAIN                 52
#define SV_RING_DEC_MANA                53
#define SV_RING_WARNING                 54
#define SV_RING_MUSCLE                  55

#define SV_EXPRESS_CARD                  0

/* The sval codes for TV_TAIL */
#define SV_TAIL_BARD					 0
#define SV_TAIL_LETHER					 1
#define SV_TAIL_CHAIN_MAIL				 2

/* The sval codes for TV_INSTRUMENT */
#define SV_INSTRUMENT_LUTE				 0

/* The "sval" codes for TV_STAFF */
#define SV_STAFF_DARKNESS                0
#define SV_STAFF_SLOWNESS                1
#define SV_STAFF_HASTE_MONSTERS          2
#define SV_STAFF_SUMMONING               3
#define SV_STAFF_TELEPORTATION           4
#define SV_STAFF_IDENTIFY                5
#define SV_STAFF_REMOVE_CURSE            6
#define SV_STAFF_STARLITE                7
#define SV_STAFF_LITE                    8
#define SV_STAFF_MAPPING                 9
#define SV_STAFF_DETECT_GOLD            10
#define SV_STAFF_DETECT_ITEM            11
#define SV_STAFF_DETECT_TRAP            12
#define SV_STAFF_DETECT_DOOR            13
#define SV_STAFF_DETECT_INVIS           14
#define SV_STAFF_DETECT_EVIL            15
#define SV_STAFF_CURE_LIGHT             16
#define SV_STAFF_CURING                 17
#define SV_STAFF_HEALING                18
#define SV_STAFF_THE_MAGI               19
#define SV_STAFF_SLEEP_MONSTERS         20
#define SV_STAFF_SLOW_MONSTERS          21
#define SV_STAFF_SPEED                  22
#define SV_STAFF_PROBING                23
#define SV_STAFF_DISPEL_EVIL            24
#define SV_STAFF_POWER                  25
#define SV_STAFF_HOLINESS               26
#define SV_STAFF_GENOCIDE               27
#define SV_STAFF_EARTHQUAKES            28
#define SV_STAFF_DESTRUCTION            29
#define SV_STAFF_ANIMATE_DEAD           30
#define SV_STAFF_MSTORM                 31
#define SV_STAFF_NOTHING                32


/* The "sval" codes for TV_WAND */
#define SV_WAND_HEAL_OTHER_CREATURE      0
#define SV_WAND_HASTE_MONSTER            1
#define SV_WAND_CLONE_MONSTER            2
#define SV_WAND_TELEPORT_AWAY            3
#define SV_WAND_DISARMING                4
#define SV_WAND_TRAP_DOOR_DEST           5
#define SV_WAND_STONE_TO_MUD             6
#define SV_WAND_LITE                     7
#define SV_WAND_SLEEP_MONSTER            8
#define SV_WAND_SLOW_MONSTER             9
#define SV_WAND_CONFUSE_MONSTER         10
#define SV_WAND_FEAR_MONSTER            11
#define SV_WAND_DRAIN_LIFE              12
#define SV_WAND_POLYMORPH               13
#define SV_WAND_STINKING_CLOUD          14
#define SV_WAND_MAGIC_MISSILE           15
#define SV_WAND_ACID_BOLT               16
#define SV_WAND_CHARM_MONSTER           17
#define SV_WAND_FIRE_BOLT               18
#define SV_WAND_COLD_BOLT               19
#define SV_WAND_ACID_BALL               20
#define SV_WAND_ELEC_BALL               21
#define SV_WAND_FIRE_BALL               22
#define SV_WAND_COLD_BALL               23
#define SV_WAND_WONDER                  24
#define SV_WAND_DISINTEGRATE            25
#define SV_WAND_DRAGON_FIRE             26
#define SV_WAND_DRAGON_COLD             27
#define SV_WAND_DRAGON_BREATH           28
#define SV_WAND_ROCKETS                 29
#define SV_WAND_STRIKING                30
#define SV_WAND_GENOCIDE                31

/* The "sval" codes for TV_ROD */
#define SV_ROD_DETECT_TRAP               0
#define SV_ROD_DETECT_DOOR               1
#define SV_ROD_IDENTIFY                  2
#define SV_ROD_RECALL                    3
#define SV_ROD_ILLUMINATION              4
#define SV_ROD_MAPPING                   5
#define SV_ROD_DETECTION                 6
#define SV_ROD_PROBING                   7
#define SV_ROD_CURING                    8
#define SV_ROD_HEALING                   9
#define SV_ROD_RESTORATION              10
#define SV_ROD_SPEED                    11
#define SV_ROD_PESTICIDE                12
#define SV_ROD_TELEPORT_AWAY            13
#define SV_ROD_DISARMING                14
#define SV_ROD_LITE                     15
#define SV_ROD_SLEEP_MONSTER            16
#define SV_ROD_SLOW_MONSTER             17
#define SV_ROD_DRAIN_LIFE               18
#define SV_ROD_POLYMORPH                19
#define SV_ROD_ACID_BOLT                20
#define SV_ROD_ELEC_BOLT                21
#define SV_ROD_FIRE_BOLT                22
#define SV_ROD_COLD_BOLT                23
#define SV_ROD_ACID_BALL                24
#define SV_ROD_ELEC_BALL                25
#define SV_ROD_FIRE_BALL                26
#define SV_ROD_COLD_BALL                27
#define SV_ROD_HAVOC                    28
#define SV_ROD_STONE_TO_MUD             29
#define SV_ROD_AGGRAVATE                30


/* The "sval" codes for TV_SCROLL */

#define SV_SCROLL_DARKNESS               0
#define SV_SCROLL_AGGRAVATE_MONSTER      1
#define SV_SCROLL_CURSE_ARMOR            2
#define SV_SCROLL_CURSE_WEAPON           3
#define SV_SCROLL_SUMMON_MONSTER         4
#define SV_SCROLL_SUMMON_UNDEAD          5
#define SV_SCROLL_SUMMON_PET             6
#define SV_SCROLL_TRAP_CREATION          7
#define SV_SCROLL_PHASE_DOOR             8
#define SV_SCROLL_TELEPORT               9
#define SV_SCROLL_TELEPORT_LEVEL        10
#define SV_SCROLL_WORD_OF_RECALL        11
#define SV_SCROLL_IDENTIFY              12
#define SV_SCROLL_STAR_IDENTIFY         13
#define SV_SCROLL_REMOVE_CURSE          14
#define SV_SCROLL_STAR_REMOVE_CURSE     15
#define SV_SCROLL_ENCHANT_ARMOR         16
#define SV_SCROLL_ENCHANT_WEAPON_TO_HIT 17
#define SV_SCROLL_ENCHANT_WEAPON_TO_DAM 18
/* xxx enchant missile? */
#define SV_SCROLL_STAR_ENCHANT_ARMOR    20
#define SV_SCROLL_STAR_ENCHANT_WEAPON   21
#define SV_SCROLL_RECHARGING            22
#define SV_SCROLL_MUNDANITY             23
#define SV_SCROLL_LIGHT                 24
#define SV_SCROLL_MAPPING               25
#define SV_SCROLL_DETECT_GOLD           26
#define SV_SCROLL_DETECT_ITEM           27
#define SV_SCROLL_DETECT_TRAP           28
#define SV_SCROLL_DETECT_DOOR           29
#define SV_SCROLL_DETECT_INVIS          30
/* xxx (detect evil?) */
#define SV_SCROLL_SATISFY_HUNGER        32
#define SV_SCROLL_BLESSING              33
#define SV_SCROLL_HOLY_CHANT            34
#define SV_SCROLL_HOLY_PRAYER           35
#define SV_SCROLL_MONSTER_CONFUSION     36
#define SV_SCROLL_PROTECTION_FROM_EVIL  37
#define SV_SCROLL_RUNE_OF_PROTECTION    38
#define SV_SCROLL_TRAP_DOOR_DESTRUCTION 39
/* xxx */
#define SV_SCROLL_STAR_DESTRUCTION      41
#define SV_SCROLL_DISPEL_UNDEAD         42
#define SV_SCROLL_SPELL                 43
#define SV_SCROLL_GENOCIDE              44
#define SV_SCROLL_MASS_GENOCIDE         45
#define SV_SCROLL_ACQUIREMENT           46
#define SV_SCROLL_STAR_ACQUIREMENT      47
#define SV_SCROLL_FIRE                  48
#define SV_SCROLL_ICE                   49
#define SV_SCROLL_CHAOS                 50
#define SV_SCROLL_RUMOR                 51
#define SV_SCROLL_ARTIFACT              52
#define SV_SCROLL_RESET_RECALL          53
#define SV_SCROLL_SUMMON_KIN            54

/* The "sval" codes for TV_POTION */
#define SV_POTION_WATER                  0
#define SV_POTION_APPLE_JUICE            1
#define SV_POTION_SLIME_MOLD             2
/* xxx (fixed color) */
#define SV_POTION_SLOWNESS               4
#define SV_POTION_SALT_WATER             5
#define SV_POTION_POISON                 6
#define SV_POTION_BLINDNESS              7
/* xxx */
#define SV_POTION_CONFUSION              9
/* xxx */
#define SV_POTION_SLEEP                 11
/* xxx */
#define SV_POTION_LOSE_MEMORIES         13
/* xxx */
#define SV_POTION_RUINATION             15
#define SV_POTION_DEC_STR               16
#define SV_POTION_DEC_INT               17
#define SV_POTION_DEC_WIS               18
#define SV_POTION_DEC_DEX               19
#define SV_POTION_DEC_CON               20
#define SV_POTION_DEC_CHR               21
#define SV_POTION_DETONATIONS           22
#define SV_POTION_DEATH                 23
#define SV_POTION_INFRAVISION           24
#define SV_POTION_DETECT_INVIS          25
#define SV_POTION_SLOW_POISON           26
#define SV_POTION_CURE_POISON           27
#define SV_POTION_BOLDNESS              28
#define SV_POTION_SPEED                 29
#define SV_POTION_RESIST_HEAT           30
#define SV_POTION_RESIST_COLD           31
#define SV_POTION_HEROISM               32
#define SV_POTION_BESERK_STRENGTH       33
#define SV_POTION_CURE_LIGHT            34
#define SV_POTION_CURE_SERIOUS          35
#define SV_POTION_CURE_CRITICAL         36
#define SV_POTION_HEALING               37
#define SV_POTION_STAR_HEALING          38
#define SV_POTION_LIFE                  39
#define SV_POTION_RESTORE_MANA          40
#define SV_POTION_RESTORE_EXP           41
#define SV_POTION_RES_STR               42
#define SV_POTION_RES_INT               43
#define SV_POTION_RES_WIS               44
#define SV_POTION_RES_DEX               45
#define SV_POTION_RES_CON               46
#define SV_POTION_RES_CHR               47
#define SV_POTION_INC_STR               48
#define SV_POTION_INC_INT               49
#define SV_POTION_INC_WIS               50
#define SV_POTION_INC_DEX               51
#define SV_POTION_INC_CON               52
#define SV_POTION_INC_CHR               53
/* xxx */
#define SV_POTION_AUGMENTATION          55
#define SV_POTION_ENLIGHTENMENT         56
#define SV_POTION_STAR_ENLIGHTENMENT    57
#define SV_POTION_SELF_KNOWLEDGE        58
#define SV_POTION_EXPERIENCE            59
#define SV_POTION_RESISTANCE            60
#define SV_POTION_CURING                61
#define SV_POTION_INVULNERABILITY       62
#define SV_POTION_NEW_LIFE              63
#define SV_POTION_NEO_TSUYOSHI          64
#define SV_POTION_TSUYOSHI              65
#define SV_POTION_POLYMORPH             66

/* The "sval" codes for TV_FLASK */
#define SV_FLASK_OIL                   0

/* The "sval" codes for TV_FOOD */
#define SV_FOOD_POISON                   0
#define SV_FOOD_BLINDNESS                1
#define SV_FOOD_PARANOIA                 2
#define SV_FOOD_CONFUSION                3
#define SV_FOOD_HALLUCINATION            4
#define SV_FOOD_PARALYSIS                5
#define SV_FOOD_WEAKNESS                 6
#define SV_FOOD_SICKNESS                 7
#define SV_FOOD_STUPIDITY                8
#define SV_FOOD_NAIVETY                  9
#define SV_FOOD_UNHEALTH                10
#define SV_FOOD_DISEASE                 11
#define SV_FOOD_CURE_POISON             12
#define SV_FOOD_CURE_BLINDNESS          13
#define SV_FOOD_CURE_PARANOIA           14
#define SV_FOOD_CURE_CONFUSION          15
#define SV_FOOD_CURE_SERIOUS            16
#define SV_FOOD_RESTORE_STR             17
#define SV_FOOD_RESTORE_CON             18
#define SV_FOOD_RESTORING               19
/* many missing mushrooms */
#define SV_FOOD_BISCUIT                 32
#define SV_FOOD_JERKY                   33
#define SV_FOOD_RATION                  35
#define SV_FOOD_SLIME_MOLD              36
#define SV_FOOD_WAYBREAD                37
#define SV_FOOD_PINT_OF_ALE             38
#define SV_FOOD_PINT_OF_WINE            39


/*
 * Special "sval" limit -- first "normal" food
 */
#define SV_FOOD_MIN_FOOD                32

/*
 * Special "sval" limit -- first "aimed" rod
 */
#define SV_ROD_MIN_DIRECTION    12

/*
 * Special "sval" limit -- first "large" chest
 */
#define SV_CHEST_MIN_LARGE      4
#define SV_CHEST_KANDUME        50

/*
 * Special "sval" limit -- first "good" magic/prayer book
 */
#define SV_BOOK_MIN_GOOD    2


// Special "sval" --- generate by level
#define SV_ANY 255




#define OBJ_GOLD_LIST   480     /* First "gold" entry */
#define MAX_GOLD        18      /* Number of "gold" entries */


/*** General flag values ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK       0x0001    /* memorized feature */
#define CAVE_GLOW       0x0002    /* self-illuminating */
#define CAVE_ICKY       0x0004    /* part of a vault */
#define CAVE_ROOM       0x0008    /* part of a room */
#define CAVE_LITE       0x0010    /* lite flag  */
#define CAVE_VIEW       0x0020    /* view flag */
#define CAVE_TEMP       0x0040    /* temp flag */
#define CAVE_XTRA       0x0080    /* misc flag */
#define CAVE_MNLT       0x0100    /* Illuminated by creature */
#define CAVE_MNDK       0x8000    /* Darken by creature */

/* Used only while cave generation */
#define CAVE_FLOOR      0x0200
#define CAVE_EXTRA      0x0400
#define CAVE_INNER      0x0800
#define CAVE_OUTER      0x1000
#define CAVE_SOLID      0x2000
#define CAVE_VAULT      0x4000
#define CAVE_MASK (CAVE_FLOOR | CAVE_EXTRA | CAVE_INNER | CAVE_OUTER | CAVE_SOLID | CAVE_VAULT)

/* Used only after cave generation */
#define CAVE_XXXX1      0x0200
#define CAVE_NOTE       0x0400    /* Flag for delayed visual update (needs note_spot()) */
#define CAVE_REDRAW     0x0800    /* Flag for delayed visual update (needs lite_spot(floor_ptr, )) */
#define CAVE_OBJECT     0x1000    /* Mirror, glyph, etc. */
#define CAVE_UNSAFE     0x2000    /* Might have trap */
#define CAVE_IN_DETECT  0x4000    /* trap detected area (inner circle only) */

#define CAVE_MESSAGE_LENGTH 250


/*
 * Bit flags for the "project()" function
 *
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   STOP: Stop as soon as we hit a creature (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each creature in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 *   DISI: Disintegrate non-permanent features
 *   PLAYER: Main target is player (used for riding player)
 *   AIMED: Target is only player or creature, so don't affect another.
 *          Depend on PROJECT_PLAYER.
 *          (used for minimum (rad == 0) balls on riding player)
 *   REFLECTABLE: Refrectable spell attacks (used for "bolts")
 *   NO_HANGEKI: Avoid counter attacks of creatures
 *   PATH: Only used for printing project path
 *   FAST: Hide "visual" of flying bolts until blast
 */
#define PROJECT_JUMP        0x01
#define PROJECT_BEAM        0x02
#define PROJECT_THRU        0x04
#define PROJECT_STOP        0x08
#define PROJECT_GRID        0x10
#define PROJECT_ITEM        0x20
#define PROJECT_KILL        0x40
#define PROJECT_HIDE        0x80
#define PROJECT_DISI        0x100
#define PROJECT_PLAYER      0x200
#define PROJECT_AIMED       0x400
#define PROJECT_REFLECTABLE 0x800
#define PROJECT_NO_HANGEKI  0x1000
#define PROJECT_PATH        0x2000
#define PROJECT_FAST        0x4000
#define PROJECT_LOS         0x8000


/*
 * Special caster ID for project()
 */
#define PROJECT_WHO_UNCTRL_POWER -1
#define PROJECT_WHO_GLASS_SHARDS -2


/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT      0x01 /* Enchant to hit */
#define ENCH_TODAM      0x02 /* Enchant to damage */
#define ENCH_TOAC       0x04 /* Enchant to AC */
#define ENCH_FORCE      0x08 /* Force enchantment */

/*
 * Bit flags for the "target_set" function XXX XXX XXX
 *
 *      KILL: Target creatures
 *      LOOK: Describe grid fully
 *      XTRA: Currently unused flag
 *      GRID: Select from all grids
 */
#define TARGET_KILL             0x01
#define TARGET_LOOK             0x02
#define TARGET_XTRA             0x04
#define TARGET_GRID             0x08


/*
 * Bit flags for control of get_check_strict()
 */
#define CHECK_OKAY_CANCEL 0x01
#define CHECK_NO_ESCAPE   0x02
#define CHECK_NO_HISTORY  0x04
#define CHECK_DEFAULT_Y   0x08


/*
 * Some bit-flags for the "smart" field
 */
#define SM_RES_ACID             0x00000001
#define SM_RES_ELEC             0x00000002
#define SM_RES_FIRE             0x00000004
#define SM_RES_COLD             0x00000008
#define SM_RES_POIS             0x00000010
#define SM_RES_NETH             0x00000020
#define SM_RES_LITE             0x00000040
#define SM_RES_DARK             0x00000080
#define SM_RES_FEAR             0x00000100
#define SM_RES_CONF             0x00000200
#define SM_RES_CHAOS            0x00000400
#define SM_RES_DISEN            0x00000800
#define SM_RES_BLIND            0x00001000
#define SM_RES_NEXUS            0x00002000
#define SM_RES_SOUND            0x00004000
#define SM_RES_SHARD            0x00008000
#define SM_OPP_ACID             0x00010000
#define SM_OPP_ELEC             0x00020000
#define SM_OPP_FIRE             0x00040000
#define SM_OPP_COLD             0x00080000
#define SM_OPP_POIS             0x00100000
#define SM_OPP_XXX1             0x00200000 /* (unused) */
#define SM_CLONED               0x00400000 /* XXX Cloned */
#define SM_PET                  0x00800000 /* XXX Pet */
#define SM_IMM_ACID             0x01000000
#define SM_IMM_ELEC             0x02000000
#define SM_IMM_FIRE             0x04000000
#define SM_IMM_COLD             0x08000000
//#define SM_FRIENDLY             0x10000000 /* XXX Friendly */
#define SM_IMM_REFLECT          0x20000000
#define SM_IMM_FREE             0x40000000
#define SM_IMM_MANA             0x80000000


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP		 0x01	// Allow equiped items
#define USE_INVEN		 0x02	// Allow inven items
#define USE_FLOOR		 0x04	// Allow floor items
#define USE_EQUIP_SLOT	 0x08	// Choice equip slot
#define USE_FORCE        0x10   // Choice force

/*
 * Bit flags for the "notice" variable
 */
/* xxx (many) */


/*
 * Bit flags for the "update" variable
 */
//creature update
#define CRU_BONUS        0x00000001L     // Calculate bonuses
#define CRU_TORCH        0x00000002L     // Calculate torch radius
// xxx (many)
#define CRU_HP           0x00000010L     // Calculate chp and mhp
#define CRU_MANA         0x00000020L     // Calculate csp and msp
#define CRU_SPELLS       0x00000040L     // Calculate spells

#define CRU_COMBINE      0x00001000L     // Combine the pack
#define CRU_REORDER      0x00002000L     // Reorder the pack
#define CRN_AUTODESTROY  0x00004000L     // Auto-destroy marked item


//world update
#define PU_UN_VIEW      0x00010000L     // Forget view
#define PU_UN_LITE      0x00020000L     // Forget lite
/* xxx (many) */
#define PU_VIEW         0x00100000L     // Update view
#define PU_LITE         0x00200000L     // Update lite
#define PU_SPECIES_LITE     0x00400000L     // Creature illumination
#define PU_DELAY_VIS    0x00800000L     // Mega-Hack -- Delayed visual update
#define PU_MONSTERS     0x01000000L     // Update creatures
#define PU_DISTANCE     0x02000000L     // Update distances
/* xxx */
#define PU_FLOW         0x10000000L     // Update flow
/* xxx (many) */


/*
 * Bit flags for the "redraw" variable
 */
#define PR_MISC         0x00000001L     /* Display Race/Class */
#define PR_TITLE        0x00000002L     /* Display Title */
#define PR_LEV          0x00000004L     /* Display Level */
#define PR_EXP          0x00000008L     /* Display Experience */
#define PR_STATS        0x00000010L     /* Display Stats */
#define PR_ARMOR        0x00000020L     /* Display Armor */
#define PR_HP           0x00000040L     /* Display Hitpoints */
#define PR_MANA         0x00000080L     /* Display Mana */
#define PR_GOLD         0x00000100L     /* Display Gold */
#define PR_DEPTH        0x00000200L     /* Display Depth */
#define PR_EQUIPPY      0x00000400L     /* Display equippy chars */
#define PR_HEALTH       0x00000800L     /* Display Health Bar */
#define PR_CUT          0x00001000L     /* Display Extra (Cut) */
#define PR_STUN         0x00002000L     /* Display Extra (Stun) */
#define PR_HUNGER       0x00004000L     /* Display Extra (Hunger) */
#define PR_STATUS       0x00008000L     /* Display Status Bar */
#define PR_XXX0         0x00010000L     /* (unused) */
#define PR_UHEALTH      0x00020000L     /* Display Uma Health Bar */
#define PR_XXX1         0x00040000L     /* (unused) */
#define PR_XXX2         0x00080000L     /* (unused) */
#define PR_STATE        0x00100000L     /* Display Extra (State) */
#define PR_SPEED        0x00200000L     /* Display Extra (Speed) */
#define PR_STUDY        0x00400000L     /* Display Extra (Study) */
#define PR_IMITATION    0x00800000L     /* Display Extra (Imitation) */
#define PR_EXTRA        0x01000000L     /* Display Extra Info */
#define PR_BASIC        0x02000000L     /* Display Basic Info */
#define PR_MAP          0x04000000L     /* Display Map */
#define PR_WIPE         0x08000000L     /* Hack -- Total Redraw */
/* xxx */
/* xxx */
/* xxx */
/* xxx */

/*
 * Bit flags for the "window" variable (etc)
 */
#define PW_INVEN        0x00000001L     /* Display inven/equip */
#define PW_EQUIP        0x00000002L     /* Display equip/inven */
#define PW_SPELL        0x00000004L     /* Display spell list */
#define PW_PLAYER       0x00000008L     /* Display character */
/* xxx */
/* xxx */
#define PW_MESSAGE      0x00000040L     /* Display messages */
#define PW_OVERHEAD     0x00000080L     /* Display overhead view */
#define PW_MONSTER      0x00000100L     /* Display creature recall */
#define PW_OBJECT       0x00000200L     /* Display object recall */
#define PW_DUNGEON      0x00000400L     /* Display dungeon view */
#define PW_SNAPSHOT     0x00000800L     /* Display snap-shot */
/* xxx */
/* xxx */
#define PW_BORG_1       0x00004000L     /* Display borg messages */
#define PW_BORG_2       0x00008000L     /* Display borg status */

/*
 * Bit flags for the place_creature_???() (etc)
 */
#define PM_ALLOW_SLEEP    0x00000001
#define PM_ALLOW_GROUP    0x00000002
#define PM_FORCE_FRIENDLY 0x00000004
#define PM_FORCE_PET      0x00000008
#define PM_NO_KAGE        0x00000010
#define PM_NO_PET         0x00000020
#define PM_ALLOW_UNIQUE   0x00000040
#define PM_IGNORE_TERRAIN 0x00000080
#define PM_HASTE          0x00000100
#define PM_KAGE           0x00000200
#define PM_MULTIPLY       0x00000400


/* Bit flags for creature_desc() */
#define MD_OBJECTIVE       0x00000001 /* Objective (or Reflexive) */
#define MD_POSSESSIVE      0x00000002 /* Possessive (or Reflexive) */
#define MD_INDEF_HIDDEN    0x00000004 /* Use indefinites for hidden creatures ("something") */
#define MD_INDEF_VISIBLE   0x00000008 /* Use indefinites for visible creatures ("a kobold") */
#define MD_PRON_HIDDEN     0x00000010 /* Pronominalize hidden creatures */
#define MD_PRON_VISIBLE    0x00000020 /* Pronominalize visible creatures */
#define MD_ASSUME_HIDDEN   0x00000040 /* Assume the creature is hidden */
#define MD_ASSUME_VISIBLE  0x00000080 /* Assume the creature is visible */
#define MD_TRUE_NAME       0x00000100 /* Chameleon's true name */
#define MD_IGNORE_HALLU    0x00000200 /* Ignore hallucination, and penetrate shape change */
#define MD_IGNORE_EGO_DESC 0x00000400 /* Add ego description */


/*
 * Bit flags for object_desc()
 */
#define OD_NAME_ONLY        0x00000001  /* Omit values, pval, inscription */
#define OD_NAME_AND_ENCHANT 0x00000002  /* Omit pval, inscription */
#define OD_OMIT_INSCRIPTION 0x00000004  /* Omit inscription */
#define OD_OMIT_PREFIX      0x00000008  /* Omit numeric prefix */
#define OD_NO_PLURAL        0x00000010  /* Don't use plural */
#define OD_STORE            0x00000020  /* Assume to be aware and known */
#define OD_NO_FLAVOR        0x00000040  /* Allow to hidden flavor */
#define OD_FORCE_FLAVOR     0x00000080  /* Get un-shuffled flavor name */


/*
 * Bit flags for the "special_attack" variable. -LM-
 *
 * Note:  The elemental and poison attacks should be managed using the 
 * function "set_ele_attack", in spell2.c.  This provides for timeouts and
 * prevents the player from getting more than one at a time.
 */
#define ATTACK_CONFUSE		0x00000001
#define ATTACK_XXX1		0x00000002
#define ATTACK_XXX2		0x00000004
#define ATTACK_XXX3	        0x00000008
#define ATTACK_ACID		0x00000010
#define ATTACK_ELEC		0x00000020
#define ATTACK_FIRE		0x00000040
#define ATTACK_COLD		0x00000080
#define ATTACK_POIS		0x00000100
#define ATTACK_HOLY		0x00000200
#define ATTACK_SUIKEN		0x00000400


#define DEFENSE_ACID		0x00000001
#define DEFENSE_ELEC		0x00000002
#define DEFENSE_FIRE		0x00000004
#define DEFENSE_COLD		0x00000008
#define DEFENSE_POIS		0x00000010
#define KAMAE_GENBU             0x00000020
#define KAMAE_BYAKKO            0x00000040
#define KAMAE_SEIRYU            0x00000080
#define KAMAE_SUZAKU            0x00000100
#define KATA_IAI                0x00000200
#define KATA_FUUJIN             0x00000400
#define KATA_KOUKIJIN           0x00000800
#define KATA_MUSOU              0x00001000
#define NINJA_KAWARIMI          0x00002000
#define NINJA_S_STEALTH         0x00004000

#define MAX_KAMAE 4
#define KAMAE_MASK (KAMAE_GENBU | KAMAE_BYAKKO | KAMAE_SEIRYU | KAMAE_SUZAKU)

#define MAX_KATA 4
#define KATA_MASK (KATA_IAI | KATA_FUUJIN | KATA_KOUKIJIN | KATA_MUSOU)


/* Empty hand status */
#define EMPTY_HAND_NONE 0x0000 /* Both hands are used */
#define EMPTY_HAND_LARM 0x0001 /* Left hand is empty */
#define EMPTY_HAND_RARM 0x0002 /* Right hand is empty */

/*** General index values ***/



/*
 * Some things which induce learning
 */
#define DRS_ACID         1
#define DRS_ELEC         2
#define DRS_FIRE         3
#define DRS_COLD         4
#define DRS_POIS         5
#define DRS_NETH         6
#define DRS_LITE         7
#define DRS_DARK         8
#define DRS_FEAR         9
#define DRS_CONF        10
#define DRS_CHAOS       11
#define DRS_DISEN       12
#define DRS_BLIND       13
#define DRS_NEXUS       14
#define DRS_SOUND       15
#define DRS_SHARD       16
#define DRS_FREE        30
#define DRS_MANA        31
#define DRS_REFLECT     32



#define DAMAGE_FORCE    1
#define DAMAGE_GENO     2
#define DAMAGE_LOSELIFE 3
#define DAMAGE_ATTACK   4
#define DAMAGE_NOESCAPE 5
#define DAMAGE_USELIFE  6

/*
 * Hack -- special "xtra" object powers
 */

/* Sustain one stat */
#define EGO_XTRA_SUSTAIN        1

/* High resist */
#define EGO_XTRA_POWER          2

/* Special ability */
#define EGO_XTRA_ABILITY        3

/*** Object flag values ***/


/*
 * Chest trap flags (see "tables.c")
 */
#define CHEST_LOSE_STR          0x0001
#define CHEST_LOSE_CON          0x0002
#define CHEST_POISON            0x0004
#define CHEST_PARALYZE          0x0008
#define CHEST_EXPLODE           0x0010
#define CHEST_SUMMON            0x0020
#define CHEST_SCATTER           0x0040
#define CHEST_E_SUMMON          0x0080
#define CHEST_BIRD_STORM        0x0100
#define CHEST_H_SUMMON          0x0200
#define CHEST_RUNES_OF_EVIL     0x0400
#define CHEST_ALARM             0x0800


/*
 * Special Object Flags
 */
#define IDENT_SENSE     0x01    /* Item has been "sensed" */
#define IDENT_FIXED     0x02    /* Item has been "haggled" */
#define IDENT_EMPTY     0x04    /* Item charges are known */
#define IDENT_KNOWN     0x08    /* Item abilities are known */
#define IDENT_STORE     0x10    /* Item is storebought !!!! */
#define IDENT_MENTAL    0x20    /* Item information is known */
#define IDENT_CURSED    0x40    /* Item is temporarily cursed */
#define IDENT_BROKEN    0x80    /* Item is permanently worthless */


/* 
 * How object is marked (flags in object_type.mark)
 * OM_FOUND --- original boolean flag
 * OM_NOMSG --- temporary flag to suppress messages which were
 *              already printed in autopick_pickup_items().
 */
#define OM_FOUND        0x01    /* original boolean flag */
#define OM_NOMSG        0x02    /* temporary flag to suppress messages */
#define OM_NO_QUERY     0x04    /* Query for auto-pick was already answered as 'No' */
#define OM_AUTODESTROY  0x08    /* Destroy later to avoid illegal inventry shift */
#define OM_TOUCHED      0x10    /* Object was touched by player */


/*
 * Special Creature Flags (all temporary)
 */
#define MFLAG_VIEW      0x01    /* Creature is in line of sight */
#define MFLAG_TEMP      0x02    /* Creature is marked for project_hack() */
#define MFLAG_XXX2      0x04    /* (unused) */
#define MFLAG_XXX3      0x08    /* (unused) */
#define MFLAG_BORN      0x10    /* Creature is still being born */
#define MFLAG_NICE      0x20    /* Creature is still being nice */

#define MFLAG2_KAGE      0x01    /* Creature is kage */
#define MFLAG2_NOPET     0x02    /* Cannot make creature pet */
#define MFLAG2_NOGENO    0x04    /* Cannot genocide */
#define MFLAG2_CHAMELEON 0x08    /* Creature is chameleon */
#define MFLAG2_NOFLOW    0x10    /* Creature is in no_flow_by_smell mode */
#define MFLAG2_SHOW      0x20    /* Creature is recently memorized */
#define MFLAG2_MARK      0x40    /* Creature is currently memorized */


#define TR_FLAG_SIZE		((TR_FLAG_MAX - 1) / 32) + 1
#define TRAIT_FLAG_MAX		((MAX_TRAITS - 1) / 32) + 1
#define AUTHORITY_FLAG_MAX		((MAX_AUTHORITY - 1) / 32) + 1

#define TRG_INSTA_ART           0x00000001L     /* Item must be an artifact */
#define TRG_QUESTITEM           0x00000002L     /* quest level item -KMW- */
#define TRG_XTRA_POWER          0x00000004L     /* Extra power */
#define TRG_ONE_SUSTAIN         0x00000008L     /* One sustain */
#define TRG_XTRA_RES_OR_POWER   0x00000010L     /* Extra resistance or power */
#define TRG_XTRA_H_RES          0x00000020L     /* Extra high resistance */
#define TRG_XTRA_E_RES          0x00000040L     /* Extra element resistance */
#define TRG_XTRA_L_RES          0x00000080L     /* Extra lordly resistance */
#define TRG_XTRA_D_RES          0x00000100L     /* Extra dragon resistance */
#define TRG_XTRA_RES            0x00000200L     /* Extra resistance */
#define TRG_CURSED              0x00000400L     /* Item is Cursed */
#define TRG_HEAVY_CURSE         0x00000800L     /* Item is Heavily Cursed */
#define TRG_DIVINE_CURSE        0x00001000L     /* Item is Perma Cursed */
#define TRG_RANDOM_CURSE0       0x00002000L     /* Item is Random Cursed */
#define TRG_RANDOM_CURSE1       0x00004000L     /* Item is Random Cursed */
#define TRG_RANDOM_CURSE2       0x00008000L     /* Item is Random Cursed */
#define TRG_NO_LIMIT_LITE       0x00010000L     /* Item is no limit light */


#define MAX_CURSE 17

#define TRC_CURSED              0x00000001L
#define TRC_HEAVY_CURSE         0x00000002L
#define TRC_DIVINE_CURSE        0x00000004L
#define TRC_XXX1                0x00000008L
#define TRC_TY_CURSE            0x00000010L
#define TRC_AGGRAVATE           0x00000020L
#define TRC_DRAIN_EXP           0x00000040L
#define TRC_SLOW_REGEN          0x00000080L
#define TRC_ADD_L_CURSE         0x00000100L
#define TRC_ADD_H_CURSE         0x00000200L
#define TRC_CALL_ANIMAL         0x00000400L
#define TRC_CALL_DEMON          0x00000800L
#define TRC_CALL_DRAGON         0x00001000L
#define TRC_COWARDICE           0x00002000L
#define TRC_TELEPORT            0x00004000L
#define TRC_LOW_MELEE           0x00008000L
#define TRC_LOW_AC              0x00010000L
#define TRC_LOW_MAGIC           0x00020000L
#define TRC_FAST_DIGEST         0x00040000L
#define TRC_DRAIN_HP            0x00080000L
#define TRC_DRAIN_MANA          0x00100000L

#define TRC_TELEPORT_SELF       0x00000001L
#define TRC_CHAINSWORD          0x00000002L

#define TRC_SPECIAL_MASK (TRC_TY_CURSE) 
//TRC_AGGRAVATE)

//TRC_AGGRAVATE |
#define TRC_HEAVY_MASK (TRC_TY_CURSE | TRC_DRAIN_EXP | TRC_ADD_H_CURSE | TRC_CALL_DEMON | TRC_CALL_DRAGON | TRC_TELEPORT)

#define TRC_P_FLAG_MASK  \
	(TRC_TELEPORT_SELF | TRC_CHAINSWORD | \
	 TRC_TY_CURSE | TRC_DRAIN_EXP | TRC_ADD_L_CURSE | TRC_ADD_H_CURSE | \
	 TRC_CALL_ANIMAL | TRC_CALL_DEMON | TRC_CALL_DRAGON | TRC_COWARDICE | \
	 TRC_TELEPORT | TRC_DRAIN_HP | TRC_DRAIN_MANA)



/*
 * Bit flags for apply_magic() (etc)
 */
#define AM_NO_FIXED_ART 0x00000001 /* Don't allow roll for fixed artifacts */
#define AM_GOOD         0x00000002 /* Generate good items */
#define AM_GREAT        0x00000004 /* Generate great items */
#define AM_SPECIAL      0x00000008 /* Generate artifacts (for debug mode only) */
#define AM_CURSED       0x00000010 /* Generate cursed/worthless items */
#define AM_UNCURSED     0x00000020 /* Generate valued items */

/*
 * Item rank for apply_magic() (etc)
 */
#define ITEM_RANK_SPECIAL  3
#define ITEM_RANK_GREAT    2
#define ITEM_RANK_GOOD     1
#define ITEM_RANK_NORMAL   0
#define ITEM_RANK_CURSED   -1
#define ITEM_RANK_BROKEN   -2


/*
 *  Bit flags for get_obj_num()
 */
#define GON_ARMS     0x00000001  /* Select in hand weapons */
#define GON_BODY     0x00000002  /* Select in body equipment */
#define GON_HEAD     0x00000004  /* Select in head equipment */
#define GON_FEET     0x00000008  /* Select in feets equipment */
#define GON_LITE     0x00000010
#define GON_OUTER    0x00000020
#define GON_HANDS    0x00000040
#define GON_RING     0x00000080
#define GON_AMULET   0x00000100
#define GON_UNCURSED 0x00000200  /* Select in uncursed equipment */
#define GON_ITEM     0x00000400  /* Normal Items  */


/*** Creature flag values (hard-coded) ***/

#define CREATURE_FLAGS_MAX 19

/*
 * Hack -- effective elemental and poison immunity mask
 */
#define MR1_SINKA 0x01

//TODO
#define is_friendly(player_ptr, A) FALSE

#define is_friendly_idx(IDX) (bool)((IDX) > 0 && is_friendly(playet_ptr, &creature_list[(IDX)]))

#define is_pet(B, A) (bool)(((A)->smart & SM_PET) ? TRUE : FALSE)
#define is_hostile(A) (bool)((is_friendly(player_ptr, A) || is_pet(player_ptr, A)) ? FALSE : TRUE)

// Hack -- Determine creature race appearance index is same as race index
#define is_original_ap(A) (bool)(((A)->ap_species_idx == (A)->species_idx) ? TRUE : FALSE)
#define is_original_ap_and_seen(WHO, A) (bool)((A)->ml && !(WHO)->image && ((A)->ap_species_idx == (A)->species_idx))

/*
 * Is the creature seen by the player?
 */
// TODO Check using
#define is_seen(B, A) \
	((bool)((A)->ml && (!ignore_unview || GET_FLOOR_PTR(B)->gamble_arena_mode || \
	 (creature_can_see_bold((B), (A)->fy, (A)->fx) && projectable(GET_FLOOR_PTR(B), (B)->fy, (B)->fx, (A)->fy, (A)->fx)))))

// Does creature exist here?
#define EXIST_CREATURE(FLOOR, Y, X) ((FLOOR)->cave[(Y)][(X)].creature_idx != 0)



/*** Option Definitions ***/


#define OPT_PAGE_INPUT          1
#define OPT_PAGE_MAPSCREEN      2
#define OPT_PAGE_TEXT           3
#define OPT_PAGE_GAMEPLAY       4
#define OPT_PAGE_DISTURBANCE    5
#define OPT_PAGE_BIRTH          6
#define OPT_PAGE_AUTODESTROY    7
#define OPT_PAGE_PLAYRECORD    10
#define OPT_PAGE_AUTOSAVE      20

#define OPT_PAGE_JAPANESE_ONLY 99


/*** Macro Definitions ***/


/*
 * Hack -- The main "screen"
 */
#define term_screen     (angband_term[0])


/*
 * Determine if a given inventory item is "aware"
 */
#define object_is_aware(T) \
    (object_kind_info[(T)->k_idx].aware)

/*
 * Determine if a given inventory item is "tried"
 */
#define object_is_tried(T) \
    (object_kind_info[(T)->k_idx].tried)


/*
 * Determine if a given inventory item is "known"
 * Test One -- Check for special "known" tag
 * Test Two -- Check for "Easy Know" + "Aware"
 */
#define object_is_known(T) \
    (((T)->ident & (IDENT_KNOWN)) || \
     (object_kind_info[(T)->k_idx].easy_know && object_kind_info[(T)->k_idx].aware))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	((object_kind_info[(T)->k_idx].flavor) ? \
	 (object_kind_info[object_kind_info[(T)->k_idx].flavor].x_attr) : \
	 ((!(T)->k_idx || ((T)->tval != TV_CORPSE) || ((T)->sval != SV_CORPSE) || \
	   (object_kind_info[(T)->k_idx].x_attr != TERM_DARK)) ? \
	  (object_kind_info[(T)->k_idx].x_attr) : (species_info[(T)->pval].x_attr)))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	((object_kind_info[(T)->k_idx].flavor) ? \
	 (object_kind_info[object_kind_info[(T)->k_idx].flavor].x_char) : \
	 (object_kind_info[(T)->k_idx].x_char))


/*
 * Artifacts use the "name1" field
 */
#define object_is_fixed_artifact(T) \
	((T)->name1 ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define object_is_ego(T) \
	((T)->name2 ? TRUE : FALSE)


/*
 * Broken items.
 */
#define object_is_broken(T) \
	((T)->ident & (IDENT_BROKEN))

/*
 * Cursed items.
 */
#define object_is_cursed(T) \
	((T)->curse_flags)


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((int)((G) % 256U))


// Determines if a map location is fully inside the outer walls
#define in_bounds(FLOOR, Y, X) \
   (((Y) > 0) && ((X) > 0) && ((Y) < (FLOOR)->height - 1) && ((X) < (FLOOR)->width - 1))

// Determines if a map location is on or inside the outer walls
#define in_bounds2(FLOOR, Y, X) \
   (((Y) >= 0) && ((X) >= 0) && ((Y) < (FLOOR)->height) && ((X) < (FLOOR)->width))

// Determines if a map location is on or inside the outer walls (unsigned version)
#define in_bounds2u(FLOOR, Y, X) \
   (((Y) < (FLOOR)->height) && ((X) < (FLOOR)->width))

// Determines if a map location is currently "on screen" -RAK-
// Note that "panel_contains(Y,X)" always implies "in_bounds2(FLOOR, Y, X)".
#define panel_contains(Y,X) \
  (((Y) >= panel_row_min) && ((Y) <= panel_row_max) && \
   ((X) >= panel_col_min) && ((X) <= panel_col_max))


/*
 * Determine if player is on this grid
 */
#define creature_bold(C, Y, X) \
	(((Y) == (C)->fy) && ((X) == (C)->fx))


/*
 * Grid based version of "creature_bold()"
 */
#define player_grid(C) \
	((C) == &floor_list[player_ptr->floor_id].cave[player_ptr->fy][player_ptr->fx])


#define cave_have_flag_bold(FLOOR, Y, X, INDEX) \
	(have_flag(feature_info[(FLOOR)->cave[(Y)][(X)].feat].flags, (INDEX)))


#define cave_have_flag_grid(C,INDEX) \
	(have_flag(feature_info[(C)->feat].flags, (INDEX)))


/*
 * Determine if a "feature" supports "los"
 */
#define feat_supports_los(F) \
	(have_flag(feature_info[(F)].flags, FF_LOS))


/*
 * Determine if a "legal" grid supports "los"
 */
#define cave_los_bold(FLOOR, Y, X) \
	(feat_supports_los((FLOOR)->cave[(Y)][(X)].feat))

#define cave_los_grid(C) \
	(feat_supports_los((C)->feat))


/*
 * Determine if a "legal" grid is a "clean" floor grid
 * Determine if terrain-change spells are allowed in a grid.
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid object terrains
 * Line 3 -- forbid normal objects
 */
#define cave_clean_bold(FLOOR,Y,X) \
	(cave_have_flag_bold((FLOOR), (Y), (X), FF_FLOOR) && \
	 !((FLOOR)->cave[Y][X].info & CAVE_OBJECT) && \
	  ((FLOOR)->cave[Y][X].object_idx == 0))


/*
 * Determine if an object can be dropped on a "legal" grid
 *
 * Line 1 -- forbid non-drops
 * Line 2 -- forbid object terrains
 */
#define cave_drop_bold(FLOOR, Y, X) \
	(cave_have_flag_bold((FLOOR), (Y), (X), FF_DROP) && \
	 !((FLOOR)->cave[Y][X].info & CAVE_OBJECT))


/*
 * Determine if a "legal" grid is an "empty" floor grid
 * Determine if creatures are allowed to move into a grid
 *
 * Line 1 -- forbid non-placement grids
 * Line 2 -- forbid normal creatures
 * Line 3 -- forbid the player
 */
#define cave_empty_bold(FLOOR, Y, X) \
	(cave_have_flag_bold((FLOOR), (Y), (X), FF_PLACE) && \
	 !((FLOOR)->cave[Y][X].creature_idx) && \
	 !creature_bold(player_ptr, Y,X))


/*
 * Determine if a "legal" grid is an "empty" floor grid
 * Determine if creature generation is allowed in a grid
 *
 * Line 1 -- forbid non-empty grids
 * Line 2 -- forbid trees while dungeon generation
 */
#define cave_empty_bold2(FLOOR, Y, X) \
	(cave_empty_bold((FLOOR), Y, X) && \
	 (floor_ptr->generated || !cave_have_flag_bold((FLOOR), (Y), (X), FF_TREE)))


/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-clean gird
 * Line 2 -- forbid creatures
 * Line 3 -- forbid the player
 */
#define cave_naked_bold(FLOOR, Y, X) \
	(cave_clean_bold(FLOOR, Y, X) && \
	 !((FLOOR)->cave[Y][X].creature_idx) && \
	 !creature_bold(player_ptr, Y, X))


/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1 -- permanent flag
 */
#define cave_perma_bold(FLOOR, Y, X) \
	(cave_have_flag_bold((FLOOR), (Y), (X), FF_PERMANENT))


/*
 * Grid based version of "cave_empty_bold()"
 */
#define cave_empty_grid(C) \
	(cave_have_flag_grid((C), FF_PLACE) && \
	 !((C)->creature_idx) && !player_grid(C))


/*
 * Grid based version of "cave_perma_bold()"
 */
#define cave_perma_grid(C) \
	(cave_have_flag_grid((C), FF_PERMANENT))


#define pattern_tile(FLOOR, Y, X) (cave_have_flag_bold((FLOOR), (Y), (X), FF_PATTERN))

/*
 * Does the grid stop disintegration?
 */
#define cave_stop_disintegration(FLOOR, Y, X) \
	(!cave_have_flag_bold((FLOOR), (Y), (X), FF_PROJECT) && \
	 (!cave_have_flag_bold((FLOOR), (Y), (X), FF_HURT_DISI) || \
	  cave_have_flag_bold((FLOOR), (Y), (X), FF_PERMANENT)))


/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_grid(C) \
    (((C)->info & (CAVE_VIEW)) != 0)

/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y, X) \
    (((GET_FLOOR_PTR(player_ptr)->cave[Y][X].info & (CAVE_VIEW)) != 0) || floor_ptr->gamble_arena_mode)


/*
 * Determine if a "feature" is "permanent wall"
 */
#define permanent_wall(F) \
	(have_flag((F)->flags, FF_WALL) && \
	 have_flag((F)->flags, FF_PERMANENT))

/*
 * Get feature mimic from feature_info[] (applying "mimic" field)
 */
#define get_feat_mimic(C) \
	(feature_info[(C)->mimic ? (C)->mimic : (C)->feat].mimic)

#define update_playtime() \
{\
	u32b tmp;\
	tmp = (u32b)time(NULL);\
	playtime += (tmp - start_time);\
	start_time = tmp;\
}

/*
 * Hack -- Prepare to use the "Secure" routines
 */
#if defined(SET_UID) && defined(SECURE)
extern int PlayerUID;
# define getuid() PlayerUID
# define geteuid() PlayerUID
#endif



/*** Color constants ***/


/*
 * Angband "attributes" (with symbols, and base (R,G,B) codes)
 *
 * The "(R,G,B)" codes are given in "fourths" of the "maximal" value,
 * and should "gamma corrected" on most (non-Macintosh) machines.
 */
#define TERM_DARK                0  /* 'd' */   /* 0,0,0 */
#define TERM_WHITE               1  /* 'w' */   /* 4,4,4 */
#define TERM_SLATE               2  /* 's' */   /* 2,2,2 */
#define TERM_ORANGE              3  /* 'o' */   /* 4,2,0 */
#define TERM_RED                 4  /* 'r' */   /* 3,0,0 */
#define TERM_GREEN               5  /* 'g' */   /* 0,2,1 */
#define TERM_BLUE                6  /* 'b' */   /* 0,0,4 */
#define TERM_UMBER               7  /* 'u' */   /* 2,1,0 */
#define TERM_L_DARK              8  /* 'D' */   /* 1,1,1 */
#define TERM_L_WHITE             9  /* 'W' */   /* 3,3,3 */
#define TERM_VIOLET             10  /* 'v' */   /* 4,0,4 */
#define TERM_YELLOW             11  /* 'y' */   /* 4,4,0 */
#define TERM_L_RED              12  /* 'R' */   /* 4,0,0 */
#define TERM_L_GREEN            13  /* 'G' */   /* 0,4,0 */
#define TERM_L_BLUE             14  /* 'B' */   /* 0,4,4 */
#define TERM_L_UMBER            15  /* 'U' */   /* 3,2,1 */


/*
 * Not using graphical tiles for this feature?
 */
#define is_ascii_graphics(A) (!((A) & 0x80))


/*** Sound constants ***/



/*
 * Mega-Hack -- maximum known sounds
 */

#define KARMA_CALC_PLUS 0


// Initialization flags
#define INIT_SHOW_TEXT          0x01
#define INIT_ASSIGN             0x02
#define INIT_CREATE_DUNGEON     0x04
#define INIT_ONLY_FEATURES      0x08
#define INIT_ONLY_BUILDINGS     0x10

/*
 * Quest flags
 */
#define QUEST_FLAG_SILENT  0x01 /* no messages fro completion */
#define QUEST_FLAG_PRESET  0x02 /* quest is outside the main dungeon */
#define QUEST_FLAG_ONCE    0x04 /* quest is marked finished after leaving */


// Available graphic modes
enum GRAPHICS_MODE
{
	GRAPHICS_NONE,
	GRAPHICS_ORIGINAL,
	GRAPHICS_ADAM_BOLT,
	GRAPHICS_DESKULL
};

/*
 * Generate Creature Flag
 */
#define GC_PLAYER  0x01
#define GC_AUTO    0x02
#define GC_AVERAGE 0x04



#ifdef JP
#define JVERB_AND 1
#define JVERB_TO  2
#define JVERB_OR  3
#endif

/*
 * Modes for the tokenizer
 */
#define TOKENIZE_CHECKQUOTE 0x01  /* Special handling of single quotes */


#define NO_TOWN 255

#define RECORD_NAMED_PET_NAME        0
#define RECORD_NAMED_PET_UNNAME      1
#define RECORD_NAMED_PET_DISMISS     2
#define RECORD_NAMED_PET_DEATH       3
#define RECORD_NAMED_PET_MOVED       4
#define RECORD_NAMED_PET_LOST_SIGHT  5
#define RECORD_NAMED_PET_DESTROY     6
#define RECORD_NAMED_PET_EARTHQUAKE  7
#define RECORD_NAMED_PET_GENOCIDE    8
#define RECORD_NAMED_PET_WIZ_ZAP     9
#define RECORD_NAMED_PET_TELE_LEVEL  10
#define RECORD_NAMED_PET_BLAST       11
#define RECORD_NAMED_PET_HEAL_LEPER  12
#define RECORD_NAMED_PET_COMPACT     13
#define RECORD_NAMED_PET_LOSE_PARENT 14

#define MAX_MANE 16
#define MAX_MONSPELLS 96

#define MONSPELL_TYPE_BOLT 1
#define MONSPELL_TYPE_BALL 2
#define MONSPELL_TYPE_BREATH 3
#define MONSPELL_TYPE_SUMMON 4
#define MONSPELL_TYPE_OTHER 5

#define EATER_EXT 36
#define EATER_CHARGE 0x10000L
#define EATER_ROD_CHARGE 0x10L

#define DETECT_RAD_DEFAULT 30
#define DETECT_RAD_MAP     30
#define DETECT_RAD_ALL     255

#define SPECIES_STIGMATIC_ONE 0
#define SPECIES_BEGGAR        12
#define SPECIES_LEPER         13
#define SPECIES_BLACK_MARKET  14
#define SPECIES_GHB           39
#define SPECIES_NOV_PRIEST    45
#define SPECIES_GRIP          53
#define SPECIES_WOLF          54
#define SPECIES_FANG          55
#define SPECIES_LOUSE         69
#define SPECIES_PIRANHA       70
#define SPECIES_COPPER_COINS  85
#define SPECIES_NOV_PALADIN   97
#define SPECIES_GREEN_G       100
#define SPECIES_NOV_PRIEST_G  109
#define SPECIES_SILVER_COINS  117
#define SPECIES_D_ELF         122
#define SPECIES_MANES         128
#define SPECIES_LOST_SOUL     133
#define SPECIES_ROBIN_HOOD    138
#define SPECIES_NOV_PALADIN_G 147
#define SPECIES_PHANTOM_W     152
#define SPECIES_WOUNDED_BEAR  159
#define SPECIES_D_ELF_MAGE    178
#define SPECIES_D_ELF_WARRIOR 182
#define SPECIES_BLUE_HORROR   189
#define SPECIES_GOLD_COINS    195
#define SPECIES_VORPAL_BUNNY  205
#define SPECIES_PRIEST        225
#define SPECIES_D_ELF_PRIEST  226
#define SPECIES_TIGER         230
#define SPECIES_MITHRIL_COINS 239
#define SPECIES_DRUID         241
#define SPECIES_PINK_HORROR   242
#define SPECIES_HILL_GIANT    255
#define SPECIES_WERERAT       270
#define SPECIES_UMBER_HULK    283
#define SPECIES_ORC_CAPTAIN   285
#define SPECIES_BERSERKER     293
#define SPECIES_SHAGRAT       314
#define SPECIES_GORBAG        315
#define SPECIES_STONE_GIANT   321
#define SPECIES_D_ELF_LORD    348
#define SPECIES_FIRE_VOR      354
#define SPECIES_WATER_VOR     355
#define SPECIES_ARCH_VILE     357
#define SPECIES_COLD_VOR      358
#define SPECIES_ENERGY_VOR    359
#define SPECIES_IRON_GOLEM    367
#define SPECIES_JADE_MONK     370
#define SPECIES_D_ELF_WARLOCK 375
#define SPECIES_HAGEN         383
#define SPECIES_MENELDOR      384
#define SPECIES_PHANTOM_B     385
#define SPECIES_C_CRAWLER     395
#define SPECIES_XICLOTLAN     396
#define SPECIES_D_ELF_DRUID   400
#define SPECIES_TROLL_PRIEST  403
#define SPECIES_GWAIHIR       410
#define SPECIES_ANGEL         417
#define SPECIES_ADAMANT_COINS 423
#define SPECIES_SPIRIT_NAGA   436
#define SPECIES_GACHAPIN      441
#define SPECIES_BASILISK      453
#define SPECIES_ARCHANGEL     456
#define SPECIES_MITHRIL_GOLEM 464
#define SPECIES_THORONDOR     468
#define SPECIES_SHADOW_DRAKE  471
#define SPECIES_GHOST         477
#define SPECIES_OGRE_SHAMAN   479
#define SPECIES_NINJA         485
#define SPECIES_BICLOPS       490
#define SPECIES_IVORY_MONK    492
#define SPECIES_LOG_MASTER    498
#define SPECIES_ETHER_DRAKE   504
#define SPECIES_GOEMON        505
#define SPECIES_CHERUB        511
#define SPECIES_WATER_ELEM    512
#define SPECIES_JURT          517
#define SPECIES_LICH          518
#define SPECIES_BLOODLETTER   523
#define SPECIES_HALFLING_S    539
#define SPECIES_GRAV_HOUND    540
#define SPECIES_REVENANT      555
#define SPECIES_RAAL          557
#define SPECIES_COLOSSUS      558
#define SPECIES_NIGHTBLADE    564
#define SPECIES_ELDER_THING   569
#define SPECIES_LEGORAS       575
#define SPECIES_CRYPT_THING   577
#define SPECIES_NEXUS_VOR     587
#define SPECIES_PLASMA_VOR    588
#define SPECIES_TIME_VOR      589
#define SPECIES_M_MH_DRAGON   593
#define SPECIES_MANDOR        598
#define SPECIES_SHIM_VOR      600
#define SPECIES_SERAPH        605
#define SPECIES_KAVLAX        616
#define SPECIES_ETTIN         621
#define SPECIES_VAMPIRE_LORD  623
#define SPECIES_JUBJUB        640
#define SPECIES_CLUB_DEMON    648
#define SPECIES_D_ELF_SORC    657
#define SPECIES_MASTER_LICH   658
#define SPECIES_RINALDO       660
#define SPECIES_ARCHON        661
#define SPECIES_UND_BEHOLDER  664
#define SPECIES_IRON_LICH     666
#define SPECIES_JACK_SHADOWS  670
#define SPECIES_LLOIGOR       682
#define SPECIES_DREADMASTER   690
#define SPECIES_DAWN          693
#define SPECIES_NAZGUL        696
#define SPECIES_SMAUG         697
#define SPECIES_STORMBRINGER  698
#define SPECIES_ULTRA_PALADIN 699
#define SPECIES_G_TITAN       702
#define SPECIES_FAFNER        712
#define SPECIES_G_BALROG      720
#define SPECIES_TIME_HOUND    725
#define SPECIES_PLASMA_HOUND  726
#define SPECIES_SANTACLAUS    733
#define SPECIES_LORD_CHAOS    737
#define SPECIES_TINDALOS      739
#define SPECIES_DEMILICH      742
#define SPECIES_NIGHTCRAWLER  744
#define SPECIES_CHAOS_VOR     751
#define SPECIES_AETHER_VOR    752
#define SPECIES_FUNDIN        762
#define SPECIES_DWORKIN       763
#define SPECIES_NIGHTWALKER   768
#define SPECIES_RAPHAEL       769
#define SPECIES_SARUMAN       771
#define SPECIES_GANDALF       772
#define SPECIES_BRAND         773
#define SPECIES_SHADOWLORD    774
#define SPECIES_ARCHLICH      776
#define SPECIES_CHAOS_HOUND   779
#define SPECIES_ULT_BEHOLDER  781
#define SPECIES_SHAMBLER      786
#define SPECIES_BLEYS         789
#define SPECIES_FIONA         791
#define SPECIES_SKY_DRAKE     793
#define SPECIES_JULIAN        794
#define SPECIES_BLACK_REAVER  798
#define SPECIES_CAINE         799
#define SPECIES_GERARD        807
#define SPECIES_UNGOLIANT     808
#define SPECIES_ATLACH_NACHA  809
#define SPECIES_Y_GOLONAC     810
#define SPECIES_AETHER_HOUND  811
#define SPECIES_WARP_DEMON    812
#define SPECIES_ERIC          813
#define SPECIES_UNMAKER       815
#define SPECIES_CYBER         816
#define SPECIES_KLING         819
#define SPECIES_CORWIN        820
#define SPECIES_ANGMAR        825
#define SPECIES_CANTORAS      830
#define SPECIES_GODZILLA      832
#define SPECIES_SPAWN_CTH     836
#define SPECIES_SURTUR        837
#define SPECIES_TARRASQUE     838
#define SPECIES_LUNGORTHIN    839
#define SPECIES_CYBER_KING    843
#define SPECIES_WYRM_POWER    847
#define SPECIES_NODENS        849
#define SPECIES_JORMUNGAND    854
#define SPECIES_DESTROYER     855
#define SPECIES_GOTHMOG       856
#define SPECIES_G_CTHULHU     857
#define SPECIES_SAURON        858
#define SPECIES_UNICORN_ORD   859
#define SPECIES_OBERON        860
#define SPECIES_MORGOTH       861
#define SPECIES_SERPENT       862
#define SPECIES_ONE_RING      864
#define SPECIES_CAAWS         866
#define SPECIES_CULVERIN      867
#define SPECIES_EBONY_MONK    870
#define SPECIES_HAGURE        871
#define SPECIES_OROCHI        872
#define SPECIES_ECHIZEN       873
#define SPECIES_SPECT_WYRM    874
#define SPECIES_DIO           878
#define SPECIES_OHMU          879
#define SPECIES_WONG          880
#define SPECIES_ZOMBI_SERPENT 883
#define SPECIES_D_ELF_SHADE   886
#define SPECIES_MANA_HOUND    887
#define SPECIES_VENOM_WYRM    890
#define SPECIES_BAZOOKER      896
#define SPECIES_SHARD_VOR     897
#define SPECIES_MASTER_MYS    916
#define SPECIES_G_MASTER_MYS  917
#define SPECIES_IE            921
#define SPECIES_TSUCHINOKO    926
#define SPECIES_GCWADL        929
#define SPECIES_LOCKE_CLONE   930
#define SPECIES_CALDARM       931
#define SPECIES_BANORLUPART   932
#define SPECIES_BANOR         933
#define SPECIES_LUPART        934
#define SPECIES_KENSHIROU     936
#define SPECIES_W_KNIGHT      938
#define SPECIES_PLANETAR      942
#define SPECIES_SOLAR         943
#define SPECIES_BIKETAL       945
#define SPECIES_RICH          948
#define SPECIES_IKETA         949
#define SPECIES_B_DEATH_SWORD 953
#define SPECIES_YASE_HORSE    955
#define SPECIES_HORSE         956
#define SPECIES_BOTEI         963
#define SPECIES_KAGE          964
#define SPECIES_JAIAN         967
#define SPECIES_BELD          973
#define SPECIES_THAT_BAT      975
#define SPECIES_SHUTEN        979
#define SPECIES_FENGHUANG     988
#define SPECIES_KIRIN         989
#define SPECIES_BAHAMUT       1000
#define SPECIES_SUKE          1001
#define SPECIES_KAKU          1002
#define SPECIES_GHOST_Q       1003
#define SPECIES_PIP           1004
#define SPECIES_A_GOLD        1010
#define SPECIES_A_SILVER      1011
#define SPECIES_ROLENTO       1013
#define SPECIES_RAOU          1018
#define SPECIES_SHURYUUDAN    1023
#define SPECIES_WAHHA         1031
#define SPECIES_DEBBY         1032
#define SPECIES_KNI_TEMPLAR   1037
#define SPECIES_PALADIN       1038
#define SPECIES_CHAMELEON     1040
#define SPECIES_CHAMELEON_K   1041
#define SPECIES_TOPAZ_MONK    1047
#define SPECIES_RICHARD_STOLENMAN 1054
#define SPECIES_NOBORTA       1059
#define SPECIES_MORI_TROLL    1060
#define SPECIES_BARNEY        1061
#define SPECIES_GROO          1062
#define SPECIES_LOUSY         1063
#define SPECIES_JIZOTAKO      1065
#define SPECIES_TANUKI        1067
#define SPECIES_ILUVATAR  1090
#define SPECIES_LION_HEART    1097
#define SPECIES_ARIOCH        1142



#define MONEGO_NONE       0
#define MONEGO_NORMAL     65535

#define MONEGO_LESSER_FROM   1
#define MONEGO_LESSER_TO     6
#define MONEGO_VARIABLE_SIZE 13

/* Maximum "Nazguls" number */
#define MAX_NAZGUL_NUM 5

#define DO_AUTOPICK       0x01
#define DO_AUTODESTROY    0x02
#define DO_DISPLAY        0x04
#define DONT_AUTOPICK     0x08
#define ITEM_DISPLAY      0x10
#define DO_QUERY_AUTOPICK 0x20


#define MAGIC_GLOVE_REDUCE_MANA 0x0001
#define MAGIC_FAIL_5PERCENT     0x0002
#define MAGIC_GAIN_EXP          0x0004

#define VIRTUE_LARGE 1
#define VIRTUE_SMALL 2

#define SPELL_DD_S 27
#define SPELL_DD_T 13
#define SPELL_SW   22
#define SPELL_KABE 20

#define KNOW_STAT   0x01
#define KNOW_HPRATE 0x02

/*
 * Music songs
 */
#define MUSIC_NONE              0
#define MUSIC_SLOW              1
#define MUSIC_BLESS             2
#define MUSIC_STUN              3
#define MUSIC_L_LIFE            4
#define MUSIC_FEAR              5
#define MUSIC_HERO              6
#define MUSIC_MIND              7
#define MUSIC_STEALTH           8
#define MUSIC_ID                9
#define MUSIC_CONF              10
#define MUSIC_SOUND             11
#define MUSIC_CHARM             12
#define MUSIC_WALL              13
#define MUSIC_RESIST            14
#define MUSIC_SPEED             15
#define MUSIC_DISPEL            16
#define MUSIC_SARUMAN           17
#define MUSIC_QUAKE             18
#define MUSIC_STASIS            19
#define MUSIC_SHERO             20
#define MUSIC_H_LIFE            21
#define MUSIC_INVULN            22
#define MUSIC_PSI               23

#define MUSIC_DETECT            101

#define HISSATSU_NONE   0
#define HISSATSU_2      1
#define HISSATSU_3WAY   2
#define HISSATSU_SUTEMI 3
#define HISSATSU_FIRE   4
#define HISSATSU_COLD   5
#define HISSATSU_POISON 6
#define HISSATSU_ELEC   7
#define HISSATSU_NYUSIN 8
#define HISSATSU_FUKI   9
#define HISSATSU_MAJIN  10
#define HISSATSU_BOOMER 11
#define HISSATSU_DRAIN  12
#define HISSATSU_SEKIRYUKA 13
#define HISSATSU_OTAKEBI 14
#define HISSATSU_SHOUGE 15
#define HISSATSU_CONF   16
#define HISSATSU_ISSEN  17
#define HISSATSU_KYUSHO 18
#define HISSATSU_KONSIN 19
#define HISSATSU_HYAKU  20
#define HISSATSU_MINEUCHI 21
#define HISSATSU_MEKIKI 22
#define HISSATSU_ZANMA  23
#define HISSATSU_UNDEAD 24
#define HISSATSU_HAGAN  25
#define HISSATSU_QUAKE  26
#define HISSATSU_COUNTER 27
#define HISSATSU_HARAI  28
#define HISSATSU_3DAN   29
#define HISSATSU_100NIN 30

#define HISSATSU_IAI    100

/*
 *  Special essence id for Weapon smith
 */
#define MIN_SPECIAL_ESSENCE 200

#define ESSENCE_ATTACK        (MIN_SPECIAL_ESSENCE + 0)
#define ESSENCE_AC            (MIN_SPECIAL_ESSENCE + 1)
#define ESSENCE_TMP_RES_ACID  (MIN_SPECIAL_ESSENCE + 2)
#define ESSENCE_TMP_RES_ELEC  (MIN_SPECIAL_ESSENCE + 3)
#define ESSENCE_TMP_RES_FIRE  (MIN_SPECIAL_ESSENCE + 4)
#define ESSENCE_TMP_RES_COLD  (MIN_SPECIAL_ESSENCE + 5)
#define ESSENCE_SH_FIRE       (MIN_SPECIAL_ESSENCE + 6)
#define ESSENCE_SH_ELEC       (MIN_SPECIAL_ESSENCE + 7)
#define ESSENCE_SH_COLD       (MIN_SPECIAL_ESSENCE + 8)
#define ESSENCE_RESISTANCE    (MIN_SPECIAL_ESSENCE + 9)
#define ESSENCE_SUSTAIN       (MIN_SPECIAL_ESSENCE + 10)
#define ESSENCE_SLAY_GLOVE    (MIN_SPECIAL_ESSENCE + 11)


#define DUNGEON_MODE_NONE       0
#define DUNGEON_MODE_AND        1
#define DUNGEON_MODE_NAND       2
#define DUNGEON_MODE_OR         3
#define DUNGEON_MODE_NOR        4

/*** Dungeon type flags -- DG ***/
#define DF1_WINNER              0x00000001L
#define DF1_MAZE                0x00000002L
#define DF1_SMALLEST            0x00000004L
#define DF1_BEGINNER            0x00000008L
#define DF1_BIG                 0x00000010L
#define DF1_NO_DOORS            0x00000020L
#define DF1_WATER_RIVER         0x00000040L
#define DF1_LAVA_RIVER          0x00000080L
#define DF1_CURTAIN             0x00000100L
#define DF1_GLASS_DOOR          0x00000200L
#define DF1_CAVE                0x00000400L
#define DF1_CAVERN              0x00000800L
#define DF1_POISON_RIVER        0x00001000L
#define DF1_ACID_RIVER          0x00002000L
#define DF1_XXX14               0x00004000L
#define DF1_XXX15               0x00008000L
#define DF1_FORGET              0x00010000L
#define DF1_LAKE_WATER          0x00020000L
#define DF1_LAKE_LAVA           0x00040000L
#define DF1_LAKE_RUBBLE         0x00080000L
#define DF1_LAKE_TREE           0x00100000L
#define DF1_NO_VAULT            0x00200000L
#define DF1_ARENA               0x00400000L
#define DF1_DESTROY             0x00800000L
#define DF1_GLASS_ROOM          0x01000000L
#define DF1_NO_CAVE             0x02000000L
#define DF1_NO_MAGIC            0x04000000L
#define DF1_NO_MELEE            0x08000000L
#define DF1_CHAMELEON           0x10000000L
#define DF1_DARKNESS            0x20000000L
#define DF1_LAKE_POISON         0x40000000L
#define DF1_LAKE_ACID           0x80000000L

#define DF1_LAKE_MASK (DF1_LAKE_WATER | DF1_LAKE_LAVA | DF1_LAKE_RUBBLE | DF1_LAKE_TREE)


#define DUNGEON_FEAT_PROB_NUM 3


/*
 * Flags for change floor mode
 */
#define CFM_UP        	 0x0001  /* Move up */

#define CFM_LONG_STAIRS  0x0004  /* Randomly occurred long stairs/shaft */
#define CFM_XXX  	     0x0008  /* XXX */
#define CFM_SHAFT     	 0x0010  /* Shaft */
#define CFM_RAND_PLACE   0x0020  /* Arrive at random grid */
#define CFM_RAND_CONNECT 0x0040  /* Connect with random stairs */
#define CFM_SAVE_FLOORS  0x0080  /* Save floors */
#define CFM_NO_RETURN    0x0100  /* Flee from random quest etc... */
#define CFM_FIRST_FLOOR  0x0200  /* Create exit from the dungeon */


/*
 * Flags for save/load temporal saved floor file
 */
#define SLF_SECOND     	 0x0001  /* Called from another save/load function */
#define SLF_NO_KILL      0x0002  /* Don't kill temporal files */


// Flags for wr_object()/rd_object()
// First
#define SAVEFLAG_OBJECT_KIND_PVAL            0x00000001
#define SAVEFLAG_OBJECT_KIND_DISCOUNT        0x00000002
#define SAVEFLAG_OBJECT_KIND_NUMBER          0x00000004
#define SAVEFLAG_OBJECT_KIND_NAME1           0x00000008
#define SAVEFLAG_OBJECT_KIND_NAME2           0x00000010
#define SAVEFLAG_OBJECT_KIND_TIMEOUT         0x00000020
#define SAVEFLAG_OBJECT_KIND_TO_H            0x00000040
#define SAVEFLAG_OBJECT_KIND_TO_D            0x00000080
#define SAVEFLAG_OBJECT_KIND_TO_A            0x00000100
#define SAVEFLAG_OBJECT_KIND_AC              0x00000200
#define SAVEFLAG_OBJECT_KIND_DD              0x00000400
#define SAVEFLAG_OBJECT_KIND_DS              0x00000800
#define SAVEFLAG_OBJECT_KIND_IDENT           0x00001000
#define SAVEFLAG_OBJECT_KIND_MARKED          0x00002000
#define SAVEFLAG_OBJECT_KIND_ART_FLAGS0      0x00004000
#define SAVEFLAG_OBJECT_KIND_ART_FLAGS1      0x00008000
#define SAVEFLAG_OBJECT_KIND_ART_FLAGS2      0x00010000
#define SAVEFLAG_OBJECT_KIND_ART_FLAGS3      0x00020000
#define SAVEFLAG_OBJECT_KIND_CURSE_FLAGS     0x00040000
#define SAVEFLAG_OBJECT_KIND_HELD_M_IDX      0x00080000
#define SAVEFLAG_OBJECT_KIND_XTRA1           0x00100000
#define SAVEFLAG_OBJECT_KIND_XTRA2           0x00200000
#define SAVEFLAG_OBJECT_KIND_XTRA3           0x00400000
#define SAVEFLAG_OBJECT_KIND_XTRA4           0x00800000
#define SAVEFLAG_OBJECT_KIND_XTRA5           0x01000000
#define SAVEFLAG_OBJECT_KIND_FEELING         0x02000000
#define SAVEFLAG_OBJECT_KIND_INSCRIPTION     0x04000000
#define SAVEFLAG_OBJECT_KIND_ART_NAME        0x08000000
#define SAVEFLAG_OBJECT_KIND_CREATER         0x10000000
#define SAVEFLAG_OBJECT_KIND_VOLUME          0x20000000
#define SAVEFLAG_OBJECT_KIND_EQUIPPED_SLOT_TYPE 0x40000000
#define SAVEFLAG_OBJECT_KIND_EQUIPPED_SLOT_NUM  0x80000000

// Second
#define SAVEFLAG_OBJECT_KIND_TO_E            0x00000001
#define SAVEFLAG_OBJECT_KIND_EV              0x00000002
#define SAVEFLAG_OBJECT_KIND_SIZE_UPPER      0x00000004
#define SAVEFLAG_OBJECT_KIND_SIZE_LOWER      0x00000008
#define SAVEFLAG_OBJECT_KIND_TO_SIZE         0x00000010

#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS0    0x00000020
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS1    0x00000040
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS2    0x00000090
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS3    0x00000100
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS4    0x00000200

#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS5    0x00000400
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS6    0x00000800
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS7    0x00001000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS8    0x00002000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS9    0x00004000

#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS10   0x00008000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS11   0x00010000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS12   0x00020000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS13   0x00040000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS14   0x00080000

#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS15   0x00100000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS16   0x00200000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS17   0x00400000
#define SAVEFLAG_OBJECT_KIND_TRAIT_FLAGS18   0x00800000


/*
 * Flags for wr_creature()/rd_creature()
 */
#define SAVE_SPECIES_AP_SPECIES_IDX     0x00000001
#define SAVE_SPECIES_SUB_ALIGN    0x00000002
#define SAVE_SPECIES_CSLEEP       0x00000004
#define SAVE_SPECIES_FAST         0x00000008
#define SAVE_SPECIES_SLOW         0x00000010
#define SAVE_SPECIES_STUNNED      0x00000020
#define SAVE_SPECIES_CONFUSED     0x00000040
#define SAVE_SPECIES_MONFEAR      0x00000080
#define SAVE_SPECIES_TARGET_Y     0x00000100
#define SAVE_SPECIES_TARGET_X     0x00000200
#define SAVE_SPECIES_INVULNER     0x00000400
#define SAVE_SPECIES_SMART        0x00000800
#define SAVE_SPECIES_EXP          0x00001000
#define SAVE_SPECIES_MFLAG2       0x00002000
#define SAVE_SPECIES_NICKNAME     0x00004000
#define SAVE_SPECIES_PARENT       0x00008000

/* Sub-alignment flags for neutral creatures */
#define SUB_ALIGN_NEUTRAL 0x0000
#define SUB_ALIGN_EVIL    0x0001
#define SUB_ALIGN_GOOD    0x0002
#define SUB_ALIGN_LAW     0x0004
#define SUB_ALIGN_CHAOS   0x0008
#define SUB_ALIGN_BALANCE 0x0010


/*
 * Max numbers of macro trigger names
 */
#define MAX_MACRO_MOD 12
#define MAX_MACRO_TRIG 200

/* Max size of screen dump buffer */
#define SCREEN_BUF_SIZE 65536


/*
 * Special key code used for inkey_special()
 */
#define SKEY_MOD_MASK     0x0f00
#define SKEY_MOD_SHIFT    0x0100
#define SKEY_MOD_CONTROL  0x0200

#define SKEY_MASK         0xf000
#define SKEY_DOWN   	  0xf001
#define SKEY_LEFT   	  0xf002
#define SKEY_RIGHT  	  0xf003
#define SKEY_UP     	  0xf004
#define SKEY_PGUP   	  0xf005
#define SKEY_PGDOWN 	  0xf006
#define SKEY_TOP    	  0xf007
#define SKEY_BOTTOM 	  0xf008

/*
 * Bit flags for move_creature()
 */
#define MPE_STAYING			0x00000001
#define MPE_FORGET_FLOW		0x00000002
#define MPE_HANDLE_STUFF	0x00000004
#define MPE_ENERGY_USE		0x00000008
#define MPE_DONT_PICKUP		0x00000010
#define MPE_DO_PICKUP		0x00000020
#define MPE_BREAK_TRAP		0x00000040
#define MPE_DONT_SWAP_MON	0x00000080
#define MPE_NO_ENTER	0x00000100

#define MTIMED_CSLEEP   0 /* Creature is sleeping */
#define MTIMED_FAST     1 /* Creature is temporarily fast */
#define MTIMED_SLOW     2 /* Creature is temporarily slow */
#define MTIMED_STUNNED  3 /* Creature is stunned */
#define MTIMED_CONFUSED 4 /* Creature is confused */
#define MTIMED_MONFEAR  5 /* Creature is afraid */
#define MTIMED_INVULNER 6 /* Creature is temporarily invulnerable */

#define MAX_MTIMED      7


/*
 * Bit flags for screen_object()
 */
#define SCROBJ_FAKE_OBJECT  0x00000001
#define SCROBJ_FORCE_DETAIL 0x00000002

/*
 * For travel command (auto run)
 */
#define TRAVEL


#define CONCENT_RADAR_THRESHOLD 2
#define CONCENT_TELE_THRESHOLD  5

#define INFO_TYPE_RACE            1000
#define INFO_TYPE_ALIGNMENT       1001
#define INFO_TYPE_RESIST          1002

#define INFO_TYPE_RESIST_FIRE_RATE     1100
#define INFO_TYPE_RESIST_COLD_RATE     1101
#define INFO_TYPE_RESIST_ELEC_RATE     1102
#define INFO_TYPE_RESIST_ACID_RATE     1103
#define INFO_TYPE_RESIST_POIS_RATE     1104

// obeserve creature flags
#define CREATURE_OBS_RACE			100
#define CREATURE_OBS_ALIGNMENT		110

#define NO_FLAGS 0 // no flags

#define CAMP_PLAYER   0
#define CAMP_DUNGEON  1


// use add_outfit() and under fuctions.
#define ADD_OUTFIT_EQUIP                0x00000001
#define ADD_OUTFIT_MULTIPLE_FENCING     0x00000002

#define SHOW_ITEM_RIGHT_SET 0x00000001
#define SHOW_ITEM_INVENTORY 0x00000002
#define SHOW_ITEM_EQUIPMENT 0x00000004
#define SHOW_ITEM_FULL      0x00000008

#define GET_SE_NO_FRAME    0x00000001
#define GET_SE_AUTO_WIDTH  0x00000002
#define GET_SE_AUTO_HEIGHT 0x00000004
#define GET_SE_LEFT        0x00000008
#define GET_SE_CENTER      0x00000010
#define GET_SE_RIGHT       0x00000020
#define GET_SE_TOP         0x00000040
#define GET_SE_MIDDLE      0x00000080
#define GET_SE_BOTTOM      0x00000100

#define BIRTH_SELECT_RETURN	-2
#define BIRTH_SELECT_QUIT	-3

