//
// OggǂރNX
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifdef _DEBUG
	#pragma comment(lib, "ogg/ogg_static_d.lib")
	#pragma comment(lib, "ogg/vorbis_static_d.lib")
	#pragma comment(lib, "ogg/vorbisfile_static_d.lib")
#else
	#pragma comment(lib, "ogg/ogg_static.lib")
	#pragma comment(lib, "ogg/vorbis_static.lib")
	#pragma comment(lib, "ogg/vorbisfile_static.lib")
#endif

#include "AudioFileOgg.h"

#include <memory.h>
#include <assert.h>

AudioFileOgg::AudioFileOgg()
{
	m_fp = NULL;
	oggOpened = false;
}

AudioFileOgg::~AudioFileOgg()
{
	Term();
}

void AudioFileOgg::Term(void)
{
	if(m_fp!=NULL)
		fclose(m_fp);

	if(oggOpened)
	{
		ov_clear(&m_oggFile);
		oggOpened = false;
	}
}

bool AudioFileOgg::Open(const char* fileName)
{
	Term();

	m_fp = fopen(fileName, "rb");
	if(m_fp==NULL)
		return false;

	// J[
	if(ov_open(m_fp, &m_oggFile, NULL, 0) != 0)
	{
		Term();
		return false;
	}

	oggOpened = true;

	// [
	const vorbis_info* info = ov_info(&m_oggFile, -1);
	if(info==NULL)
	{
		// H
		assert(0);
		Term();
		return false;
	}

	m_rate = info->rate;
	m_bits = 16; // decodeɎwł邯ǂ܂16bit
	m_channel = info->channels;

	// V[NłȂXg[Ă̂
	// V[NłȂPCMfR[h̒킩Ȃ̂ō
	seekable = ov_seekable(&m_oggFile) != 0;
	if(!seekable)
	{
		// ށ[
		assert(0); // ̂ŃfobO͋Ăق
		Term();
		return false;
	}

	// Tv擾
	m_length = (unsigned int)ov_pcm_total(&m_oggFile, -1);

	// oCgɕϊ
	m_length *= ((m_bits/8) * m_channel);

	if(!Seek(0))
	{
		// N邩H
		assert(0);
		Term();
		return false;
	}

	return true;
}

bool AudioFileOgg::Seek(unsigned int bytes)
{
	if(seekable)
	{
		ogg_int64_t samples = bytes / (m_bits/8) / m_channel;

		if(ov_pcm_seek(&m_oggFile, samples) != 0)
		{
			// [
			assert(0);
			return false;
		}
			
		m_readOffset = bytes;
		return true;
	}
	else
	{
		// Ă݂͂ǁA
		// V[NłȂPCMfR[h̒킩Ȃ̂Ōǂɂ͗Ȃ
		if(bytes!=0)
			return false;

		// ĊJȂbytes==0փV[N
		ov_clear(&m_oggFile);

		if(fseek(m_fp, 0, SEEK_SET) != 0)
			return false;

		// J[
		if(ov_open(m_fp, &m_oggFile, NULL, 0) != 0)
		{
			Term();
			return false;
		}

		m_readOffset = 0;
		return true;
	}
}

unsigned int AudioFileOgg::Read(unsigned char* buf, unsigned int bytes)
{
	unsigned int read = 0;

	while(read < bytes)
	{
		long ret = ov_read(&m_oggFile, (char*)buf+read, bytes-read, 0, 2, 1, NULL);
		if(ret==0)
		{
			// EOF
			break;
		}
		else if(ret > 0)
		{
			// 
			read += ret;
		}
		else
		{
			// Ȃ񂩃G[
			break;
		}
	}

	return read;
}
