//
// WavǂރNX
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "AudioFileWav.h"

#include <memory.h>
#include <assert.h>

// wb_\\̂p
typedef unsigned short WORD;
typedef unsigned long DWORD;

typedef struct tagRiffHeader
{
	char tagRIFF[4];
	DWORD fileSize;
	char tagWAVE[4];
} RIFFHEADER;

typedef struct tagChunkHeader
{
	char tag[4];
	DWORD size;
} CHUNKHEADER;

// PlatformSDK/Include/MMReg.hp
typedef struct tagPCMWAVEFORMAT
{ 
    WORD  wFormatTag;
    WORD  nChannels;
    DWORD nSamplesPerSec;
    DWORD nAvgBytesPerSec;
    WORD  nBlockAlign;
    WORD  wBitsPerSample;
} PCMWAVEFORMAT; 

/* flags for wFormatTag field of WAVEFORMAT */
static const int WAVE_FORMAT_PCM = 1;

AudioFileWav::AudioFileWav()
{
	m_fp = NULL;
	m_PCMOffset = 0;
}

AudioFileWav::~AudioFileWav()
{
	if(m_fp!=NULL)
		fclose(m_fp);
}

bool AudioFileWav::ReadHeader(void)
{
	unsigned int waveFileSize;

	// WAVt@C̃TCY𒲂ׂ
	{
		fseek(m_fp, 0, SEEK_END);
		waveFileSize = ftell(m_fp);
		fseek(m_fp, 0, SEEK_SET);
	}

	int readOffset = 0; // ݂̃t@C̓ǂݍ݈ʒu

	// RIFFwb_ǂݍ݁`FbN
	{
		RIFFHEADER riffHeader;

		// RIFFwb_̓ǂݍ
		size_t readBytes = fread(&riffHeader, 1, sizeof(riffHeader), m_fp);
		if(readBytes < sizeof(riffHeader))
			return false;

		readOffset += sizeof(riffHeader);

		// RIFF^Õ`FbN
		if(memcmp(riffHeader.tagRIFF, "RIFF", 4) != 0)
			return false;

		// ꂽt@CłĐł悤ɁA
		// t@CTCYǂ͂ă`FbNȂ

		// WAVE^Õ`FbN
		if(memcmp(riffHeader.tagWAVE, "WAVE", 4) != 0)
			return false;
	}

	// `Nɂǂ
	bool fmtRead = false, dataPosRead = false; // tH[}bg/f[^ʒuǂݍ񂾂true

	while(1)
	{
		// `Nwb_̓ǂݍ
		CHUNKHEADER chunkHeader;
		size_t readBytes = fread(&chunkHeader, 1, sizeof(chunkHeader), m_fp);
		if(readBytes < sizeof(chunkHeader))
		{
			// ȏ`NȂ
			break;
		}

		readOffset += sizeof(chunkHeader);

		// `N̎ނ𒲂ׁAΉ
		if(memcmp(&chunkHeader.tag, "fmt ", 4) == 0)
		{
			// fmt`N
			PCMWAVEFORMAT waveFmt;

			// `NTCYPCMWAVEFORMAT\̂̃TCY菬΃G[
			if(chunkHeader.size < sizeof(waveFmt))
				return false;

			// PCMWAVEFORMAT\̓ǂݍ
			fread(&waveFmt, sizeof(waveFmt), 1, m_fp);
			
			if(waveFmt.wFormatTag != WAVE_FORMAT_PCM)
				return false; // WPCMtH[}bgł͂Ȃ

			// ǂݍ߂̂Œlۑ
			m_rate    = waveFmt.nSamplesPerSec;
			m_bits    = waveFmt.wBitsPerSample;
			m_channel = waveFmt.nChannels;

			fmtRead = true; // tH[}bgǂݍ݊
		}
		else if(memcmp(&chunkHeader.tag, "data", 4) == 0)
		{
			// data`N
			
			// t@C擪f[^܂ł̃ItZbgƁAf[^TCYۑ
			m_PCMOffset = readOffset;
			m_length = chunkHeader.size;
			
			// ꂽt@CłꉞĐł悤ɁA
			// f[^TCYt@C𒴂Ȃ悤Ɋۂ
			if(m_PCMOffset+m_length > waveFileSize)
				m_length = waveFileSize-m_PCMOffset;

			dataPosRead = true; // f[^ʒuǂݍ݊
		}

		// ̃`N̓܂ŃV[N
		if(readOffset+chunkHeader.size >= waveFileSize)
			break; // t@C𒴂遁ȏ`NȂAꂽt@CȂ̂ŏI

		fseek(m_fp, readOffset+chunkHeader.size, SEEK_SET);
		readOffset += chunkHeader.size;
	}

	if(fmtRead && dataPosRead)
	{
		// tH[}bgf[^ʒuǂݏI

		// t@CĂƂAwb_Ƃ̂߂
		// BlockAlignɊۂ
		m_length &= ~(m_bits/8 * m_channel - 1); // align 4Ȃ(~3)&, align 1Ȃ(~0)&
		return true;
	}
	else
	{
		// tH[}bgƃf[^ʒûǂȂ
		return false;
	}
}

bool AudioFileWav::Open(const char* fileName)
{
	if(m_fp!=NULL)
		fclose(m_fp);

	m_fp = fopen(fileName, "rb");
	if(m_fp==NULL)
		return false;

	if(!ReadHeader())
	{
		// mp3ƂOpen悤ƂƂ悭N
		fclose(m_fp);
		m_fp = NULL;
		return false;
	}

	if(!Seek(0))
	{
		// N邩H
		assert(0);
		fclose(m_fp);
		m_fp = NULL;
		return false;
	}

	return true;
}

bool AudioFileWav::Seek(unsigned int bytes)
{
	// BlockAlign`FbN
	unsigned int alignedBytes = bytes & ~(m_bits/8 * m_channel - 1);
	if(alignedBytes != bytes)
	{
		assert(0);
		return false;
	}

	// f[^̖𒴂Ȃ悤
	if(m_length <= bytes)
		return false;

	if(fseek(m_fp, m_PCMOffset+bytes, SEEK_SET) != 0)
	{
		assert(0);
		return false;
	}

	m_readOffset = bytes;
	return true;
}

unsigned int AudioFileWav::Read(unsigned char* buf, unsigned int bytes)
{
	// BlockAlign`FbN
	unsigned int alignedBytes = bytes & ~(m_bits/8 * m_channel - 1);
	if(alignedBytes != bytes)
	{
		assert(0);
		return 0;
	}

	// f[^̖𒴂Ȃ悤
	unsigned int maxReadSize = m_length - m_readOffset;
	if(maxReadSize < bytes)
	{
		bytes = maxReadSize;
		if(bytes==0)
			return 0;
	}

	unsigned int read = (unsigned int)fread(buf, 1, bytes, m_fp);
	m_readOffset += read;

	return read;
}
