//
// t@CRtBOǂݏNX
// sƂ̌` #key value ȊO̓Rg
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "Config.h"

Config::Config(void)
{
}

Config::~Config(void)
{
}

bool Config::Load(const string& filename)
{
	FILE* fp = fopen(filename.c_str(), "r");
	if(fp==NULL) return false;

	char buf[1024];
	while(fgets(buf, 1024, fp)!=NULL)
	{
		if(buf[0]!='#')
			continue;

		char storeKey[1024];
		storeKey[0] = '\0';
		int value;

		if(sscanf(buf, "#%s %d", storeKey, &value)==2)
		{
			m_cfgMap[storeKey] = value;
		}
	}

	fclose(fp);
	return true;
}

bool Config::Save(const string& filename)
{
	FILE* fp = fopen(filename.c_str(), "w");
	if(fp==NULL) return false;

	fprintf(fp,"-----------------------------------------------------------\n");
	fprintf(fp,"Delight Delight Reduplication̐ݒt@CłB\n");
	fprintf(fp,"e͕ύXȂقłB\n");
	fprintf(fp,"NȂȂꍇ͂̃t@CĂ݂ĂB\n");
	fprintf(fp,"-----------------------------------------------------------\n\n");

	map<string, int>::iterator it;
	for(it=m_cfgMap.begin() ; it!=m_cfgMap.end() ; it++)
	{
		if(fprintf(fp, "#%s %d\n", (*it).first.c_str(), (*it).second) <= 0)
		{
			fclose(fp);
			return false;
		}
	}

	fclose(fp);
	return true;
}

bool Config::Exists(const string& key)
{
	return m_cfgMap.find(key) != m_cfgMap.end();
}

void Config::Set(const string& key, int value)
{
	if(m_cfgMap.find(key)==m_cfgMap.end())
		return;
	else
		m_cfgMap[key] = value;
}

int Config::Get(const string& key)
{
	if(m_cfgMap.find(key)==m_cfgMap.end())
		return 0;
	else
		return m_cfgMap[key];
}

int& Config::operator[](const string& key)
{
	return m_cfgMap[key];
}
