//
//	DDR.h
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __DDR_h__
#define __DDR_h__

#include "stdafx.h"
#include "resource.h"

//#define WIN32_LEAN_AND_MEAN
//#include <windows.h>

// to detect memory leaks
#define _CRTDBG_MAP_ALLOC
#include <stdlib.h>
#include <crtdbg.h>

#include <math.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <assert.h>

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#pragma warning(disable:4786)

#include <vector>
#include <string>
using namespace std;

#include <mmsystem.h>
#pragma comment(lib, "winmm.lib")

#include <imm.h> // IME𖳌ɂ̂Ɏg
#pragma comment(lib, "imm32.lib")

// ONbVnh
#include "CCrashHandler.h"

//#include <MMREG.h>
#include "DirectSound.h"
#include "DirectDraw.h"
#include "DirectPlay.h"
#include "MCI_MIDI.h"

#include "yaneDirectInput.h"
#include "yaneMutex.h"

#include "VKey.h"
#include "consts.h"

// JX^
#include "yaneCDDA.h"
#include "yaneJoyStick.h"
#include "yaneMIDIInput.h"

// b3
// #include "yaneGameTime.h" Ȃ񂩃ANZXᔽ̂CTimerɕύXc
#include "yaneTimer.h"

// #include "yaneElapseTime.h" yaneGameTimeɈˑĂ̂łւc
#include "yaneFPSTimer.h"

#include "yaneMacro.h"
#include "yaneCPUID.h"

#include "KeyConfig.h"

#include "Particle.h"

#include "CScore.h"

#include "CGlobalData.h"
#include "CMusicList.h"

#include "CScene.h"
#include "SelectMusic.h"
#include "CGlobalScene.h"

#include "StringMap.h"
#include "Config.h"

// \̒`
#include "structs.h"

int MAX_OBJ = 10000; // Ƃrealloĉŕϐ
tagObj* obj = NULL;

struct tagJuke		JukeBox[MAX_JUKE];
struct tagResult	result[2];
struct tagscInfo	ScoreInfo;
struct tagpd		pd;
struct tagOpt		opt;
struct tagDebug		debug;

// }N`
#define PAI				3.14159265358979324
#define Deg2Rad(c)		((double)(c)*PAI/180.0)
#define Rad2Deg(c)		((double)(c)*180.0/PAI)

//#define ABS(x)			( (x)<0 ? -(x) : (x) )

#define ms2min(t)		( abs( int(t)/60000 ) )
#define ms2sec(t)		( abs( int(t)/1000 - abs(int(t)/60000)*60 ) )
#define ms2ms(t)		( abs( int(t) % 1000 ) )

//#define randomize()		srand((unsigned)timeGetTime())	// 
//#define random(n)		(rand()%(n))					// 0 ` n-1 ܂ł̗
//#define rndsign()		(rand()%2 ? 1 : -1)				// _Ł{|Ԃ

// xɕύX
#define randomize()		( ::rnd.Randomize() )
#define random(n)		( ::rnd.Get(n) )
#define rndsign()		( ::rnd.Get(2) ? 1 : -1)

#define RANGE(x,l,h)	((x) = ((x)<(l)?(l):(x)>(h)?(h):(x)))
// oOC
#define LOOP(x,a,b)		((x) = ((x)<(a) ? (b)-((a)+(((-(x)-1)%((b)-(a)+1)))) : ((b)<(x) ? (a)+((((x)-(b)-1)%((b)-(a)+1))) : (x))) ) // a-b̊ԂŃ[v(p)

#undef IN
#define IN(x,a,b)		((a)<=(x) && (x)<=(b))

// oOAĂǂoOƋ̂ŎĂ
//#define LOOP(x,a,b)		((x) = ((x)<(a) ? (b)-((a)+(((-(x)-1)%((b)-(a)+1)))) : ((b)<(x) ? (a)+(((x)%((b)-(a)+1))) : (x))) ) // a-b̊ԂŃ[v(p)//-(b)

//#define LOOP(x,a,b)		((x) = ((x)<(a) ? (b)-((a)-(x%((b)-(a)))-1) : ((b)<(x) ? (a)+((x%((b)-(a)))-1) : (x))) ) // a-b̊ԂŃ[v(p)//-(b)
//#define LOOP(x,a,b)		((x) = ((x)<(a) ? (b)-(((x)-(a))%((b)-(a))+1) : (b)<(x) ? (a)+((x)-(a))%((b)-(a))-1 : (x)))
//						musnum = musnum<0 ? iFn-((musnum)%(iFn)+1) : iFn<musnum ? (musnum%iFn)-1 : musnum

//#define LOAD_BMP(n,x)	if(!dd.LoadBMP( (n), x,RGB(0,0,0)) ){ \
//							Notice("%s̓ǂݍ݂Ɏs",x); \
//							return FALSE; \
//						}

#define LOAD_BMP(n,x)	if(!dd.LoadBMP( (n), (x) ) ){ \
							WriteLog("%s̓ǂݍ݂Ɏs",x); \
						}

#define DRAW_DOOR()		{\
							dd.DrawSprite(12,  0,  0);\
							dd.DrawSprite(12,320,  0);\
							dd.DrawSprite(12,  0,240);\
							dd.DrawSprite(12,320,240);\
						}

// BMS,MSDWAV, MIDI, CD~߂
#define STOP_BGM()		for(int ii=101;ii<=355;ii++) ds.Stop(ii); \
						ds.Stop(0); \
						if(pd.bMIDI) \
						{ \
							midi.StopMIDI(); \
							midi.CloseMIDI(); \
						} \
						cd.Stop();

#define SCENE_INIT		if(nCount==0)
#define SCENE_TERM		if(nCount==-1)

//#define D(x) double(x)

//#define SCR_W			640
//#define SCR_H			480


// O[oϐ
char szCfgFile[MAX_PATH]; // RtBOt@CBftHg .\DDR.cfg

char szLstFile[MAX_PATH]; // LbVt@CBftHg .\cache.lst
BOOL g_bCacheDrop = FALSE;

char szAppDir[MAX_PATH];  // DDR.exẽtH_

char szSearchPath[100][MAX_PATH]; // 0̓R}hCp(ɖgp)A1` RtBOǂ񂾂
vector<string> szDropPathArray; // tH_Et@C̃hbvɑΉ

HWND hmainwnd;
BOOL bIsActive = TRUE; // Is App Active?
int  iLoop=0;

char szCDDr[27][4]; // CDhCu^[

//DWORD g_StartTime = 0; // ȃX^[g

DWORD		g_BeforeTime = 0; // 1t[O̎
CTimer*		g_lpPlayTime = NULL; // ݎԃ^C}[ւ̃|C^B̂O[oɒuƂȂANZXᔽ
double g_dPixNow = 0; // ݂̈ʒu PixelP

BOOL		bPaused	= FALSE; // |[YłH
int    g_OBJScanMin = 0; // IuWFŕ`E肷Kv̂̍ŏY AutoPlay()Őݒ

static BOOL bPoorStock[30]; // ꃉCPoorXgbN

BOOL  g_bOUCH = FALSE;
int   g_TimeBase = TIMEBASE;
BOOL  g_bQuit = FALSE; // ItO
BOOL  g_bClub = FALSE; // ClubModeȂTRUE
BOOL  bResetList = FALSE; // ȃZ̃J[\ʒu0ɖ߂tO
int   g_iOptCaller; // IvV𔲂Ƃ̖߂
BOOL  g_bDoorOpen = TRUE; // StageFileƂFALSE
BOOL  g_EventMode = FALSE;

CGlobalScene* lpGlobScene = NULL;

int   g_iJoy; //JoyStick
#define JOY_NONE		0
#define JOY_1PONLY		1
#define JOY_2PONLY		2
#define JOY_TWIN		3

BOOL bDebug =
#ifdef _DEBUG
	true;  // fobO[hł̓fBtHgtrue
#else
	false; // [X[hł̓fBtHgfalse
#endif

int iFolder = 0; // JukeBox̐
int folPos  = 0; // ݑIĂJukeBox

// 32 = 8(pix) 16 = 16 (@TIMEBASE=256)
// 32 = 6(pix) 16 = 12 (@TIMEBASE=192)
// sNZP
double JUDGE_PERFECT;//	 = 2; //   8
double JUDGE_GREAT;//		 = 6;//15
double JUDGE_GOOD;//		 = 14; //   20
double JUDGE_BOO;//		 = 20;// 25
double JUDGE_POOR; // IuWF牓ʉȂPoor
double JUDGE_MISS;//		 = JUDGE_BOO;
double JUDGE_OUCH;//		 = TIMEBASE*2;

double JUDGE_PERFECT_MS;//	 = 2; //   8
double JUDGE_GREAT_MS;//		 = 6;//15
double JUDGE_GOOD_MS;//		 = 14; //   20
double JUDGE_BOO_MS;//		 = 20;// 25
double JUDGE_POOR_MS; // IuWF牓ʉȂPoor
double JUDGE_MISS_MS;//		 = JUDGE_BOO;
double JUDGE_OUCH_MS;//		 = TIMEBASE*2;

/*
enum enValu{
	SS,
	S,
	A,
	B,
	C,
	D,
	F
};*/

// O[oNX
nsDraw			dd;
nsPlay			dp;
//CElapseTime		eltime;
CFPSTimer		eltime;
CWaveControl	ds;
CCDDA			cd;
MCI_MIDI		midi;

CJoyStick		joy1,joy2; // 2T|[g
CMIDIInput		midiIn;
CDirectInput	DIkey;
CVirtualKey		VKey;
CKeyConfig		keycfg;
CGlobalData		gd;
CMusicList		Juke;

CScore score;

CRand rnd;

StringMap Messages; // Q[Wt@Cǂݍݗp
Config Cfg; // IvV̒lێ/Z[u/[h

// ֐vg^Cv(O[o)
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);
LRESULT CALLBACK WindowProc(HWND hwnd, UINT iMessage, WPARAM wParam, LPARAM lParam);

BOOL InitApp(HINSTANCE hInst);
BOOL LoadBMP(int mem);
void DefSprite(void);

int AppMain(void);
int AppMain(const char* szFile);
int InitBMS(const char* szFile);
void QuitGame(HWND hwnd);

// nCount : V[ĂяoJE^
int Title(int nCount);
int GameMain(int nCount);
int Result(int nCount);
int ResultBM(int nCount);

int OptionMode(int nCount);
int Option2(int nCount);
int OptionBM(int nCount);

void OptionDispatch(void);
void SaveConfig(void);
void LoadConfig(void);

int KeyConfigSys(int nCount);
int KeyConfigDDR(int nCount);
int KeyConfigBM(int nCount);

void GetKeyInfo(void);
void ClearKeyInfo(void){
	BYTE temp[256];
	GetKeyboardState(temp);
	for(int i=0;i<256;i++)
	{
		if(i!=VK_SCROLL && i!=VK_CAPITAL && i!=VK_NUMLOCK)
			temp[i]=0;
	}
	SetKeyboardState(temp);
};

void Debug(void);
void InitObj(void);
void InitResult(void);
void Judge(DWORD timeNow);

// DDR
void DrawJudge(void);
void DrawGauge(int x,int y,int value);
void DrawGaugeClub(int x, int y, int value1, int value2);
void DrawFan(void);
void DrawMode(void);

// BM
void DrawBMGauge(int x, int y, int value1, int value2);
void DrawBMGaugeClub(int x, int y, int HP1p, int HP2p, int HP3p, int HP4p);

// ȃZ
void DrawTitle(int x, int y, const char* szTitle, const char* szArtist, const char* szGenre);
void DrawMusicList(int x, int y, int width, int height, const char* szTitle);
// ȃZ̉`
void DrawKeyNote(int level, int iSwing, int width = 0, int color = 0);
void DrawKeyNote(int x, int y, int level, int iSwing, int width = 0, int color = 0);

// JukeBox֘A
BOOL LoadHeader(string path, MUSIC_DATA* lpHeader); // VJukeBoxp

void LoadHeader(HEADER* lpHeader);
BOOL LoadBMSHeader(const char* szFileName, const char* path, char* szErrTxt, BMS* pBMS);

int  LoadCache(HEADER* lpHeader[]);
BOOL SaveCache(HEADER* lpHeader[], int files);

void MakeJukeBox(HEADER* lpHeader[]);

// G[\AOetc
void WriteLog(const char* Format,...);
void Notice(const char* Format,...);
void DispLastError(void);
void GetLastErrorStr(char* str);
void WriteScore(void);
void WriteScoreDB(void);

// 낢
void DrawDigit(int baseNum, int x, int y, char* szTxt, BOOL bDrawZero = FALSE);
void DrawKeyIcon(int x, int y, int vkey, int key);

double SetPixNow(DWORD timeNow);
void SetJudge(int judge, BOOL is2P);
void SetLight(int iCh, int Col);

BOOL LoadMSDData(const char* szFileName, const char* szPath, char* szErrTxt, MSD* pMsd, BOOL bLoadFile = FALSE);
BOOL LoadMSDStep(const char* szFile    , const char* szPath, char* szErrTxt, int mode, MSD* pMsd);
BOOL LoadBMS(const char* szFileName, const char* path, char* szErrTxt, BMS* pBMS, BOOL bReadFiles = TRUE, int dif = SINGLE+BASIC);
void GoBMS(BMS& bms);
BOOL GoMSD(const char* szFile, const char* szPath, char* szErrTxt, MSD& msd, int mode);

void NoteArrange(int objNum);
void NoteArrangeMirror(tagObj& obj);
void NoteArrangeShuffle(tagObj& obj, int (&dLongNoteEndPix)[20], int (&dInvisibleNotePix)[20]);

string AddYen(string path);
void GetPath(char* szPath, const char* szFullPath);
void GetFileName(char* szFile, const char* szFullPath);
string GetFileExtension(const string& fileName);
BOOL IsFolder(const char* szFolder);
int  CheckType(const char* szFileName);

BOOL SetVolume(DWORD dwVol);
int  GetVolume(void);

BOOL ConnectSession(int mode);

void AllocVRAM(int iKB);

void PauseSequence(int param);

void ReAllocOBJ(void);

// ֐vg^Cv(ƋǏIɎg)
BOOL GetMSDMethod(FILE* fp, char* str);
BOOL GetMSDData(FILE* fp,char* str);
BOOL SeekTo(FILE* fp,char cEnd);
int GetStr(FILE* fp, char* Str, char cEnd);
char* strmatch(char* str, char* str2);
void Trim(char* buf, int bytes);

int GetLine(FILE* fp, char* str, int max);
int HexToInt(const char* pStr);
int Hex36ToInt(const char* pStr);
char* SeekToChar(char* pChar);
int compare(const void* arg1, const void* arg2); // IuWF\[gpR[obN
void GetDetailFileErr(const string& fileName, string& messageBuf); // #BMP#WAVǂ߂ȂƂɏڍ׃G[擾

void KeycfgDataAddVersion(void);
void InitReportLog(void);

void DirDiver(const char* DirName, HEADER* lpHeader, int level, int max, int* files);

double CalcBMScore(int pl);

double CalcTempo(int delta, BOOL bMusical);

int CalcObjYDDR(int y);

HRESULT GetShortcutLink(LPCTSTR pszLink, LPSTR pszFilePath, int cchMaxPath, WIN32_FIND_DATA *wfd);

BOOL IsValidScore(void); // ݂̃IvVŁAscore.dbւ̓o^邩

// SSǂݍށBIvVɉăXg[~O̗L؂ւ
// ssNum̒萔consts.h
BOOL LoadSoundSet(int ssNum);

// Bdsւ̈ϏǈꉞyAɂĂ
BOOL UnLoadSoundSet(int ssNum);

// SS炷B[v邩ǂ͊֐Ō
// ssNum̒萔consts.h
BOOL PlaySoundSet(int ssNum);

// Keyconfigp
int   GetKeyPressNum(void);
char* GetKeyName(int key);

// قƂǃ}NH
BOOL IsBM(void) {return(IN(opt.iMode,MD_BM_4,MD_BM_7));};
BOOL IsDDR(void){return(IN(opt.iMode,MD_DDR_4,MD_DDR_6));};

BOOL IsBasic(void)  {return(pd.mode==SINGLE+BASIC   || pd.mode==DOUBLE+BASIC   || pd.mode==COUPLE+BASIC);};
BOOL IsAnother(void){return(pd.mode==SINGLE+ANOTHER || pd.mode==DOUBLE+ANOTHER || pd.mode==COUPLE+ANOTHER);};
BOOL IsManiac(void) {return(pd.mode==SINGLE+MANIAC  || pd.mode==DOUBLE+MANIAC  || pd.mode==COUPLE+MANIAC);};
BOOL IsSingle(void) {return(SINGLE+BASIC<=pd.mode && pd.mode<=SINGLE+MANIAC || opt.bAllow6);};
BOOL IsDouble(void) {return(DOUBLE+BASIC<=pd.mode && pd.mode<=DOUBLE+MANIAC);};
BOOL IsCouple(void) {return(COUPLE+BASIC<=pd.mode && pd.mode<=COUPLE+MANIAC && (!opt.bAllow6||IsBM()));};

BOOL IsBasic(int mode)  {return(mode==SINGLE+BASIC   || mode==DOUBLE+BASIC   || mode==COUPLE+BASIC);};
BOOL IsAnother(int mode){return(mode==SINGLE+ANOTHER || mode==DOUBLE+ANOTHER || mode==COUPLE+ANOTHER);};
BOOL IsManiac(int mode) {return(mode==SINGLE+MANIAC  || mode==DOUBLE+MANIAC  || mode==COUPLE+MANIAC);};
BOOL IsSingle(int mode) {return(SINGLE+BASIC<=mode && mode<=SINGLE+MANIAC);};
BOOL IsDouble(int mode) {return(DOUBLE+BASIC<=mode && mode<=DOUBLE+MANIAC);};
BOOL IsCouple(int mode) {return(COUPLE+BASIC<=mode && mode<=COUPLE+MANIAC);};

BOOL Is1pAutoSc(void){return((opt.iAutoScr==1||opt.iAutoScr==3) && IsBM());};
BOOL Is2pAutoSc(void){return((opt.iAutoScr==2||opt.iAutoScr==3) && IsBM());};

// IuWF̃`lԍn}N
BOOL Is1PNote(int ch){ return IN(ch,11,16)||IN(ch,18,19); };
BOOL Is2PNote(int ch){ return IN(ch,21,26)||IN(ch,28,29); };
BOOL IsVisibleNote(int ch){ return Is1PNote(ch) || Is2PNote(ch); };

BOOL Is1PInvisibleNote(int ch){ return IN(ch,31,36)||IN(ch,38,39); };
BOOL Is2PInvisibleNote(int ch){ return IN(ch,41,46)||IN(ch,48,49); };
BOOL IsInvisibleNote(int ch){ return Is1PInvisibleNote(ch) || Is2PInvisibleNote(ch); };

BOOL Is1PLongNote(int ch){ return IN(ch,51,56)||IN(ch,58,59); };
BOOL Is2PLongNote(int ch){ return IN(ch,61,66)||IN(ch,68,69); };
BOOL IsLongNote(int ch){ return Is1PLongNote(ch) || Is2PLongNote(ch); };

BOOL IsNote(int ch)
{
	return Is1PNote(ch) || Is2PNote(ch) || Is1PInvisibleNote(ch) || Is2PInvisibleNote(ch) ||
		   IsLongNote(ch);
}

#endif // #ifndef __DDR_h__

/* XvCgԍ

	0-3   : ()
	4-7   : 肷Ƃ
	8-11	 : V̌
	12 : ǂ

	14 : Q[Wg 
	15 : Q[W	
	16 : Q[W΂P	  
	17 : Q[W΂Q		

	19,20 : (,E)
	21,22 : 肷Ƃ(,E)  
	23,24 : V̌(,E)

	25-30 : Perfect,Great...Miss,OUCH
	31	 : MAX COMBO

	32	 : BG-BMP(VGA) for MSD
	33	 : BG-BMP(VGA) for BMS

	34,35 : Cleared,Failed

	36 : OK
	37 : NG

	40-49 : R{̐0`9
	50	 : COMBO

	51-58 : SS,S,A,B,C,D,F,N
	59 : "RESULT"̕

	60-69 : Ug̐0`9
	70-79 : XRAp0-9

	80-87 : 󂪂ځ[ď(1P6 or 1P4+2P4)

	90-93 : SINGLE,DOUBLE,COUPLE,VERSUS
	94-96 : BASIC,ANOTHER,MANIAC

	100-355 : BMS #BMP00-FF

	356 : StageFile

	360-367 : HID,SUD,STE,SHUF,MIRR,LIT,MIN,FLAT

	369 : CD_big
	370 : łӂCD
	371 : ȃZ^Cgg

	390-392 : ȃZ̓Փx

	400 : Title
	401 : J[\
	402,403 : BM/DDR [hACR
	404 : Loading...
	405 : ڑACR
	406 : EAXACR

	410-413 : DDRCʏ
	414-417 : DDRC@

	420-429 : VVȃZ(󂫂Ȃc)

	430:Q[WP
	431:Q[WQ
	432:Q[WP
	433:Q[WQ

	435-441 : ^Cgj[
	442-448 : ^Cgj[

	450-499 : VVȃZ

// BM

	500-506 :  点܂ 1P
	507 : Sc 点܂

	508 : Q[Wx[X(Not Club)
	509 : Q[Wx[X(Club)

	511-515 : Great(Aj),Great(),Good,Bad,Poor
	520-529 : 0-9 Aj

	530 : 胉C

	533 : White OBJ Aj
	534 : Blue OBJ Aj
	535 : Sc OBJ Aj

	536 : 胉C΃Of(beatsyncAj)

	540-547 : 

	557 : AUTOPLAY PART
	558 : AUTOPLAY PART(16px)

	560-570 : fW^ (570͔\̂)

	571 : ߐ
	572 : c

	573 : 嗝΃t[1P
	574 : 嗝΃t[2P

	575 : keydown SC
	576 : keydown wh
	577 : keydown bl

	580-586 :  点܂ 2P
	587 : Sc 点܂

	590-594 : p[eBN

	600-609 : VVȃZŎgp

	610		: UgFOẗ
	611-614 : sJO\̈Aj(4) (W100*H45)
	615-618 : GREAT,GOOD,BAD,POOR (W100*H45)
	619,620 : TOTALNOTES,MAXCOMBO(W150*H40)
	621,622 : SCORE,TOTAL SCORE (W150*H60)
	630-639 : 葍EXRA\tHgiW18*H30j
	640		: Ugwi
	641 : UgOt̓_()
	642 : UgOt̓_()
	650,651 : Q[W΁
	652-661 : Q[WԊKi
	662,663 : Q[W

	670-673 : Cʏ()
	674-677 : C@()

	680-689 : e|ύX\pfW^(+)
	690-699 : e|ύX\pfW^(-)
	700 : e|ύX\p"+"
	701 : e|ύX\p""(+)
	702 : e|ύX\p"-"
	703 : e|ύX\p""(-)


	710-855 : L[RtBOACR

	859 : L[RtBOJ[\

	860-869 : WCpbh{^ԍ (0,2352)c10 7x6
	870-885 : WCpbhԍ (19,2352)c16 5x6

	890-896 : MIDICDEFGAB (13,2352)c7 5x6
	897     : MIDI (13,2412) 6x6
	900-910 : MIDIIN^[uԍ[0-10](7,2352)c11 5x6

	920-1100 : O[oV[Ŏgp

	1200 : gBGApXvCg

	1250-1253 : t[YA[ 4-Arrow
	1255-1258 : t[YA[ 4-Arrow
	1260-1263 : t[YA[D 4-Arrow
	1280-1285 : t[YA[ 6-Arrow
	1290-1295 : t[YA[ 6-Arrow
	1300-1305 : t[YA[D 6-Arrow

	1310-1329 : VVȃZ

	// #define MAX_SPRITE 2048

*/

/* BMPԍ

// 
  2 : Door
  8 : Total
  9 : valuation
 10 : score
 11 : result
 12 : Cleared
 13 : Failed
 15 : mode
 16 : CD
 17 : CD_big
// 18 : datainfo.bmp
// 19 : difficulty.bmp
 20 : title.bmp
 21 : fan_ddr.bmp
 22 : connect.bmp
 23 : eax.bmp
 24 : cursor.bmp
 25 : title-menu.bmp
 26 : title-mode.bmp
 27 : loading.bmp

// 26 : gamemode-3.bmp
//(27, "Image\\title_1.bmp

   32	 : BG-BMP(VGA) for MSD
   33	 : BG-BMP(VGA) for BMS

 40 - 63 : BM

 65-79܂ŐVVȃZ

 80 : tempo_percent.bmp

 81 : KeyInfo.bmp

 // Xe[^Xo[
 83 : BMPtHg(126x35).bmp
 84 : BMPtHg(126x35).bmp
 85 : BMPtHg(126x35).bmp
 86 : ՃACR(26x22).bmp
 87 : BMPtHgD(126x35).bmp








 100-355:BMS #BMP00-FF
 356 : StageFile

// DDR
  0 : Allow
  1 : FAllow
  3 : Gauge
  4 : Allow2
  5 : FAllow2
  6 : Judgment
  7 : Combo
 10 : score
 14 : Light
 21 : fan_ddr.bmp
 
   32	 : BG-BMP(VGA) for MSD
   33	 : BG-BMP(VGA) for BMS

// BM
 40 : button
 41 : button-r
 42 : 2dx_main.bmp
 43 : judg2dx
 44 : main_club
 45 : object
 46 : green
 48 : autoplay
 49 : number
 50 : glinex()
 51 : gliney(c)
// 52 : autoplay16
 53 : stone
 54 : keydown
 55 : explosion.bmp
 56 : judgeline

 57 : result-back.bmp
 58 : result-box.bmp
 59 : result-font.bmp
 60 : result-graph.bmp
 61 : result-point.bmp

 62 : 2dx_gauge.bmp

 65 : fan.bmp

 68 : particle.bmp

 100-355:BMS #BMP00-FF
 356 : StageFile

 400 : t[YA[.bmp


*/

/*
	Waveԍ
	萔`consts.h

	0:MSDBGM

	10 : title.mp3
	11 : select.mp3
	12 : option.mp3
	13 : ms_left.mp3
	14 : ms_right.mp3
	15 : ms_decide.mp3
	16 : bm_cleared.mp3
	17 : bm_failed.mp3
	18 : ddr_cleared.mp3
	19 : ddr_failed.mp3
	20 : juke_up.mp3
	21 : juke_down.mp3
	22 : keyconfig.mp3

	100:Reserved
	101-675:BMS #WAV01-FZ
	700-912:ShortWAVE(Ȃɓǂ񂾂玀ʂŁc)
*/
