//
// Particle class
//

// Copyright Delight Delight Reduplication Development Project 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "Particle.h"

extern struct tagOpt  opt;

CParticle::CParticle(){

	for(int i=0;i<MAX_PARTICLE;i++)
	{
		m_Particle[i].m_time = 0xFFFFFFFF;
		m_Particle[i].m_LostTime = 0;
	}

	m_lpDD = NULL;

}

CParticle::~CParticle(){

}

void CParticle::Init(nsDraw* dd, int numParticle, int iSpNumMin, int iSpNumMax){

	m_lpDD = dd;
	m_SpNumMin = iSpNumMin;
	m_SpNumMax = iSpNumMax;
	m_numParticle = numParticle;

}

void CParticle::SetPos(double x, double y){

	for(int i=0;i<m_numParticle;i++)
	{
		m_Particle[i].m_x = x;
		m_Particle[i].m_y = y;
		m_Particle[i].m_LastTime = timeGetTime();
	}

}

void CParticle::SetRndParam(void){

	#define rnd(n)		(rand()%(n))
	#define rndsign()	(rand()%2 ? 1 : -1)

	for(int i=0;i<m_numParticle;i++)
	{
		m_Particle[i].SpNum = m_SpNumMin + rnd(m_SpNumMax-m_SpNumMin);
		m_Particle[i].m_dx = rndsign() * (5.0 + rnd(100)/100.0 * 5.0);
		m_Particle[i].m_dy =            -(5.0 + rnd(100)/100.0 * 7.5);
		m_Particle[i].m_ax = 0.0;
		m_Particle[i].m_ay = 1.5;
		m_Particle[i].m_time = 0;
		m_Particle[i].m_LostTime = 200+rnd(200);
	}

}

void CParticle::Draw(void){

	if(m_lpDD==NULL)
		return;

	for(int i=0;i<m_numParticle;i++)
	{
		float alpha = 1.0f - (float)m_Particle[i].m_time/m_Particle[i].m_LostTime;
		if(opt.iEffect<=GE_MID) alpha = 1.0f;

		DWORD pastTime = (timeGetTime() - m_Particle[i].m_LastTime);
		m_Particle[i].m_time += pastTime;
		m_Particle[i].m_LastTime = timeGetTime();

		if(m_Particle[i].m_time < m_Particle[i].m_LostTime)
		{
			// ׂp[eBNMMX State̕ύXRXg傫̂ŁAMMX͎gȂ
			m_lpDD->BlendBlt(m_Particle[i].SpNum, int(m_Particle[i].m_x), int(m_Particle[i].m_y), alpha, FALSE);

			m_Particle[i].m_x += m_Particle[i].m_dx*((double)pastTime/16.6);
			m_Particle[i].m_y += m_Particle[i].m_dy*((double)pastTime/16.6);

			m_Particle[i].m_dx += m_Particle[i].m_ax*((double)pastTime/16.6);
			m_Particle[i].m_dy += m_Particle[i].m_ay*((double)pastTime/16.6);

		}
	}

}
