
// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __YTLAutoPtrEx_h__
#define __YTLAutoPtrEx_h__

template<class T> class auto_ptrEx {
public:
	typedef T element_type;
	explicit auto_ptrEx(T *_P = 0)
		: m_bOwner(_P != 0), m_lp(_P) {}
	auto_ptrEx(const auto_ptrEx<T>& _Y) {
		SetOwner(_Y.IsOwner());
		const_cast<auto_ptrEx<T>*>(&_Y)->SetOwner(false);
		m_lp = _Y.m_lp;
	}
	auto_ptrEx<T>& operator=(const auto_ptrEx<T>& _Y) {
		if (this != &_Y) {
			if (m_lp != _Y.m_lp) {
				if (IsOwner()) delete m_lp;	//	LĂ΂
				SetOwner(_Y.IsOwner());	//	ɏLȂ΁Aړ
				const_cast<auto_ptrEx<T>*>(&_Y)->SetOwner(false);
				m_lp = _Y.m_lp;
			} else {
				SetOwner(_Y.IsOwner());	//	ɏLȂ΁Aړ
				const_cast<auto_ptrEx<T>*>(&_Y)->SetOwner(false);
			}
		}
		return (*this);
	}
	~auto_ptrEx() { if (IsOwner()) delete m_lp;	}
	T& operator*() const  {return *get(); }
	T* operator->() const {return get();  }
	T* get() const { return m_lp; }
	T* release() const {
		//	́LXgȂthisconst̂m_bOwnerɃANZXłȂ(fake this)
		((auto_ptrEx<T> *)this)->m_bOwner = false;
		T* tmp = m_lp;
		((auto_ptrEx<T> *)this)->m_lp	  = NULL;
		return tmp;
	}

	////////////////////////////////////////////////////////
	//	auto_ptrExIWi

	//	L̔jƃIuWFNg̉\
	void Delete(){
		if (IsOwner()) {
			delete release();	//	fixed '00/11/29
		} else {
			((auto_ptrEx<T> *)this)->m_bOwner = false;
			((auto_ptrEx<T> *)this)->m_lp	  = NULL;
		}
	}

	//	LCX^X̒ǉ\
	void Add(){
		Delete();
		m_lp = new T;		//	x
		SetOwner(true);
	}
	void Add(T*_P){			//	|[tBbNȌ^ł
		Delete();
		if (_P) {
			m_lp	= _P;
			SetOwner(true);
		}
	}
	//	̂Q̊֐Pɂ܂Ƃ߂
	//	new T̕ŁAT ۃNXƃRpCG[ɂȂB

	auto_ptrEx<T>& operator=(const T* _P) {
		//	EӒl̓|C^łāȀL҂ɂĂ͔Ȃ
		if (m_lp != _P) {
			Delete();	//	āAAL͖̂Ƃ
			m_lp = const_cast<T*>(_P);
		}
		return (*this);
	}

	//	I[i[ł邩Ԃ֐
	bool	IsOwner() const { return m_bOwner; }
	//	I[i[̐ݒ
	void	SetOwner(bool b) { m_bOwner = b; }
	//	@炪auto_ptr炱̃NXhȂ

	//	̂͂܂ׂłȂA
	//	ꉞT*ƃRp`reBۂB
	operator T* () const { return get(); }

private:
	bool	m_bOwner;
	T		*m_lp;
};

#endif
