//	yaneAcm.cpp

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

//#include "stdafx.h"
#include "yaneAcm.h"

extern void WriteLog(const char* Format,...);

CAcm::CAcm(void){
	m_bOpen = false;
}

CAcm::~CAcm(){
	Close();
}


LRESULT CAcm::Open(WAVEFORMATEX *pWFormat,LPVOID lpSrcBuf,DWORD dwSrcLength){
	Close();

	//	Y񂤂ɈRs[:p
	m_lpSrcWFormat	= pWFormat;
	m_lpSrcBuf		= lpSrcBuf;
	m_dwSrcLength	= dwSrcLength;

	//	\̏
	ZERO(m_destWFormat);
	ZERO(m_acmheader);
	m_hAcm	= NULL;
	m_dwDestLength = 0;

	m_destWFormat.wFormatTag = WAVE_FORMAT_PCM;	//	PCMɂȂė~˂I
	if (acmFormatSuggest(NULL,pWFormat,&m_destWFormat,sizeof(WAVEFORMATEX),ACM_FORMATSUGGESTF_WFORMATTAG)!=0){
		return 1;	//	acmƂႤH
	}
	if (acmStreamOpen(&m_hAcm,NULL,pWFormat,&m_destWFormat,NULL,NULL,NULL,ACM_STREAMOPENF_NONREALTIME)!=0){
		return 2;	//	acmƂႤH
	}
	if (acmStreamSize(m_hAcm,dwSrcLength,&m_dwDestLength,ACM_STREAMSIZEF_SOURCE)!=0){
		return 3;	//	Ȃł˂ƌi΁j
	}

	if (m_dwDestLength == 0) return 4;	//	Ȃ[

	m_bOpen = true;	//	OpenɐBCɈڂ:p
	return 0;
}

LRESULT CAcm::Open(LPBYTE src,DWORD size){	//	MP3̃t@CƂI[v:p

	//	t[wb_WAVEFORMATEX̃f[^pӂ

	if (size <= 128) return 1; // ȏ킯ւ񂪂:p

	//  ID3v2^OĂȂ΁Aǂݔ΂
	if ((src[0] == 'I') && (src[1] == 'D') && (src[2] == '3'))
	{
		DWORD dwID3Size = src[9] + (src[8]<<7) + (src[7]<<14) + (src[6]<<21);

		// o[W`FbN
		if(src[3]>=0x04)
		{
			// ID3v2.4.0ȍ~
			if(src[5]&0x10)
				dwID3Size+=20; // tb^
			else
				dwID3Size+=10; // tb^Ȃ
		}
		else
		{
			// ID3v2.3.0ȑO
			dwID3Size+=10; // tb^Ȃ
		}
	    if (size <= dwID3Size + 128) return 1;

		src += dwID3Size;
		size -= dwID3Size;
	}

	//	MP3`FbN
	/*
		rbg	12bit	ׂẴrbg1 (0xfff) MPEG2.5ł͍Ōオ0 
		o[W	1bit	0: MPEG-2 or MPEG2.5  1: MPEG-1
		C		2bit	11: CI 10: CII 01:CIII 
		G[ی	1bit	0: L  1: 
		rbg[g	4bit	Ή\Q 
	*/
//	if ((src[1]&0xf8) !=0xf8) return 1;
	if ((src[0]!=0xff)||((src[1]&0xe0)!=0xe0)) // MPEG2.5ɂΉȂ炱ȁH
	{
		WriteLog("CAcm::Open() : MP3̃wb_(rbg)sł");
		return 1;
	}

	int	anBitrate[2][3][16] = {
		{
		// MPEG-1
			{ 0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,0 },	//	32000Hz(layer1)
			{ 0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,0 },	//	44100Hz(layer2)
			{ 0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,0 },	//	48000Hz(layer3)
		},
		{
		// MPEG-2
			{ 0,32,48,56, 64, 80, 96,112,128,144,160,176,192,224,256,0 },	//	32000Hz(layer1)
			{ 0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0 },	//	44100Hz(layer2)
			{ 0, 8,16,24, 32, 40, 48, 56, 64, 80, 96,112,128,144,160,0 },	//	48000Hz(layer3)
		},
	};
	int anFreq[2][4] = {
		{ 44100,48000,32000,0 },
		{ 22050,24000,16000,0 },
	};

	int nLayer		= 4-((src[1] >> 1) & 3);
	if (nLayer == 4) {
//		Err.Out("CAcm::Open MP3ȃC");
		WriteLog("CAcm::Open() : MP3̃wb_(C[ԍ)sł");
		return 1;
	}
	
	int nMpeg		= ((src[1] & 8) == 0) ? 1 : 0;
	int nBitrate	= anBitrate[nMpeg][nLayer-1][ src[2]>>4 ];
	int nFreq		= anFreq[nMpeg][(src[2] >> 2) & 3];
	int nChannel	= ((src[3] >> 6) == 3) ? 1 : 2;
	int nFrameSize	= 144000 * nBitrate / nFreq;

	//	MP3̃^Opӂ
	ZERO(m_WFormat);
	m_WFormat.wfx.cbSize			= MPEGLAYER3_WFX_EXTRA_BYTES;
	m_WFormat.wfx.wFormatTag		= WAVE_FORMAT_MPEGLAYER3;
	m_WFormat.wfx.nChannels			= nChannel;
	m_WFormat.wfx.nSamplesPerSec	= nFreq;
	m_WFormat.wfx.nAvgBytesPerSec	= nBitrate * 1000 / 8;
	m_WFormat.wfx.nBlockAlign		= 1;
	m_WFormat.wfx.wBitsPerSample	= 0;
	m_WFormat.wID					= MPEGLAYER3_ID_MPEG;
	m_WFormat.fdwFlags				= MPEGLAYER3_FLAG_PADDING_OFF;
	m_WFormat.nBlockSize			= nFrameSize;
	m_WFormat.nFramesPerBlock		= 1;
	m_WFormat.nCodecDelay			= 0x0571;

	//	ID3^OĂȂ΁A̕O
	if ((src[size-128] == 'T') && (src[size-127] == 'A') && (src[size-126] == 'G')) {
		size-= 128;
	}

	return Open((WAVEFORMATEX*)&m_WFormat,(LPVOID)(src+4),size-4);

};

WAVEFORMATEX* CAcm::GetFormat(void) {
	if (m_bOpen) return &m_destWFormat;
	return NULL;//	OpenĂւ̂ɌĂԂȁ`I
}

DWORD CAcm::GetSize(void) const {
	if (m_bOpen) return m_dwDestLength;
	return 0;	//	OpenĂւ̂ɌĂԂȁ`I
}

LRESULT CAcm::Convert(LPVOID lpDestBuf){
	//	DirectSoundLock|C^n

	if (!m_bOpen) {
		WriteLog("CAcm::Convert() : OpenłĂւ̂ɌĂԂȁI");
		return 1;	//	OpenłĂւ̂ɌĂԂȂ[ɁI
	}
	m_acmheader.cbStruct		=	sizeof(m_acmheader);
	m_acmheader.pbSrc			=	(BYTE*)m_lpSrcBuf;
	m_acmheader.cbSrcLength		=	m_dwSrcLength;
	m_acmheader.pbDst			=	(BYTE*)lpDestBuf;		//	ɃRs[˂I
	m_acmheader.cbDstLength		=	m_dwDestLength;
	HRESULT res;
	res = acmStreamPrepareHeader(m_hAcm,&m_acmheader,NULL);
	if (res!=0) {
		switch(res)
		{
		case MMSYSERR_INVALFLAG:	WriteLog("CAcm::Convert() : acmStreamPrepareHeader()sI(Reason:MMSYSERR_INVALFLAG)");	break;
		case MMSYSERR_INVALHANDLE:	WriteLog("CAcm::Convert() : acmStreamPrepareHeader()sI(Reason:MMSYSERR_INVALHANDLE)");	break;
		case MMSYSERR_INVALPARAM:	WriteLog("CAcm::Convert() : acmStreamPrepareHeader()sI(Reason:MMSYSERR_INVALPARAM)");	break;
		case MMSYSERR_NOMEM:		WriteLog("CAcm::Convert() : acmStreamPrepareHeader()sI(Reason:MMSYSERR_NOMEM)");		break;
		default:					WriteLog("CAcm::Convert() : acmStreamPrepareHeader()sI(Reason:Unknown(0x%08x))", res);	break;
		}
		return 2;	//	قā`i΁j
	}

	res = acmStreamConvert(m_hAcm,&m_acmheader,NULL);
	if (res!=0){
		switch(res)
		{
		case MMSYSERR_INVALFLAG:	WriteLog("CAcm::Convert() : acmStreamConvert()sI(Reason:MMSYSERR_INVALFLAG)");	break;
		case MMSYSERR_INVALHANDLE:	WriteLog("CAcm::Convert() : acmStreamConvert()sI(Reason:MMSYSERR_INVALHANDLE)");break;
		case MMSYSERR_INVALPARAM:	WriteLog("CAcm::Convert() : acmStreamConvert()sI(Reason:MMSYSERR_INVALPARAM)");	break;
		case ACMERR_BUSY:			WriteLog("CAcm::Convert() : acmStreamConvert()sI(Reason:ACMERR_BUSY)");			break;
		case ACMERR_UNPREPARED:		WriteLog("CAcm::Convert() : acmStreamConvert()sI(Reason:ACMERR_UNPREPARED)");	break;
		default:					WriteLog("CAcm::Convert() : acmStreamConvert()sI(Reason:Unknown(0x%08x))", res);break;
		}
		return 3;	//	_i΁j
	}
	return 0;	//	CI
}

LRESULT CAcm::Close(void) {
	if (m_bOpen) {
		m_bOpen = false;
		acmStreamUnprepareHeader(m_hAcm,&m_acmheader,NULL);
		return acmStreamClose(m_hAcm,NULL);
	}
	return 0;
}

bool	CAcm::IsOpen(void) const {
	return m_bOpen;
}
