// JoyStick Input Wrapper

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneJoyStick.h"
#include "yaneError.h"
#include "yaneMacro.h"


LRESULT CJoyStick::Initialize(HWND hWnd,HINSTANCE hInst){  // 
	Terminate(); // IɂďiÔ߁j

//	m_nButtonMax	=	2;
	m_bSuccessInit	=	false;
	
	if (joyGetNumDevs() == 0) return 1;	//	WCXeBbNւ...

	JOYCAPSA joyCaps;
	if (m_joystick_selector == jsJOYSTICK1){
		if ( joyGetDevCaps(JOYSTICKID1,&joyCaps,sizeof(joyCaps)) == JOYERR_NOERROR) {
			m_uID = JOYSTICKID1;
		} else return 2;	// failed...
	} else if (m_joystick_selector == jsJOYSTICK2){
		if ( joyGetDevCaps(JOYSTICKID2,&joyCaps,sizeof(joyCaps)) == JOYERR_NOERROR) {
			m_uID = JOYSTICKID2;
		} else return 2;	// failed...
	} else if (m_joystick_selector == jsJOYSTICK1OR2){
		if ( joyGetDevCaps(JOYSTICKID1,&joyCaps,sizeof(joyCaps)) == JOYERR_NOERROR) {
			m_uID = JOYSTICKID1;
		} else if ( joyGetDevCaps(JOYSTICKID2,&joyCaps,sizeof(JOYCAPS)) == JOYERR_NOERROR) {
			m_uID = JOYSTICKID2;
		} else return 2;	// failed...
	}

	//	Z^[̓j[g낤APFQɓƂ臒lƂ
	m_uX1	=	(joyCaps.wXmax	 +	joyCaps.wXmin*2)/3;
	m_uX2	=	(joyCaps.wXmax*2 +	joyCaps.wXmin  )/3;
	m_uY1	=	(joyCaps.wYmax	 +	joyCaps.wYmin*2)/3;
	m_uY2	=	(joyCaps.wYmax*2 +	joyCaps.wYmin  )/3;

	m_nButtonMax = joyCaps.wNumButtons; // {^擾 by Nickle
	if(m_nButtonMax>32) m_nButtonMax = 32;

	JOYINFO joyinfo;	//	ۂɓǂݍ߂̂mFĂKv
	if (joyGetPos(m_uID,&joyinfo)!= JOYERR_NOERROR) return 2;

	m_bSuccessInit	=	true;

	return 0;
}

// ---------------------------------------------------------------------------
LRESULT CJoyStick::Terminate(void){ // I
	//	ȁ[܂:p
	return 0; // I
}

// ---------------------------------------------------------------------------

LRESULT CJoyStick::GetKeyState(void){
	
	if (!m_bSuccessInit) return 1;	//	݂AsƂ邪..

	//	obt@flip!
	FlipKeyBuffer(m_nKeyBufNo);

	//	{^Sȉ̂Ƃ́AjoyGetPosŏ\...
	if(m_nButtonMax<=4){
		UINT x,y,b;
		//	{Ȃ΁AR[obN֐ɂăbZ[Wnhpӂׂ...
		JOYINFO joyinfo;
		if (joyGetPos(m_uID,&joyinfo)!= JOYERR_NOERROR) return 2;
		x = WORD(joyinfo.wXpos);		//	XW
		y = WORD(joyinfo.wYpos);		//	YW
		b = WORD(joyinfo.wButtons);		//	{^
		m_byKeyBuffer[m_nKeyBufNo][0] = y<m_uY1?1:0;	//	
		m_byKeyBuffer[m_nKeyBufNo][1] = y>m_uY2?1:0;	//	
		m_byKeyBuffer[m_nKeyBufNo][2] = x<m_uX1?1:0;	//	
		m_byKeyBuffer[m_nKeyBufNo][3] = x>m_uX2?1:0;	//	E
		//	Sԁ`RTiőjԂ܂łAe{^łI
		//	SԂ{^PCTԂ{^QDDȉRTԂ܂
		for(UINT i=0;i<m_nButtonMax;i++){
			m_byKeyBuffer[m_nKeyBufNo][i+4] = b & 1;
			b >>= 1;
		}
	} else {
		DWORD x,y,b;
		JOYINFOEX joyinfo;
		joyinfo.dwSize	= sizeof(JOYINFOEX);
		joyinfo.dwFlags	= JOY_RETURNALL;
		if (joyGetPosEx(m_uID,&joyinfo)!= JOYERR_NOERROR) return 2;
		x = WORD(joyinfo.dwXpos);		//	XW
		y = WORD(joyinfo.dwYpos);		//	YW
		b = joyinfo.dwButtons;	//	{^
		m_byKeyBuffer[m_nKeyBufNo][0] = y<m_uY1?1:0;	//	
		m_byKeyBuffer[m_nKeyBufNo][1] = y>m_uY2?1:0;	//	
		m_byKeyBuffer[m_nKeyBufNo][2] = x<m_uX1?1:0;	//	
		m_byKeyBuffer[m_nKeyBufNo][3] = x>m_uX2?1:0;	//	E
		for(UINT i=0;i<m_nButtonMax;i++){
			m_byKeyBuffer[m_nKeyBufNo][i+4] = BYTE(b & 1);
			b >>= 1;
		}
	}
	return 0;
}

// L[̖OԂ by Nickle
char* CJoyStick::GetKeyName(int key){

	// Q̂ݑΉ :-p

	if(m_joystick_selector==jsJOYSTICK1) // E\()
	{
		switch(key)
		{
		case  0: return "J1 Y-";	break;
		case  1: return "J1 Y+";	break;
		case  2: return "J1 X-";	break;
		case  3: return "J1 X+";	break;
		case  4: return "J1 B1";	break;
		case  5: return "J1 B2";	break;
		case  6: return "J1 B3";	break;
		case  7: return "J1 B4";	break;
		case  8: return "J1 B5";	break;
		case  9: return "J1 B6";	break;
		case 10: return "J1 B7";	break;
		case 11: return "J1 B8";	break;
		case 12: return "J1 B9";	break;
		case 13: return "J1 B10";	break;
		case 14: return "J1 B11";	break;
		case 15: return "J1 B12";	break;
		case 16: return "J1 B13";	break;
		case 17: return "J1 B14";	break;
		case 18: return "J1 B15";	break;
		case 19: return "J1 B16";	break;
		case 20: return "J1 B17";	break;
		case 21: return "J1 B18";	break;
		case 22: return "J1 B19";	break;
		case 23: return "J1 B20";	break;
		case 24: return "J1 B21";	break;
		case 25: return "J1 B22";	break;
		case 26: return "J1 B23";	break;
		case 27: return "J1 B24";	break;
		case 28: return "J1 B25";	break;
		case 29: return "J1 B26";	break;
		case 30: return "J1 B27";	break;
		case 31: return "J1 B28";	break;
		case 32: return "J1 B29";	break;
		case 33: return "J1 B30";	break;
		case 34: return "J1 B31";	break;
		case 35: return "J1 B32";	break;
		}
	}
	else
	{
		switch(key)
		{
		case  0: return "J2 Y-";	break;
		case  1: return "J2 Y+";	break;
		case  2: return "J2 X-";	break;
		case  3: return "J2 X+";	break;
		case  4: return "J2 B1";	break;
		case  5: return "J2 B2";	break;
		case  6: return "J2 B3";	break;
		case  7: return "J2 B4";	break;
		case  8: return "J2 B5";	break;
		case  9: return "J2 B6";	break;
		case 10: return "J2 B7";	break;
		case 11: return "J2 B8";	break;
		case 12: return "J2 B9";	break;
		case 13: return "J2 B10";	break;
		case 14: return "J2 B11";	break;
		case 15: return "J2 B12";	break;
		case 16: return "J2 B13";	break;
		case 17: return "J2 B14";	break;
		case 18: return "J2 B15";	break;
		case 19: return "J2 B16";	break;
		case 20: return "J2 B17";	break;
		case 21: return "J2 B18";	break;
		case 22: return "J2 B19";	break;
		case 23: return "J2 B20";	break;
		case 24: return "J2 B21";	break;
		case 25: return "J2 B22";	break;
		case 26: return "J2 B23";	break;
		case 27: return "J2 B24";	break;
		case 28: return "J2 B25";	break;
		case 29: return "J2 B26";	break;
		case 30: return "J2 B27";	break;
		case 31: return "J2 B28";	break;
		case 32: return "J2 B29";	break;
		case 33: return "J2 B30";	break;
		case 34: return "J2 B31";	break;
		case 35: return "J2 B32";	break;
		}
	}

	return "btn>32"; // Ȃ

}
