// yaneKeyBase.h
//	 This is a based wrapper of input.
//		programmed by yaneurao(M.Isozaki) '99/11/13

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef __yaneKeyBase_h__
#define __yaneKeyBase_h__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

// ---------------------------------------------------------------------------
// bufferflip! (C)yaneurao
#define FlipKeyBuffer(var) \
	var = 1 - var;
// ---------------------------------------------------------------------------

class CKeyBase {
public:
	CKeyBase(void);
	~CKeyBase();
	//////////////////////////////////////////////////////////////////
	virtual LRESULT	GetKeyState(void) = 0;	// must be override...
	virtual bool	IsKeyPress(int key);
	virtual bool	IsKeyPushDown(int key);
	virtual BYTE*	GetKeyData(void);

	virtual char*	GetKeyName(int key);	// keyԂ̃L[̖O擾 by Nickle
	//////////////////////////////////////////////////////////////////
protected:
	int		m_nKeyBufNo;				//	ƕ\flipāAƂ̂ɗp
	BYTE	m_byKeyBuffer[2][256];		//	key buffer
};

#endif
