// MIDI input Wrapper

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneMIDIInput.h"
#include "yaneError.h"
#include "yaneMacro.h"

//////////////////////////////////////////////////////////////////////////////
// bufferflip! (C)yaneurao
#define FlipKeyBuffer(var) \
	var = 1 - var;
//////////////////////////////////////////////////////////////////////////////

LRESULT CMIDIInput::Initialize(HWND hWnd,HINSTANCE hInst){	// 
	Terminate(); // IɂďiÔ߁j

	ZERO(m_byKeyBuffer2);
	m_byKeyBuffer2[252] = 128; // for Pitch bend <by Nickle>

	m_bSuccessInit	=	false;

	nNumDevices = midiInGetNumDevs();

	if (nNumDevices <0) return 1;
	// 擾ł񂩂炱̊֐̂̓G[ 

	for(int i=0;(i < nNumDevices) && (i<MAX_MIDI_CH);i++){
		midiInOpen((LPHMIDIIN)&hMidiIn[i],i
			,(DWORD)MidiInProc,NULL,CALLBACK_FUNCTION);
		// ǂ̃`l̐M݂ȕɈI
		if (hMidiIn[i])
			midiInStart(hMidiIn[i]);
	}

	m_bSuccessInit	=	true;
	return 0;
}

//////////////////////////////////////////////////////////////////////////////
LRESULT CMIDIInput::Terminate(void){ // I
	if (m_bSuccessInit) {
		for(int i=0;(i < nNumDevices) && (i<MAX_MIDI_CH);i++){
			midiInStop(hMidiIn[i]);
			midiInReset(hMidiIn[i]);
			midiInClose(hMidiIn[i]);
		}
	}
	return 0; // I
}
//////////////////////////////////////////////////////////////////////////////

BYTE	CMIDIInput::m_byKeyBuffer2[256];		//	real time key buffer

void CALLBACK CMIDIInput::MidiInProc(HMIDIIN hMidiIn, WORD wMsg, DWORD dwInstance,
						   DWORD dwParam1, DWORD dwParam2)
{
// Note OnOffm_byKeyBuffer2ύX

	int Status = dwParam1 & 0xf0;			// Status
	int Key = (dwParam1 >> 8) & 0xff;		// data1
	int Velocity = (dwParam1 >> 16) & 0xff; // data2

	switch (wMsg){
	case MIM_DATA:
		switch (Status) {
		case 0x90:
			// Note On or Off
			m_byKeyBuffer2[Key] = Velocity;
			break;
		case 0x80:
			// ꂪNote OffŗL蓾
			m_byKeyBuffer2[Key] = 0;
			break;
		case 0xb0:
			if (Key == 0x43)	  m_byKeyBuffer2[253] = Velocity; // left pedal
			else if (Key == 0x42) m_byKeyBuffer2[254] = Velocity; // middle pedal
			else if (Key == 0x40) m_byKeyBuffer2[255] = Velocity; // right pedal
			else if (Key == 0x01) m_byKeyBuffer2[251] = Velocity; // modulation wheel <by Nickle>
			break;
		case 0xe0:
			// Pitch bend
			// Velocity,Key͊e0-127AVelocityMSBAKeyLSB
			// 0-255ɃXP[O
			m_byKeyBuffer2[252] = (((Velocity&0x7f)<<7)|(Key&0x7f))>>6; // pitch bend(center:128) <by Nickle>
			break;
		}

	// ̃bZ[W͖I
	}
	
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CMIDIInput::GetKeyState(void){

	if (!m_bSuccessInit) return 1;	//	݂AsƂ邪..
	FlipKeyBuffer(m_nKeyBufNo);

	// QTUoCg݂̏ԂƂĎ擾I
	CopyMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),
			   (LPVOID)&(m_byKeyBuffer2[0]),256);

	// 241Ԃmod.XNb`Iœǂݎ by Nickle
	int movval = 0; // ړ
	int movsgn = 0; // ړ movval̕
	static int movsgnold = 0; // Omovval
	movval = m_byKeyBuffer[m_nKeyBufNo][251] - m_byKeyBuffer[1-m_nKeyBufNo][251];
	movsgn = (movval<0 ? -1 : (movval==0 ? 0 : 1));

	// n߂ƂTrue,邢͓ɓÂĂƂTrue
//	if(movsgnold==0 && movsgn!=0)
//		m_byKeyBuffer[m_nKeyBufNo][241] = 1;
	
	if(movsgnold==movsgn && movsgn!=0)
		m_byKeyBuffer[m_nKeyBufNo][241] = 1;

	movsgnold = movsgn;

	// 242,243ԂP.B̂ƂA㑤̂ƂTrue by Nickle
	m_byKeyBuffer[m_nKeyBufNo][242] = (m_byKeyBuffer[m_nKeyBufNo][252]<128);
	m_byKeyBuffer[m_nKeyBufNo][243] = (m_byKeyBuffer[m_nKeyBufNo][252]>128);

	return 0;
}

// keyԂ̃L[̖O擾 by Nickle
char* CMIDIInput::GetKeyName(int key){

	// sAm̈ԍA0, ̃hC4, E[G8
	//					h	   h#	   	  #	  ~	 t@	t@#	\	   \#	   	  #	  V
	char* tbl[256] = { "C-1", "C#-1", "D-1", "D#-1", "E-1", "F-1", "F#-1", "G-1", "G#-1", "A-1", "A#-1", "B-1", // 0
					   "C0" , "C#0" , "D0" , "D#0" , "E0" , "F0" , "F#0" , "G0" , "G#0" , "A0" , "A#0" , "B0" , // 12
					   "C1" , "C#1" , "D1" , "D#1" , "E1" , "F1" , "F#1" , "G1" , "G#1" , "A1" , "A#1" , "B1" , // 24
					   "C2" , "C#2" , "D2" , "D#2" , "E2" , "F2" , "F#2" , "G2" , "G#2" , "A2" , "A#2" , "B2" , // 36
					   "C3" , "C#3" , "D3" , "D#3" , "E3" , "F3" , "F#3" , "G3" , "G#3" , "A3" , "A#3" , "B3" , // 48
					   "C4" , "C#4" , "D4" , "D#4" , "E4" , "F4" , "F#4" , "G4" , "G#4" , "A4" , "A#4" , "B4" , // 60
					   "C5" , "C#5" , "D5" , "D#5" , "E5" , "F5" , "F#5" , "G5" , "G#5" , "A5" , "A#5" , "B5" , // 72
					   "C6" , "C#6" , "D6" , "D#6" , "E6" , "F6" , "F#6" , "G6" , "G#6" , "A6" , "A#6" , "B6" , // 84
					   "C7" , "C#7" , "D7" , "D#7" , "E7" , "F7" , "F#7" , "G7" , "G#7" , "A7" , "A#7" , "B7" , // 96
					   "C8" , "C#8" , "D8" , "D#8" , "E8" , "F8" , "F#8" , "G8" , "G#8" , "A8" , "A#8" , "B8" , // 108
					   "C9" , "C#9" , "D9" , "D#9" , "E9" , "F9" , "F#9" , "G9"								 	// 120
	};

	tbl[241] = "Mod.";
	tbl[242] = "P.B-";
	tbl[243] = "P.B+";

	tbl[253] = "L-Ped.";
	tbl[254] = "C-Ped.";
	tbl[255] = "R-Ped.";

	return tbl[key];

}
