//	yaneVirtualKey.cpp :

// Copyright yaneurao 1999 - 2007.
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "yaneVirtualKey.h"

bool	operator <(const CVKeyBase& x,const CVKeyBase& y)  { return x.m_key < y.m_key; }

//////////////////////////////////////////////////////////////////////////////
CVirtualKey::CVirtualKey(void){
	ClearKeyDevice();
	ClearKeyList();
}

CVirtualKey::~CVirtualKey() {}
//////////////////////////////////////////////////////////////////////////////

//	L[foCX̓o^
void	CVirtualKey::ClearKeyDevice(void){
	m_nDeviceMax = 0;
}

void	CVirtualKey::AddDevice(CKeyBase* keybase){
	m_lpDevice[m_nDeviceMax++] = keybase;
}

void	CVirtualKey::RemoveDevice(CKeyBase* keybase){
	//	STLgĂȂ̂ŎOerase:p
	for(int i=0;i<m_nDeviceMax;i++){
		if (m_lpDevice[i]==keybase){
			for(int j=i+1;j<m_nDeviceMax;j++){
				m_lpDevice[i]=m_lpDevice[j];
			}
			m_nDeviceMax--;
		}
	}
}

void	CVirtualKey::KeyInput(void){
	for(int i=0;i<m_nDeviceMax;i++)
		m_lpDevice[i]->GetKeyState();
}

//////////////////////////////////////////////////////////////////////////////

//	zL[̒ǉE폜
void	CVirtualKey::ClearKeyList(void){
	for(int i=0;i<VIRTUAL_KEY_MAX;i++)
		m_VKey[i].clear();
}

void	CVirtualKey::AddKey(int vkey,CKeyBase* base,int key){
	CVKeyBase	keybase;
	keybase.m_lpKeyBase = base;
	keybase.m_key		= key;
	m_VKey[vkey].insert(keybase);
}

void	CVirtualKey::RemoveKey(int vkey,CKeyBase* base,int key){
	CVKeyBase	keybase;
	keybase.m_lpKeyBase = base;
	keybase.m_key		= key;
	m_VKey[vkey].erase(keybase);
}

//////////////////////////////////////////////////////////////////////////////

bool	CVirtualKey::IsVKeyPress(int vkey){					//	zL[𒲂ׂ
	set<CVKeyBase>::iterator it;
	it = m_VKey[vkey].begin();
	while (it!=m_VKey[vkey].end()) {
		if ((*it).m_lpKeyBase->IsKeyPress((*it).m_key)) return true;
		it++;
	}
	return false;
}
bool	CVirtualKey::IsVKeyPushDown(int vkey){				//	zL[𒲂ׂ
	set<CVKeyBase>::iterator it;
	it = m_VKey[vkey].begin();
	while (it!=m_VKey[vkey].end()) {
		if ((*it).m_lpKeyBase->IsKeyPushDown((*it).m_key)) return true;
		it++;
	}
	return false;
}
