﻿(*----------------------------------------------------------------------------
-- Copyright 2020 Levashev Ivan Aleksandrovich                              --
--                                                                          --
-- Licensed under the Apache License, Version 2.0 (the "License");          --
-- you may not use this file except in compliance with the License.         --
-- You may obtain a copy of the License at                                  --
--                                                                          --
--     http://www.apache.org/licenses/LICENSE-2.0                           --
--                                                                          --
-- Unless required by applicable law or agreed to in writing, software      --
-- distributed under the License is distributed on an "AS IS" BASIS,        --
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --
-- See the License for the specific language governing permissions and      --
-- limitations under the License.                                           --
----------------------------------------------------------------------------*)

(***************************************************************************\
* Отладочный менеджер памяти                                                *
*****************************************************************************
* - Выделяет под объекты память страницами.                                 *
* - При освобождении страницы освобождаются логически, но так, что не может *
*   тот же виртуальный адрес быть повторно использован. Обращения к         *
*   уничтоженному объекту приводят к A/V сразу на месте без шанса погулять  *
*   по висячим указателям и попортить структуры данных.                     *
* - В силу специфики менеджеров памяти не добавляется в проект. Вместо      *
*   этого в список путей поиска добавляется директория SafeMM3, а в проекте *
*   перед всеми другими модулями указывается SafeMM3.Install.               *
* - Принцип действия предполагает постоянный расход виртуальной памяти, так *
*   что имеет смысл отдавать предпочтение 64разрядным сборкам.              *
* - Даже на Win64 при полной загрузке АРМ исчерпываются ресурсы. В связи с  *
*   этим применён вероятностный подход, и вероятность задаётся аргументами  *
*   InstallDebugMemoryManager в модуле Install. На слабых рабочих станциях  *
*   придётся уменьшать.                                                     *
*****************************************************************************
* Иван Левашев, май 2020                                                    *
****************************************************************************)

unit SafeMM3.Install;

interface

implementation

uses
  SafeMM3;

initialization
  InstallDebugMemoryManager
    ((* RandomVirtualChance   => *) 333,
     (* UseGuardPages         => *) False,
     (* UseDeveloperHintPages => *) False);
finalization
  // UninstallDebugMemoryManager;
end.
