//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/28/2012.
//

#ifndef dennco_DNEngine_h
#define dennco_DNEngine_h

class TKContainer;
class DNTimeKeeper;
class DNServerHTTP;
class DNServerSerialPort;

#include "TKLock.h"
#include "DNThread.h"

#include <string>

class DNEngine
{
public:
    DNEngine(const char *contentPath);
    virtual ~DNEngine();

    bool        startEngine();
    bool        stopEngine();
    
    bool        startHTTPServer(int portNumber);
    void        stopHTTPServer();

    bool        startSerialServer();
    void        stopSerialServer();

    void        setTickIntervalSec(float full, float signal, float input, float output);
    
    static void doTickThread(void *self);
    float       doClientGetRequest(const char* path);
    bool        doClientSetRequest(const char* path, const char* value);
    bool        doClientSetRequest(const char* path, float value);

    std::string getContainerRootPath();
    std::string getUIPath();
    
    bool        isValid() { return mValid; }

    static      void callbackSerialPortClosed(DNEngine *engine);
    
private:
    bool            parseSettingFile(const char *settingXML);
    bool            parseContainerFile(const char *containerRoot);
    
    TKContainer     *mContainer;
    int             mPortNumber;
    DNServerHTTP    *mHTTPServer;
    DNServerSerialPort  *mSerialServer;
    bool            mSerialServerEnabled;
    DNTimeKeeper    *mTimeKeeper;
    bool            mValid;
    std::string     mUIPath;

    DNThread        *mDoTickThread;
    int             mNumUpdateScan;
    
};

#endif
