//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/24/2012.
//

#ifndef DNSERVERBASE_H
#define DNSERVERBASE_H

#include "TKLock.h"

#include <string>

class DNEngine;

class DNServerBase
{
public:
    DNServerBase(DNEngine *engine) : mEngine(engine){}

    virtual ~DNServerBase(){}
    
    virtual bool    isRunning() = 0;
    virtual void    start() = 0;
    virtual void    stop() = 0;

    virtual void    doQueryRequest(std::string requestBody) = 0;
    virtual void    doSetRequest(std::string requestBody) = 0;

    DNEngine*       getEngine() { return mEngine; }

protected:
    DNEngine *mEngine;
};

#endif //DNSERVERBASE_H
