//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/28/2012.
//

#include "DNServerHTTPImpl.h"
#include "DNServerHTTP.h"
#include "DNServerBase.h"
#include "DNEngine.h"
#include "DNUtils.h"

#include <string>
#ifndef _MSC_VER
    #include <string.h>
#endif
#include <stdio.h>

const unsigned int DNServerHTTP::HTTPDEFAULTPORT = 50000;


DNServerHTTP::DNServerHTTP(DNEngine* engine) : DNServerBase(engine)
{
    impl = DNServerHTTPImpl::create(this, DNServerHTTP::clientRequestHandler);
}

DNServerHTTP::~DNServerHTTP()
{
    if (impl)
        delete impl;
}

bool DNServerHTTP::isRunning()
{
    return impl->isRunning();
}

void DNServerHTTP::start()
{
    impl->start();
}

void DNServerHTTP::stop()
{
    impl->stop();
}

void DNServerHTTP::setPortNumber(unsigned int portNumber)
{
    impl->setPortNumber(portNumber);
}

void DNServerHTTP::replyWithStatusCode(int code, const char* message)
{
    impl->replyWithStatusCode(code, message);
}

void DNServerHTTP::replyWithFile(const char* filePath)
{
    impl->replyWithFile(filePath);
}

//static
void DNServerHTTP::clientRequestHandler(DNServerHTTP *server, const char *path, const char *body)
{
    bool valid = true;
    std::string errorMsg;
    const char *p = path;
    if (strlen(p) > 7)
    {
        if (strncmp(p, "http://", 7) == 0)
        {
            p += 7;
        }
        else
        {
            valid = false;
            errorMsg = "Request path is not a valid HTTP path";
        }
    }
    else
    {
        valid = false;
        errorMsg = "Request path is not correct";
    }
    
    if (valid)
    {
        while(*p && *p != '/')
            p++;
    }
    if (!*p)
    {
        valid = false;
        errorMsg = "no request URL. It should be /get or /set";
    }
    
    bool isUIRequest = false;
    bool isQueryRequest = true;
    const char *pathPart = p;
    if (valid)
    {
        if (strlen(p) >= 3)
        {
            if (strncmp(p, "/ui",3) == 0)
            {
                isUIRequest = true;
            }
        }
        if (!isUIRequest && strlen(p) >= 4)
        {
            if (strncmp(p, "/get",4) == 0)
            {
                isQueryRequest = true;
                p+=4;
            }
            else if (strncmp(p, "/set",4) == 0)
            {
                isQueryRequest = false;
                p+=4;
            }
            else
            {
                valid = false;
                errorMsg = "request path is not valid. It should be /get or /set";
            }
            
        }
    }
    if (!isUIRequest && valid)
    {
        if (*p != 0 && *p != ' ' && *p != '?')
        {
            valid = false;
            errorMsg = "request path is not valid. It should be /get or /set";
        }
    }
    
    if (valid)
    {
        std::string response;
        if (isUIRequest)
        {
            server->doUIRequest(pathPart);
        }
        else if(isQueryRequest)
        {
            server->doQueryRequest(body);
        }
        else
        {
            server->doSetRequest(body);
        }
    }
    else
    {
        server->doBadRequest(errorMsg);
    }
    
}

void DNServerHTTP::doQueryRequest(std::string requestBody)
{
    const char *oc = requestBody.c_str();
    size_t oclen = strlen(oc);
    char *c = new char[oclen + 1];
    strncpy(c, oc, oclen + 1);
    
    std::string resultString;
    
    const char *value = c;
    const char *name = c;
    bool       first = true;
    while(*c)
    {
        c++;
        
        switch (*c)
        {
            case '&':
            case 0:
                *c = 0;
                
                if (value != name)
                {
                    if (strlen(name) == 4 && strncmp(name, "path", 4) == 0)
                    {
                        //valid request. do the query
                        float result = mEngine->doClientGetRequest(value);
                        if (!first)
                            resultString.append(1,',');
                        
                        char rs[16];
                        sprintf(rs, "%12f", result);
                        resultString.append(rs);
                    }
                }
                name = c + 1;
                break;
                
            case '=':
                *c = 0;
                value = c + 1;
                break;
        }
    }
    replyWithStatusCode(200, resultString.c_str());
}

void DNServerHTTP::doSetRequest(std::string requestBody)
{
    const char *oc = requestBody.c_str();
    size_t oclen = strlen(oc);
    char *c = new char[oclen + 1];
    strncpy(c, oc, oclen + 1);
    
    std::string resultString;
    
    const char *value = c;
    const char *name = c;
    int        cnt = 0;
    while(*c)
    {
        c++;
        
        switch (*c)
        {
            case '&':
            case 0:
                *c = 0;
                
                if (value != name)
                {
                    mEngine->doClientSetRequest(name, value);
                    cnt++;
                }
                name = c + 1;
                break;
                
            case '=':
                *c = 0;
                value = c + 1;
                break;
        }
    }
    
    char rs[16];
    sprintf(rs, "%12d", cnt);
    replyWithStatusCode(200, rs);
}

void DNServerHTTP::doUIRequest(const char *path)
{
    std::string filepath = getContentPath();
    trimString(filepath);
    if (filepath.at(filepath.length()-1) != '/')
    {
        filepath.append(1,'/');
    }
    filepath.append(path+1);
    replyWithFile(filepath.c_str());
    
}

void DNServerHTTP::doBadRequest(std::string errorMsg)
{
    replyWithStatusCode(400, errorMsg.c_str());
}

std::string DNServerHTTP::getContentPath()
{
    return mEngine->getContainerRootPath();
}
/*
//static
DNHTTPRequest* DNServerHTTP::parseHttpRequest(const char *message)
{
    size_t len = strlen(message);
    
    bool isPost = false;
    bool isValid = true;
    std::string path;
    std::string host;
    int contentLen = 0;
    std::string postbody;
    
    const char *p;
    if (len < 5)
    {
        //illegal message
        return NULL;
    }
    if (strncmp(message, "POST ", 5) == 0)
    {
        //POST message
        p = message + 4;
        isPost = true;
    }
    else if (strncmp(message, "GET ", 4) == 0)
    {
        //GET message
        p = message + 3;
        isPost = false;
    }
    else
    {
        //non supported message
        isValid = false;
    }
    
    //get URI
    if (isValid)
    {
        while (*p && *p == ' ' && *p != '\r' && *p != '\n')
        {
            p++;
        }
        if (!*p || *p == '\r' || *p == '\n')
        {
            isValid = false;
        }
        else
        {
            const char *s = p;
            while (*p && *p != ' ' &&  *p != '\r' && *p != '\n')
                p++;
            
            if (*p != ' ' && p - s < 1)
            {
                isValid = false;
            }
            else
            {
                path = std::string(s, p - s);
            }
        }
    }
    
    if (isValid)
    {
        while(*p)
        {
            if (*p == '\n' && *(p-1) == '\r')
            {
                break;
            }
            p++;
        }
        if (!*p)
            isValid = false;
    }
    
    if (isValid)
    {
        p++;
        const char *hs = p;
        const char *he = p-1;
        while (*p)
        {
            if (*p == '\n' && *(p-1) == '\r' && *(p-2) == '\n')
            {
                he = p;
            }
            p++;
        }
        
        p = hs;
        while(p <= he && *p)
        {
            if (*p == ':')
            {
                //Host:
                if (p-hs >= 5 && strncmp("Host", p-4, 4))
                {
                    p++;
                    const char *tmp = p;
                    while(p <= hs && *p && *p !='\r')
                    {
                        p++;
                    }
                    if (tmp < p - 1)
                    {
                        host = std::string(tmp, p - tmp - 1);
                    }
                }
                
                //Content-Length:
                if (p-hs >= 15 && strncmp("Content-Length", p-14,14))
                {
                    p++;
                    const char *tmp = p;
                    while(p <= hs && *p && *p !='\r')
                    {
                        p++;
                    }
                    if (tmp < p - 1)
                    {
                        contentLen = atoi(std::string(tmp, p - tmp - 1).c_str());
                    }                    
                }
            }
            
            p++;
        }
        
        //POST BODY
        if (isPost && contentLen>0)
        {
            int bl = 0;
            const char *ps = he+1;
            while (*(ps + bl) && bl < contentLen)
            {
                bl++;
            }
            
            postbody = std::string(ps, bl);
        }
    }
    
    if (isValid)
    {
        DNHTTPRequest *request = new DNHTTPRequest();
        request->isPost = isPost;
        request->uri = path;
        if (isPost)
        {
            request->postData = postbody;
        }
        return request;
    }
    else
    {
        return NULL;
    }
}
 */

