//  Copyright (c) 2012 Dennco Project
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//
//  Created by tkawata on 1/28/2012.
//

#ifndef DNSERVERHTTP_H
#define DNSERVERHTTP_H

#include "DNServerBase.h"

class DNServerHTTPImpl;

/*
class DNHTTPRequest
{
public:
    std::string uri;
    bool        isPost;
    std::string postData;
};
*/


class DNServerHTTP : public DNServerBase
{
public:
    DNServerHTTP(DNEngine *engine);
    virtual ~DNServerHTTP();
    
    virtual bool    isRunning();
    virtual void    start();
    virtual void    stop();

    virtual void    doQueryRequest(std::string requestBody);
    virtual void    doSetRequest(std::string requestBody);

    void setPortNumber(unsigned int portNumber);
    void replyWithStatusCode(int code, const char* message);
    void replyWithFile(const char* filePath);
    
    static const unsigned int HTTPDEFAULTPORT;
    
private:
    DNServerHTTPImpl *impl;
    
    static void clientRequestHandler(DNServerHTTP *server, const char *path, const char *body);
    void doUIRequest(const char *path);
    void doBadRequest(std::string errorMsg);
    
    std::string getContentPath();

//    static DNHTTPRequest*   parseHttpRequest(const char *message);
};

typedef void (*DNClientRequestHandler)(DNServerHTTP *server, const char *path, const char *body);

#endif // DNSERVERHTTP_H
